library IEEE, work;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use work.AddressMap.all;
use work.BusSignalTypes.all;
use work.AddressBook.all;

entity Matrix2D_Impl is
    Port (
        RST     : in std_logic;
        CLK     : in std_logic;
        -- input signal --
        enFBH  : in std_logic;
        inFBH  : in std_logic;
        inCH   : in std_logic;
        inTOF  : in std_logic;
        -- output signal --
        outTRIG    : out std_logic
    );
end Matrix2D_Impl;

architecture RTL of Matrix2D_Impl is
    -- Internal signal declaration ---------------------------------------------------------------
    signal selected_fbh : std_logic;
    
    signal in_ch, in_tof, in_fbh  : std_logic;
begin
    --============================================================================================
    -- body
    --============================================================================================
    
    -- Signal connection -------------------------------------------------------------------------
    outTRIG <=in_ch AND in_tof AND in_fbh;
    
    -- FBH selection -----------------------------------------------------------------------------
    selected_fbh      <= enFBH AND inFBH;
    
    u_MaskFBH   : process(RST, CLK)
    variable id : integer;
    begin
        if(RST = '1') then
	    in_tof	<= '0';
	    in_ch	<= '0';
	    in_fbh	<= '0';
        elsif(CLK'event AND CLK = '1') then
            in_fbh      <= selected_fbh;
            -- 1 clock latency --
            in_ch       <= inCH;
            in_tof      <= inTOF;
        end if;    
    end process u_MaskFBH;
    

end RTL;
