library IEEE, work;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use work.AddressMap.all;
use work.BusSignalTypes.all;
use work.AddressBook.all;

entity MatrixDummy is
    port(
        rst	    : in std_logic;
        clk	    : in std_logic;
        sclk	: in std_logic;
        -- Module input --
    	tofSig            : in std_logic_vector(NofTOF-1 downto 0);
    	fbhSig            : in std_logic_vector(NofFBH-1 downto 0);
    	chSig             : in std_logic_vector(NofCH-1 downto 0);
		
		-- Module output --
		Trigger           	: out std_logic;
		-- Local bus --
		addrLocalBus		: in LocalAddressType;
		dataLocalBusIn		: in LocalBusInType;
		dataLocalBusOut	: out LocalBusOutType;
		reLocalBus			: in std_logic;
		weLocalBus			: in std_logic;
		readyLocalBus		: out std_logic
	);
end MatrixDummy;

architecture RTL of MatrixDummy is
	-- internal signal declaration ----------------------------------------
	constant fbh_all_zero   : std_logic_vector(NofFBH-1 downto 0) := (others => '0');
	constant ch_all_zero   : std_logic_vector(NofCH-1 downto 0) := (others => '0');
	constant tof_all_zero  : std_logic_vector(NofTOF-1 downto 0) := (others => '0');
	
	signal fbh_or, tof_or, ch_or       : std_logic;
	signal fbh_sig, tof_sig, ch_sig    : std_logic;
	signal or_all     : std_logic;
	signal out_sig    : std_logic;
	
    signal state_lbus	: BusProcessType;
	
	-- =============================== body ===============================
begin
    Trigger <= out_sig;

    fbh_or  <= '0' when(fbhSig = fbh_all_zero) else '1';
    tof_or  <= '0' when(tofSig = tof_all_zero) else '1';
    ch_or   <= '0' when(chSig  = ch_all_zero) else '1';
    u_BufFBH : process(clk)
    begin
         if(clk'event AND clk = '1') then
             fbh_sig <= fbh_or;
             tof_sig <= tof_or;
             ch_sig  <= ch_or;
             out_sig <= or_all;             
         end if;
    end process u_BufFBH;
     
    or_all <= fbh_sig OR tof_sig OR ch_sig;

    u_BusProcess : process(clk, rst)
	begin
        if(rst = '1') then
            state_lbus	<= Init;
        elsif(clk'event and clk = '1') then
			case state_lbus is
			when Init =>

				dataLocalBusOut 	<= x"00";
				readyLocalBus		<= '0';
				state_lbus			<= Idle;
				
			when Idle =>
				readyLocalBus	<= '0';
				if(weLocalBus = '1' or reLocalBus = '1') then
					state_lbus	<= Connect;
				end if;
			
			when Connect =>
				if(weLocalBus = '1') then
					state_lbus	<= Write;
				else
					state_lbus	<= Read;
				end if;
				
			when Write =>
		        state_lbus	<= Done;
				
			when Read =>
				state_lbus	     <= Done;
				
			when Done =>
				readyLocalBus	<= '1';
				if(weLocalBus = '0' and reLocalBus = '0') then
					state_lbus	<= Idle;
				end if;
			
			-- probably this is error --
			when others =>
				state_lbus	<= Init;
			end case;
		end if;
	end process u_BusProcess;

end RTL;

