library IEEE, work;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use work.AddressMap.all;
use work.BusSignalTypes.all;
use work.AddressBook.all;

entity VetoModule is
    Port (
        rst             : in std_logic;
        clk             : in std_logic;
        VETO            : in std_logic;
        DirectTrigger   : in std_logic;
        VetoTrigger     : out std_logic
    );
end VetoModule;

architecture RTL of VetoModule is
    signal d_trig       : std_logic_vector(1 downto 0);
    signal veto_trig    : std_logic;
    
    component EdgeDetector
        port (
            rst : in std_logic;
            clk : in std_logic;
            dIn : in std_logic;
            dOut : out std_logic 
        );
    end component;
    
    component WidthGen
        generic(
            width   : integer 
        );
        Port (
            rst     : in std_logic;
            clk     : in std_logic;
            dataIn  : in std_logic;
            dataOut : out std_logic
        );
    end component;
    
begin
    -- ================================================== body ==============================================
    u_DelayTrigger  : process(rst, clk)
    begin
        if(rst = '1') then
            d_trig(0)  <= '0';
        elsif(clk'event AND clk = '1') then
            d_trig(0)  <= DirectTrigger;
        end if;
    end process u_DelayTrigger;
    
    u_OneShotTrigger : EdgeDetector
        port map(rst => rst, clk => clk, dIn => d_trig(0), dOut => d_trig(1));
        
    veto_trig   <= d_trig(1) AND (NOT VETO);
        
    u_TriggerGen : WidthGen
        generic map(width => WidthOut)
        port map(rst => rst, clk => clk, dataIn => veto_trig, dataOut => VetoTrigger);

end RTL;
