library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

Library UNISIM;
use UNISIM.vcomponents.all;

entity input_synchronizer is
    Port (
        rst     : in std_logic;
        clk     : in std_logic;
        dataIn  : in std_logic;
        dataOut : out std_logic    
    );
end input_synchronizer;

architecture RTL of input_synchronizer is
    --attribute rloc : string;
    --attribute rloc of FDCE_Inst2 : label is "X0Y0";
    --attribute rloc of FDCE_Inst3 : label is "X1Y0";

    signal reg_sync : std_logic_vector(1 downto 0);

begin

    dataOut <= reg_sync(1);

   FDCE_inst1 : FDCE
   generic map (
      INIT => '0') -- Initial value of register ('0' or '1')  
   port map (
      Q => reg_sync(0),      -- Data output
      C => clk,      -- Clock input
      CE => '1',    -- Clock enable input
      CLR => rst,  -- Asynchronous clear input
      D => dataIn       -- Data input
   );
   
   FDCE_inst2 : FDCE
   generic map (
      INIT => '0') -- Initial value of register ('0' or '1')  
   port map (
      Q => reg_sync(1),      -- Data output
      C => clk,      -- Clock input
      CE => '1',    -- Clock enable input
      CLR => rst,  -- Asynchronous clear input
      D => reg_sync(0)       -- Data input
   );   
   
--   FDCE_inst3 : FDCE
--   generic map (
--      INIT => '0') -- Initial value of register ('0' or '1')  
--   port map (
--      Q => reg_sync(2),      -- Data output
--      C => clk,      -- Clock input
--      CE => '1',    -- Clock enable input
--      CLR => rst,  -- Asynchronous clear input
--      D => reg_sync(1)       -- Data input
--   );        

end RTL;
