library IEEE, work;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use work.AddressMap.all;
use work.BusSignalTypes.all;
use work.AddressBook.all;

entity Matrix3D_Impl is
    Port (
        RST     : in std_logic;
        CLK     : in std_logic;
        -- input signal --
        enFBH  : in std_logic_vector(NofFBH-1 downto 0);
        inFBH  : in std_logic_vector(NofFBH-1 downto 0);
        inCH   : in std_logic;
        inTOF  : in std_logic;
        -- output signal --
        outTRIG    : out std_logic
    );
end Matrix3D_Impl;

architecture RTL of Matrix3D_Impl is
    -- Internal signal declaration ---------------------------------------------------------------
    constant all_zero   : std_logic_vector(NofFBH-1 downto 0):= (others => '0');
    signal masked_fbh   : std_logic_vector(NofFBH-1 downto 0);
    signal selected_fbh : std_logic;
    
    signal in_ch, in_tof    : std_logic;
begin
    --============================================================================================
    -- body
    --============================================================================================
    
    -- Signal connection -------------------------------------------------------------------------
    outTRIG <=in_ch AND in_tof AND selected_fbh;
    
    -- FBH selection -----------------------------------------------------------------------------
    selected_fbh    <= '0' when(masked_fbh = all_zero) else '1';
    
    u_MaskFBH   : process(RST, CLK)
    variable id : integer;
    begin
        if(RST = '1') then
            masked_fbh  <= (others => '0');
        elsif(CLK'event AND CLK = '1') then
            masked_fbh  <= enFBH AND inFBH ;
            -- 1 clock latency --
            in_ch       <= inCH;
            in_tof      <= inTOF;
        end if;    
    end process u_MaskFBH;
    

end RTL;
