library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity WidthGen is
    generic(
        width   : integer 
    );
    Port (
        rst     : in std_logic;
        clk     : in std_logic;
        dataIn  : in std_logic;
        dataOut : out std_logic
    );
end WidthGen;

architecture RTL of WidthGen is
    -- Internal signal declaration ----------------------------------------------------------------------
    constant all_zero   : std_logic_vector(width-1 downto 0):= (others => '0');
    
    signal reg_shift    : std_logic_vector(width-1 downto 0);

begin
    -- ==================================================================================================
    -- Body 
    -- ==================================================================================================
    
    dataOut <= '0' when(reg_shift = all_zero) else '1';
    
    u_ShiftReg  : process(rst, clk)
    begin
        if(rst = '1') then
            reg_shift   <= (others => '0');
        elsif(clk'event AND clk = '1') then
            reg_shift   <= reg_shift(width-2 downto 0) & dataIn;
        end if;
    end process u_ShiftReg;

end RTL;
