const int NofTOF = 24;
const int NofCH  = 64;
const int NofFBH = 31;

#include<fstream>
#include<sstream>

void make_mtx3d_template()
{
  std::ofstream ofs("matrix3d_pattern.txt");
  ofs << "### Bit pattern of clustered FBH for each TOFxCH element\n";
  ofs << "### FBH ch0, ch0.5 ch1, ch1.5 ...\n";
  ofs << "### 0 : off, 1 : on\n";
  
  for(int i_tof = 0; i_tof<NofTOF; ++i_tof){
    std::ostringstream tof_line;
    tof_line << "# TOF segment " << i_tof << std::endl;
    ofs << tof_line.str();
    for(int i_ch = 0; i_ch<NofCH; ++i_ch){
      std::ostringstream ch_line;
      if(i_ch < 10){
	ch_line << "CH0" << i_ch << " ";
      }else{
	ch_line << "CH" << i_ch << " ";
      }

      for(int i_fbh = 0; i_fbh<NofFBH; ++i_fbh){
	ch_line << 0;
      }// for(i_fbh)
      ch_line << std::endl;
      ofs << ch_line.str();
    }// for(i_ch)
  }// for(i_tof)

}
