#include"daq_funcs.hh"
#include<fstream>

int user_stop = 0;

static const int NofHead = 1;
static const int NofFBH  = 31;
static const int NofTOF  = 24;
static const int NofCH   = 64;
static const int NofData = NofHead + NofFBH + NofTOF + NofCH;

// signal -----------------------------------------------------------------
void
UserStop_FromCtrlC(int signal)
{
  std::cout << "Stop request" << std::endl;
  user_stop = 1;
}

// execute daq ------------------------------------------------------------
void
daq(char* ip, rbcp_header *rbcpHeader)
{
  // TCP socket
  int sock;
  if(-1 == (sock = ConnectSocket((const char*)ip))) return;

  // Start DAQ
  FPGAModule fModule(ip, udp_port, rbcpHeader, 0);
  fModule.WriteModule(TDC::mid, TDC::laddr_lowth,  0);
  fModule.WriteModule(TDC::mid, TDC::laddr_highth, 255);
  fModule.WriteModule(TDC::mid, TDC::laddr_start,  1);

  std::ofstream ofs("hoge.dat", std::ios::binary);

  // DAQ Cycle
  unsigned int buf[NofData];
  for(int n = 0; n<1000; ++n){
    while( -1 == Event_Cycle(sock, buf) ) continue;;
    ofs.write((char*)buf, NofData*sizeof(unsigned int));
    for(int i = 0; i<NofData; ++i){
      printf("%x ", buf[i]);
      if(i%8 == 0) printf("\n");
    }// for(i)


  }// for(n)

  fModule.WriteModule(TDC::mid, TDC::laddr_start, 0);
  while(-1 != Event_Cycle(sock, buf));

  shutdown(sock, SHUT_RDWR);
  close(sock);

  ofs.close();

  return;
}

// ConnectSocket ----------------------------------------------------------
int
ConnectSocket(const char* ip)
{
  struct sockaddr_in SiTCP_ADDR;
  unsigned int port = 24;

  int sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
  SiTCP_ADDR.sin_family      = AF_INET;
  SiTCP_ADDR.sin_port        = htons((unsigned short int) port);
  SiTCP_ADDR.sin_addr.s_addr = inet_addr(ip);

  struct timeval tv;
  tv.tv_sec  = 3;
  tv.tv_usec = 0;
  setsockopt(sock, SOL_SOCKET, SO_RCVTIMEO, (char*)&tv, sizeof(tv));

  int flag = 1;
  setsockopt(sock, IPPROTO_TCP, TCP_NODELAY, (char*)&flag, sizeof(flag));

  if(0 > connect(sock, (struct sockaddr*)&SiTCP_ADDR, sizeof(SiTCP_ADDR))){
    std::cerr << "#E : TCP connection error" << std::endl;
    close(sock);
    return -1;
  }
  
  return sock;
}

// Event Cycle ------------------------------------------------------------
int
Event_Cycle(int sock, unsigned int* buffer)
{
  // data read ---------------------------------------------------------
  static const unsigned int sizeData = NofData*sizeof(unsigned int);
  int ret = receive(sock, (char*)buffer, sizeData);
  if(ret < 0) return -1;
  
  return 0;
}

// receive ----------------------------------------------------------------
int
receive(int sock, char* data_buf, unsigned int length)
{
  unsigned int revd_size = 0;
  int tmp_ret            = 0;

  while(revd_size < length){
    tmp_ret = recv(sock, data_buf + revd_size, length -revd_size, 0);

    if(tmp_ret == 0) break;
    if(tmp_ret < 0){
      int errbuf = errno;
      perror("TCP receive");
      if(errbuf == EAGAIN){
	// this is time out
      }else{
	// something wrong
	std::cerr << "TCP error : " << errbuf << std::endl;
      }

      revd_size = tmp_ret;
      break;
    }

    revd_size += tmp_ret;
  }

  return revd_size;
}

