#include <iostream>
#include <cstdio>
#include <fstream>
#include <sstream>
#include <string>

#include "RegisterMap.hh"
#include "network.hh"
#include "UDPRBCP.hh"
#include "CommandMan.hh"
#include "FPGAModule.hh"
#include "rbcp.h"

const int NofTOF = 24;
const int NofCH  = 64;
const int NofFBH = 31;
const int NofArray = NofTOF*NofCH;
unsigned int registers[NofArray] = {0};

int  read_matrix_file(std::string& filename);
void send_matrix(std::string& ip);

int main(int argc, char* argv[])
{
  if(1 == argc){
    std::cout << "Usage\n";
    std::cout << "load_matrix3d [IP address] [matrix_file]" << std::endl;
    return 0;
  }// usage
  
  // body ------------------------------------------------------
  std::string board_ip = argv[1];
  std::string file_name = argv[2];
  if(-1 == read_matrix_file(file_name)) return -1;
  send_matrix(board_ip);
  
  std::cout << "#D : The matrix file (" << file_name << ") is successfully sent" << std::endl;

  return 0;

}// main

int read_matrix_file(std::string& filename)
{
  std::ifstream ifs(filename.c_str());
  if(!ifs.is_open()){
    std::cout << "#E : No such the matrix file" << std::endl;
    return -1;
  }

  int index = 0;
  std::string line;
  while(getline(ifs, line)){
    // this is comment line
    if(line[0] == '#') continue;
    
    std::istringstream LineToWord(line);
    std::string word;
    // skip CH#
    LineToWord >> word;
    LineToWord >> word; // this is target
    //    std::cout << word << std::endl;

    registers[index] = 0;
    for(int i = 0; i<NofFBH; ++i){
      unsigned int bit = (word[i] == '0' ? 0 : 1);
      bit = bit << i;
      registers[index] += bit;
    }// for(i)
    //    std::cout << registers[index] << std::endl;
    
    ++index;
  }// while

  return 0;
}// read_matrix_file

void send_matrix(std::string& ip)
{
  static const unsigned int mask_low   = 0xffff;
  static const unsigned int mask_high  = 0x7fff;
  static const unsigned int shift_high = 16;

  rbcp_header rbcpHeader;
  rbcpHeader.type = UDPRBCP::rbcp_ver_;
  rbcpHeader.id   = 0;  
  FPGAModule fModule((char*)ip.c_str(), udp_port, &rbcpHeader, 0);
  for(int i = NofArray-1; i>-1; --i){
    unsigned int reg_low  =  registers[i] & mask_low;
    unsigned int reg_high = (registers[i] >> shift_high ) & mask_high;
    fModule.WriteModule(MTX3D::mid, MTX3D::laddr_low,  reg_low);
    fModule.WriteModule(MTX3D::mid, MTX3D::laddr_high, reg_high);
    fModule.WriteModule(MTX3D::mid, MTX3D::laddr_exec, 0);
    //    std::cout << reg_high << " " << reg_low<< std::endl;
  }// for(i)
}// send_matrix
