#include <iostream>
#include <cstdio>

#include "RegisterMap.hh"
#include "network.hh"
#include "UDPRBCP.hh"
#include "CommandMan.hh"
#include "FPGAModule.hh"
#include "rbcp.h"
#include "errno.h"
#include "daq_funcs.hh"

int main(int argc, char* argv[])
{
  if(1 == argc){
    std::cout << "Usage\n";
    std::cout << "hul_main [IP address]" << std::endl;
    return 0;
  }// usage
  
  // body ------------------------------------------------------
  char* board_ip = argv[1];
  rbcp_header rbcpHeader;
  rbcpHeader.type = UDPRBCP::rbcp_ver_;
  rbcpHeader.id   = 0;

  FPGAModule fModule(board_ip, udp_port, &rbcpHeader);
  fModule.WriteModule(MTX3D::mid, MTX3D::laddr_low,   0x0004);
  fModule.WriteModule(MTX3D::mid, MTX3D::laddr_high,  0x0000);
  fModule.WriteModule(MTX3D::mid, MTX3D::laddr_exec, 0x1);


  for(int i = 0; i<94; ++i){
    //    for(int i = 0; i<1538; ++i){
    fModule.WriteModule(MTX3D::mid, MTX3D::laddr_low,   0x0000);
    fModule.WriteModule(MTX3D::mid, MTX3D::laddr_high,  0x0000);
    fModule.WriteModule(MTX3D::mid, MTX3D::laddr_exec, 0x1);
  }


  //daq(board_ip, &rbcpHeader);

  return 0;

}// main
