#include <iostream>
#include <cstdio>

#include "RegisterMap.hh"
#include "network.hh"
#include "UDPRBCP.hh"
#include "CommandMan.hh"
#include "FPGAModule.hh"
#include "rbcp.h"
#include "errno.h"
#include "daq_funcs.hh"

int main(int argc, char* argv[])
{
  if(1 == argc){
    std::cout << "Usage\n";
    std::cout << "set_nimo [IP address] [signal] [NimoOut port]" << std::endl;
    return 0;
  }// usage
  
  // body ------------------------------------------------------
  char* board_ip = argv[1];
  rbcp_header rbcpHeader;
  rbcpHeader.type = UDPRBCP::rbcp_ver_;
  rbcpHeader.id   = 0;

  char* sel_out = argv[2];

  int reg;
  sscanf(sel_out, "%d", &reg);
  int nimport;
  sscanf(argv[3], "%d", &nimport);
  //  printf("%d\n", nimport);

  FPGAModule fModule(board_ip, udp_port, &rbcpHeader);
  if(nimport == 1){
    fModule.WriteModule(SEL::mid, SEL::laddr_nim1, reg);
  }else if(nimport == 2){
    fModule.WriteModule(SEL::mid, SEL::laddr_nim2, reg);
  }else if(nimport == 3){
    fModule.WriteModule(SEL::mid, SEL::laddr_nim3, reg);
  }else if(nimport == 4){
    fModule.WriteModule(SEL::mid, SEL::laddr_nim4, reg);  
  }

  return 0;

}// main
