#include<fstream>
#include<sstream>


const int kNumCh  = 64;
const int kNumTap = 64;

const int shift   = 11;

void
make_timediff()
{
  std::ifstream ifs("macro/estimator.txt");
  int estimator[kNumCh][kNumTap] = {0};

  for(int i = 0; i<2; ++i){
    std::string line;
    getline(ifs, line);
    std::istringstream line_to_word(line);
    for(int j = 0; j<kNumTap; ++j){
      int rw = 0;
      line_to_word >> rw;
      estimator[i][j] = rw;
    }// for(j)
  }

  new TFile("rootfile/run1.root");
  TTree *tree = (TTree*)gFile->Get("tree");
  int num_hit;
  int fine_count[kNumCh];
  int coarse_count[kNumCh];
  tree->SetBranchAddress("num_hit", &num_hit);
  tree->SetBranchAddress("fine_count", fine_count);
  tree->SetBranchAddress("coarse_count", coarse_count);

  TH1F *htime_diff = new TH1F("time_diff", "time_diff", 1000, 0, 10000);

  int n_event = tree->GetEntries();
  for(int i = 0; i<n_event; ++i){
    tree->GetEntry(i);

    int tdc_leading[2] = {0};
    tdc_leading[0] = (coarse_count[0] << shift) + estimator[0][fine_count[0]];
    tdc_leading[1] = (coarse_count[1] << shift) + estimator[1][fine_count[1]];

    //    int tdiff = tdc_leading[0] > tdc_leading[1] ? tdc_leading[0] - tdc_leading[1] : tdc_leading[1] - tdc_leading[0];
    int tdiff = tdc_leading[0] > tdc_leading[1] ? tdc_leading[0] - tdc_leading[1] : tdc_leading[1] - tdc_leading[0];
    if(tdc_leading[0] > tdc_leading[1]) continue;
    htime_diff->Fill(tdiff);
    
  }// for(i)

  htime_diff->Draw();

}
