const int kNumCh  = 64;
const int kNumTap = 64;

void
make_estimator()
{
  new TFile("rootfile/run1.root");
  TTree *tree = (TTree*)gFile->Get("tree");
  int num_hit;
  int fine_count[kNumCh];
  tree->SetBranchAddress("num_hit", &num_hit);
  tree->SetBranchAddress("fine_count", fine_count);

  TH1F *hfine_count[kNumCh];
  for(int i = 0; i<kNumCh; ++i){
    hfine_count[i] = new TH1F(Form("hfine_count%d", i),
			      Form("hfine_count%d", i),
			      64, 0, 64
			      );
  }// for(i)

  int n_event = tree->GetEntries();
  for(int i = 0; i<n_event; ++i){
    tree->GetEntry(i);
    for(int j = 0; j<num_hit; ++j){
      hfine_count[j]->Fill(fine_count[j]);
    }// for(j)
  }// for(i)

  TH1F *hestimator[kNumCh];
  for(int i = 0; i<kNumCh; ++i){
    hestimator[i] = new TH1F(Form("estimator%d", i),
			     Form("estimator%d", i),
			     520000, 0, 520000
			     );
  }// for(i)

  std::ofstream ofs("macro/estimator.txt");
  
  int estimator[kNumCh][kNumTap] = {0};
  for(int i = 0; i<num_hit; ++i){
    int w           = 0;
    int total_count = 0;
    for(int j = 0; j<kNumTap; ++j){
      int bin_content = (int)hfine_count[i]->GetBinContent(j+1);
      w = (bin_content>>1) + total_count;
      total_count += bin_content;
      hestimator[i]->Fill(w);

      int rw = w >> 8;
      ofs << rw << " ";
    }// for(j)
    ofs << std::endl;
  }// for(i)

  hestimator[0]->Draw();
  hfine_count[0]->Draw();
}
