`timescale 1ns / 1ps

////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer:
//
// Create Date:   02:53:12 01/07/2015
// Design Name:   ctrl_sig_maker
// Module Name:   X:/telescope/firmware/debug/v4.0_4tele_SB1/sim/ctrl_testbench.v
// Project Name:  multi_chip
// Target Device:  
// Tool versions:  
// Description: 
//
// Verilog Test Fixture created by ISE for module: ctrl_sig_maker
//
// Dependencies:
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
////////////////////////////////////////////////////////////////////////////////

module ctrl_testbench;

   // Inputs
   reg OPERATE_CLK_IN;
   reg REG_CLK_IN;
   reg ACTIVE_IN;
   reg RESET_IN;
   reg INT_TRIG_IN;
   reg [13:0] SIO_ADDR_IN;
   reg [7:0]  SIO_WD_IN;
   reg 	      SIO_WE_IN;
   reg 	      TRIGGER_IN;
   reg 	      READ_START_IN;

   // Outputs
   wire       RAM_LOADED_OUT;
   wire       TRIG_WAIT_OUT;
   wire [15:0] CTRL_SIG_OUT;

   // Instantiate the Unit Under Test (UUT)
   ctrl_sig_maker uut (
		       .OPERATE_CLK_IN(OPERATE_CLK_IN), 
		       .REG_CLK_IN(REG_CLK_IN), 
		       .ACTIVE_IN(ACTIVE_IN), 
		       .RESET_IN(RESET_IN),
		       .INT_TRIG_IN(INT_TRIG_IN),
		       .SIO_ADDR_IN(SIO_ADDR_IN), 
		       .SIO_WD_IN(SIO_WD_IN), 
		       .SIO_WE_IN(SIO_WE_IN), 
		       .TRIGGER_IN(TRIGGER_IN), 
		       .READ_START_IN(READ_START_IN), 
		       .RAM_LOADED_OUT(RAM_LOADED_OUT), 
		       .TRIG_WAIT_OUT(TRIG_WAIT_OUT), 
		       .CTRL_SIG_OUT(CTRL_SIG_OUT)
		       );

   //-------------------------------------------
   //generating 40 MHz CLK
   //-------------------------------------------
   parameter CYCLE40M = 25.0;
   
   initial begin
      OPERATE_CLK_IN <= 1'b0;
      #50 //wait for CLK
      forever begin
	 OPERATE_CLK_IN <= ~OPERATE_CLK_IN; #(CYCLE40M/2.0);
      end
   end

   
   //-------------------------------------------
   //generating 500 kHz CLK
   //-------------------------------------------
   parameter CYCLE500k = 2000;
   
   initial begin
      REG_CLK_IN <= 1'b1;
      #50 //wait for CLK
      forever begin
	 REG_CLK_IN <= ~REG_CLK_IN; #(CYCLE500k/2.0);
      end
   end


   //-------------------------------------------
   // Emulating Data and OBDV
   //-------------------------------------------
   reg data_emu_r;
   
   initial begin
      SIO_WD_IN = 8'b0;
      SIO_ADDR_IN[13:0] = 14'b0;
   end
   
   always @(posedge REG_CLK_IN)begin
      if(data_emu_r == 1'b1)begin
	 if(SIO_WE_IN == 1'b1)begin
	    SIO_ADDR_IN[13:0] <= SIO_ADDR_IN[13:0] + 14'd1;
	 end else begin
	    SIO_ADDR_IN[13:0] <= 14'd0;
	 end
      end
   end
   
   always @(posedge REG_CLK_IN)begin
      if(data_emu_r == 1'b1)begin
	 if(SIO_WE_IN == 1'b1)begin
	    SIO_WD_IN[7:0] <=  SIO_WD_IN[7:0] + 8'd2;
	 end else begin
	    SIO_WD_IN[7:0] <= 8'd2;
	 end
      end
   end

   initial begin
      // Initialize Inputs
      ACTIVE_IN = 0;
      RESET_IN = 0;
      SIO_WE_IN = 0;
      TRIGGER_IN = 0;
      READ_START_IN = 0;
      INT_TRIG_IN = 1;

      // Wait 100 ns for global reset to finish
      #100;
      ACTIVE_IN = 1'b1;
      data_emu_r = 1'b1;
      
      // Add stimulus here
      #3000;
      SIO_WE_IN = 1'b1;
      #8500000;
      SIO_WE_IN = 1'b0;
      #3000;
      data_emu_r = 1'b0;

      #1000;
      SIO_WE_IN = 1'b1;
      SIO_WD_IN[7:0] = 8'b1111_1111;
      SIO_ADDR_IN[13:0] <= 14'd4150;
      #2000;
      SIO_WD_IN[7:0] = 8'b1111_1111;
      SIO_ADDR_IN[13:0] <= 14'd4151;
      #2000;
      SIO_WE_IN = 1'b0;
      SIO_WD_IN[7:0] = 8'b0;
      SIO_ADDR_IN[13:0] <= 14'd0;

      #10000;
      READ_START_IN = 1'b1;

      #20000;
      TRIGGER_IN = 1'b1;
      #300;
      TRIGGER_IN = 1'b0;
      #20000;
      TRIGGER_IN = 1'b1;
      #300;
      TRIGGER_IN = 1'b0;
      #20000;
      TRIGGER_IN = 1'b1;
      #300;
      TRIGGER_IN = 1'b0;
      
      #10000000;
      RESET_IN <= 1'b1;
      #100;
      RESET_IN <= 1'b0;

      
      

   end
   
endmodule

