`timescale 1ns / 1ps

////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer:
//
// Create Date:   13:33:37 10/12/2015
// Design Name:   test
// Module Name:   C:/Users/Administrator/Dropbox/telescope/firmware/debug/v2_4tele_SB2/sim/sim_multisampling.v
// Project Name:  multi_chip
// Target Device:  
// Tool versions:  
// Description: 
//
// Verilog Test Fixture created by ISE for module: test
//
// Dependencies:
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
////////////////////////////////////////////////////////////////////////////////

module sim_multisampling;

   // Inputs
   reg CLK_0_IN;
   reg CLK_90_IN;
   reg CLK_180_IN;
   reg CLK_270_IN;
   reg START_IN;
   // reg TRIGED_IN;

   // Outputs
   wire [1:0] DATA_OUT;

   // Instantiate the Unit Under Test (UUT)
   multisample_TDC uut (
			.CLK_0_IN(CLK_0_IN), 
			.CLK_90_IN(CLK_90_IN), 
			.CLK_180_IN(CLK_180_IN), 
			.CLK_270_IN(CLK_270_IN), 
			.START_IN(START_IN),
			// .TRIGED_IN(TRIGED_IN),
			.DATA_OUT(DATA_OUT)
			);

   task MakePulse;
      begin
	 START_IN = 1'b1;
	 #(CYCLE40M*1);
	 START_IN = 1'b0;
	 #(CYCLE40M*4);
      end
   endtask
   
   //-------------------------------------------
   //generating 40 MHz CLK
   //-------------------------------------------
   parameter CYCLE40M = 25.0;
   
   initial begin
      CLK_0_IN <= 1'b0;
      CLK_90_IN <= 1'b0;
      CLK_180_IN <= 1'b1;
      CLK_270_IN <= 1'b1;
      #100 //wait for CLK
      forever begin
	 CLK_0_IN <= ~CLK_0_IN;
	 CLK_180_IN <= ~CLK_180_IN;
	 #(CYCLE40M/4.0);
	 CLK_90_IN <= ~CLK_90_IN;
	 CLK_270_IN <= ~CLK_270_IN;
	 #(CYCLE40M/4.0);
      end
   end

   initial begin
      // Initialize Inputs
      START_IN = 1'b0;

      // Wait 100 ns for global reset to finish
      #100;
      #0.1;
      
      // Add stimulus here
      #(CYCLE40M*10);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      #(CYCLE40M*0.07);
      MakePulse();
      
   end
   
endmodule

