`timescale 1ns / 1ps

////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer:
//
// Create Date:   21:18:45 09/25/2014
// Design Name:   top
// Module Name:   Z:/Users/hirose/Desktop/SVX4/31svx4_init/src/top_testbench.v
// Project Name:  multi_chip
// Target Device:  
// Tool versions:  
// Description: 
//
// Verilog Test Fixture created by ISE for module: top
//
// Dependencies:
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
////////////////////////////////////////////////////////////////////////////////

module top_testbench;
   
   // Inputs
   reg [3:0] PRout;
   reg [3:0] OBDV;
   reg 	     CLK_50M;
   reg 	     CLK_20M;
   reg 	     CLK_40M;
   reg 	     SW_RSTn;
   reg [7:0] DIP_SW;
   reg [1:0] NIM_IN;
   reg 	     USR_ACTIVE;
   reg 	     USR_CLOSE_REQ;
   reg 	     USR_TX_AFULL;
   reg 	     USR_RX_EMPTY;
   reg 	     USR_RX_RV;
   reg [7:0] USR_RX_RD;
   reg 	     REG_CLK;
   reg 	     REG_ACT;
   reg 	     REG_DO;

   reg [31:0] SIO_ADDR;
   reg [ 7:0] SIO_WD;
   reg 	      SIO_WE;
   
   // Outputs
   wire [3:0] PRin;
   wire [3:0] FECLK;
   wire [3:0] BECLK;
   wire [3:0] PARST;
   wire [3:0] PIPERD1;
   wire [3:0] PIPERD2;
   wire [3:0] L1A;
   wire [3:0] CALSR;
   wire [3:0] FEMODE;
   wire [3:0] BEMODE;
   wire [3:0] CHMODE;
   wire [3:0] DDATA;
   wire [3:0] RDATA;
   wire [7:0] LED;
   wire [1:0] NIM_OUT;
   wire       USR_CLK;
   wire       USR_CLOSE_ACK;
   wire       USR_TX_WE;
   wire [7:0] USR_TX_WD;
   wire       REG_DI;
   
   // Bidirs
   wire [31:0] BUS;
   reg [31:0]  BUS_reg;
   assign BUS = /*~*/BUS_reg;

   // data emulate
   reg 	       emu_data_r;
   
   // Instantiate the Unit Under Test (UUT)
   top uut (
	    .BUS(BUS), 
	    .PRin(PRin), 
	    .PRout(PRout), 
	    .FECLK(FECLK), 
	    .BECLK(BECLK), 
	    .OBDV(OBDV), 
	    .PARST(PARST), 
	    .PIPERD1(PIPERD1), 
	    .PIPERD2(PIPERD2), 
	    .L1A(L1A), 
	    .CALSR(CALSR), 
	    .FEMODE(FEMODE), 
	    .BEMODE(BEMODE), 
	    .CHMODE(CHMODE), 
	    .DDATA(DDATA), 
	    .RDATA(RDATA), 
	    .CLK_50M(CLK_50M), 
	    .SW_RSTn(SW_RSTn), 
	    .LED(LED), 
	    .DIP_SW(DIP_SW), 
	    .NIM_OUT(NIM_OUT), 
	    .NIM_IN(NIM_IN), 
	    .USR_CLK(USR_CLK), 
	    .USR_ACTIVE(USR_ACTIVE), 
	    .USR_CLOSE_REQ(USR_CLOSE_REQ), 
	    .USR_CLOSE_ACK(USR_CLOSE_ACK), 
	    .USR_TX_AFULL(USR_TX_AFULL), 
	    .USR_TX_WE(USR_TX_WE), 
	    .USR_TX_WD(USR_TX_WD), 
	    .USR_RX_EMPTY(USR_RX_EMPTY), 
	    .USR_RX_RV(USR_RX_RV), 
	    .USR_RX_RD(USR_RX_RD), 
	    .SIO_ADDR(SIO_ADDR), 
	    .SIO_WD(SIO_WD),
	    .SIO_WE(SIO_WE),
	    .REG_CLK(REG_CLK), 
	    .REG_ACT(REG_ACT), 
	    .REG_DI(REG_DI), 
	    .REG_DO(REG_DO)
	    );
   
   parameter CYCLE50M = 20;
   parameter CYCLE40M = 25.0;
   parameter CYCLE20M = 50;
   parameter CYCLE500k = 2000;
   // parameter CYCLE38M = 26.315;
   parameter CYCLE19M = 52.6316;
   parameter trig_num = 8'd500;
   
   initial begin
      // Initialize Inputs
      PRout = 0;
      OBDV = 0;
      CLK_50M = 0;
      SW_RSTn = 0;
      DIP_SW[7:0] = 8'b1000_0000;
      NIM_IN = 1;
      USR_ACTIVE = 0;
      USR_CLOSE_REQ = 0;
      USR_TX_AFULL = 0;
      USR_RX_EMPTY = 0;
      USR_RX_RV = 0;
      USR_RX_RD = 0;
      REG_CLK = 0;
      REG_ACT = 0;
      REG_DO = 0;
      SIO_ADDR = 32'b0;
      SIO_WD = 8'b0;
      SIO_WE = 1'b0;
      BUS_reg = 32'bz;
      emu_data_r = 1'b0;
   end
   

   //-------------data emulate-----------------
   
   always@(negedge CLK_40M)begin
      if(emu_data_r == 1'b1)begin
	 OBDV[0] <= CLK_20M;
	 OBDV[1] <= CLK_20M;
	 OBDV[2] <= CLK_20M;
	 OBDV[3] <= CLK_20M;
      end else begin
	 OBDV[0] <= 1'b0;
	 OBDV[1] <= 1'b0;
	 OBDV[2] <= 1'b0;
	 OBDV[3] <= 1'b0;
      end
   end

   reg [11:0] data_cnt_r;
   
   always@(CLK_20M)begin
      if(emu_data_r == 1'b1)begin
	 data_cnt_r[11:0] <=  data_cnt_r[11:0] + 12'd1;
      end else begin
	 data_cnt_r[11:0] <= 12'd0;
      end 
   end
   
   always@(OBDV[0])begin
      if(emu_data_r == 1'b1 && data_cnt_r < 12'd1200)begin
	 if(data_cnt_r==12'd0 || data_cnt_r==12'd1)begin
	    BUS_reg[31:0] <= 32'd0;
	 end else begin
	    BUS_reg[7:0] <=  BUS_reg[7:0] + 8'd2;
	    BUS_reg[15:8] <=  BUS_reg[15:8] + 8'd2;
	    BUS_reg[23:16] <=  BUS_reg[23:16] + 8'd2;
	    BUS_reg[31:24] <=  BUS_reg[31:24] + 8'd2;
	 end
      end
   end // always@ (OBDV[0])

   task data_emulate;
      begin
	 // Triggering
	 NIM_IN[0] = 1'b0;
	 #100;
	 NIM_IN[0] = 1'b1;
	 #(CYCLE500k*5);
	 
	 // Emulating data from SVX4
	 emu_data_r = 1'b1;
	 #(CYCLE500k*1);

	 // Terminate method
	 emu_data_r = 1'b0;
	 BUS_reg = 32'bz;
      end
   endtask

   //----------------------------------------------------
   // Describing RBCP behavior
   //----------------------------------------------------
   initial begin
      USR_ACTIVE = 1'b0;
      REG_CLK = 1'b0;
      REG_ACT = 1'b0;
      REG_DO = 1'b0;
      SW_RSTn = 1'b1;
      PRout = 1'b0;
      #100;
      
      //Making DCM reset
      SW_RSTn = 1'b0;
      #200;
      SW_RSTn = 1'b1;
      #1000;
      //Mimicing TCP connection
      USR_ACTIVE = 1'b1;
      #500;
      //Making RBCP command
      USR_ACTIVE = 1'b1;
      #500;

      //Setting up #triggers
      #(CYCLE500k*10);
      SIO_ADDR = 32'h1000_0000; //ntrig[15:8]
      SIO_WD = 8'h00;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;
      #(CYCLE500k*10);
      SIO_ADDR = 32'h0FFF_FFFF; //ntrig[7:0]
      SIO_WD = trig_num;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;
      
      //Make clf frequency double
      // #(CYCLE500k*10);
      // SIO_ADDR = 32'hEFFF_FFFF;
      // SIO_WD = 8'h09;
      // SIO_WE = 1'b1;
      // #(CYCLE500k*1);
      // SIO_ADDR = 32'h0;
      // SIO_WD = 8'h0;
      // SIO_WE = 1'h0;

      //write CONFIG RAM 1
      #(CYCLE500k*10);
      SIO_ADDR = 32'hf1f1f1f1;
      SIO_WD = 8'h1;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0011;
      SIO_WD = 8'h11;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0012;
      SIO_WD = 8'h12;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0013;
      SIO_WD = 8'h21;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0014;
      SIO_WD = 8'h22;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;

      //write CONFIG RAM 2
      #(CYCLE500k*10);
      SIO_ADDR = 32'hf1f1f1f1;
      SIO_WD = 8'h2;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0021;
      SIO_WD = 8'h1;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0022;
      SIO_WD = 8'h2;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0023;
      SIO_WD = 8'h1;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0024;
      SIO_WD = 8'h4;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;

      //write CONFIG RAM 3
      #(CYCLE500k*10);
      SIO_ADDR = 32'hf1f1f1f1;
      SIO_WD = 8'h3;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0041;
      SIO_WD = 8'h1;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0042;
      SIO_WD = 8'h2;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0043;
      SIO_WD = 8'h3;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0044;
      SIO_WD = 8'h5;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;

      //write CONFIG RAM 4
      #(CYCLE500k*10);
      SIO_ADDR = 32'hf1f1f1f1;
      SIO_WD = 8'h4;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0051;
      SIO_WD = 8'h1;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0052;
      SIO_WD = 8'h2;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0053;
      SIO_WD = 8'h15;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0000_0054;
      SIO_WD = 8'h16;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;
      #(CYCLE500k*10);
      SIO_ADDR = 32'hf1f1f1f1;//reset
      SIO_WD = 8'h0;
      SIO_WE = 1'b1;

      //To inform that software ends sending configuration
      #(CYCLE500k*10);
      SIO_ADDR = 32'hc0;
      SIO_WD = 8'hcc;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;
      #(CYCLE500k*100);

      // Mimicking Config Header
      PRout = 1'b1; #(CYCLE19M*5);
      PRout = 1'b0; #(CYCLE19M*5);
      PRout = 1'b1; #(CYCLE19M*5);
      PRout = 1'b0; #(CYCLE19M*5);
      PRout = 1'b1; #(CYCLE19M*5);
      PRout = 1'b0; #(CYCLE19M*5);
      PRout = 1'b1; #(CYCLE19M*5);
      PRout = 1'b0; #(CYCLE19M*5);

      PRout = 1'b0; #(CYCLE19M*5);
      PRout = 1'b1; #(CYCLE19M*5);
      PRout = 1'b0; #(CYCLE19M*5);
      PRout = 1'b1; #(CYCLE19M*5);
      PRout = 1'b0; #(CYCLE19M*5);
      PRout = 1'b1; #(CYCLE19M*5);
      PRout = 1'b0; #(CYCLE19M*5);
      PRout = 1'b1; #(CYCLE19M*5);
      PRout = 1'b0;
      #5000;

      //Pritending to write ...
      SIO_WE = 1'b1;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd2;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd3;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd4;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd5;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd6;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd7;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd8;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd9;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd10;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd11;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd12;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd13;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd14;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd15;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd16;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd17;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd18;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd19;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd20;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd21;
      #0                SIO_WD[7:0] = 8'b10100100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd22;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd23;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd24;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd25;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd26;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd27;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd28;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd29;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd30;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd31;
      #0                SIO_WD[7:0] = 8'b10100100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd32;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd33;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd34;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd35;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd36;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd37;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd38;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd39;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd40;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd41;
      #0                SIO_WD[7:0] = 8'b10100100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd42;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd43;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd44;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd45;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd46;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd47;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd48;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd49;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd50;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd51;
      #0                SIO_WD[7:0] = 8'b10100100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd52;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd53;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd54;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd55;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd56;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd57;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd58;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd59;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd60;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd61;
      #0                SIO_WD[7:0] = 8'b10100100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd62;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd63;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd64;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd65;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd66;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd67;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd68;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd69;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd70;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd71;
      #0                SIO_WD[7:0] = 8'b10100100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd72;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd73;
      #0                SIO_WD[7:0] = 8'b10100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd74;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd75;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd76;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd77;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd78;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd79;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd80;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd81;
      #0                SIO_WD[7:0] = 8'b00100100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd82;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd83;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd84;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd85;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd86;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd87;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd88;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd89;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd90;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd91;
      #0                SIO_WD[7:0] = 8'b00100100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd92;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd93;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd94;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd95;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd96;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd97;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd98;
      #0                SIO_WD[7:0] = 8'b11001100;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd99;
      #0                SIO_WD[7:0] = 8'b00100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd100;
      #0                SIO_WD[7:0] = 8'b11001100;

      // Pritending mode change to digitize mode
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1001;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1003;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1005;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1007;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1009;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1011;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1013;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1015;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1017;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1019;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1021;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1023;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1025;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1027;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1029;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1031;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1033;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1035;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1037;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1039;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1041;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1043;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1045;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1047;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1049;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1051;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1053;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1055;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1057;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1059;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1061;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1063;
      #0                SIO_WD[7:0] = 8'b11100000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1065;
      #0                SIO_WD[7:0] = 8'b00000000;

      //Pritending mode change to readout mode
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1601;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1603;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1605;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1607;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1609;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1611;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1613;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1615;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1617;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1619;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1621;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1623;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1625;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1627;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1629;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1631;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1633;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1635;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1637;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1639;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1641;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1643;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1645;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1647;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1649;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1651;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1653;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1655;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1657;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1659;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1661;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1663;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1665;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1667;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1669;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1671;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1673;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1675;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd1677;
      #0                SIO_WD[7:0] = 8'b11000000;
      #(CYCLE500k*1)    SIO_ADDR[31:0] = 32'd0;
      #0                SIO_WD[7:0] = 8'b00000000;

      SIO_WE = 1'b0;
      
      /* -----\/----- EXCLUDED -----\/-----
       #(CYCLE500k*1);
       SIO_ADDR = 32'h000a;
       SIO_WD = 8'h55;
       SIO_WE = 1'b1;
       #(CYCLE500k*1);
       SIO_ADDR = 32'h000b;
       SIO_WD = 8'hc4;
       SIO_WE = 1'b1;
       #(CYCLE500k*1);
       SIO_ADDR = 32'h000c;
       SIO_WD = 8'h55;
       SIO_WE = 1'b1;
       #(CYCLE500k*1);
       SIO_ADDR = 32'h000d;
       SIO_WD = 8'hc4;
       SIO_WE = 1'b1;
       #(CYCLE500k*1);
       SIO_ADDR = 32'h000e;
       SIO_WD = 8'h55;
       SIO_WE = 1'b1;
       #(CYCLE500k*1);
       SIO_ADDR = 32'h000f;
       SIO_WD = 8'hc4;
       SIO_WE = 1'b1;
       #(CYCLE500k*1);
       SIO_ADDR = 32'h0000;
       SIO_WD = 8'h00;
       SIO_WE = 1'b0;
       #(CYCLE500k*1);
       -----/\----- EXCLUDED -----/\----- */

      //To make ctrl2_comp_r
      SIO_ADDR = 32'h7ffe;
      SIO_WD = 8'h01;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;
      #(CYCLE500k*10);

      // start DAQ
      SIO_ADDR = 32'h0000eeee;
      SIO_WD = 8'h5;
      SIO_WE = 1'b1;
      #(CYCLE500k*1);
      SIO_ADDR = 32'h0;
      SIO_WD = 8'h0;
      SIO_WE = 1'h0;
      #(CYCLE500k*10);

      //Emulating SVX4 data
      #(CYCLE500k*20);
      
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
      data_emulate();#(CYCLE500k*500);
   end

   
   //-------------------------------------------
   //generating 50 MHz CLK
   //-------------------------------------------
   initial begin
      CLK_50M <= 1'b0;
      #(50) //wait for CLK
      forever begin
	 CLK_50M <= 1'b1; #(CYCLE50M/2);
	 CLK_50M <= 1'b0; #(CYCLE50M/2);
      end
   end

   //-------------------------------------------
   //generating 20 MHz CLK
   //-------------------------------------------
   initial begin
      CLK_20M <= 1'b0;
      #(50) //wait for CLK
      forever begin
	 CLK_20M <= 1'b1; #(CYCLE20M/2);
	 CLK_20M <= 1'b0; #(CYCLE20M/2);
      end
   end

   //-------------------------------------------
   //generating 40 MHz CLK
   //-------------------------------------------
   initial begin
      CLK_40M <= 1'b0;
      #(50) //wait for CLK
      forever begin
	 CLK_40M <= 1'b1; #(CYCLE40M/2.0);
	 CLK_40M <= 1'b0; #(CYCLE40M/2.0);
      end
   end

   //-------------------------------------------
   //generating 500 kHz CLK
   //-------------------------------------------
   initial begin
      REG_CLK <= 1'b1;
      #(50) //wait for CLK
      forever begin
	 REG_CLK <= 1'b0; #(CYCLE500k/2);
	 REG_CLK <= 1'b1; #(CYCLE500k/2);
      end
   end

   // task MakeRBCPCommand;
   //    input [31:0] address;
   //    input [7:0] data;
   //    begin
   // 	 //Start Bit
   // 	 REG_ACT = 1'b1; #(CYCLE500k*1);
   // 	 REG_DO = 1'b1; #(CYCLE500k*1);
   // 	 //Command
   // 	 REG_DO = 1'b1; #(CYCLE500k*1);
   // 	 REG_DO = 1'b1; #(CYCLE500k*1);
   // 	 REG_DO = 1'b0; #(CYCLE500k*1);
   // 	 REG_DO = 1'b0; #(CYCLE500k*1);
   // 	 REG_DO = 1'b1; #(CYCLE500k*1);
   // 	 REG_DO = 1'b1; #(CYCLE500k*1);
   // 	 REG_DO = 1'b0; #(CYCLE500k*1);
   // 	 REG_DO = 1'b0; #(CYCLE500k*1);
   // 	 //Address
   // 	 REG_DO = address[31]; #(CYCLE500k*1);
   // 	 REG_DO = address[30]; #(CYCLE500k*1);
   // 	 REG_DO = address[29]; #(CYCLE500k*1);
   // 	 REG_DO = address[28]; #(CYCLE500k*1);
   // 	 REG_DO = address[27]; #(CYCLE500k*1);
   // 	 REG_DO = address[26]; #(CYCLE500k*1);
   // 	 REG_DO = address[25]; #(CYCLE500k*1);
   // 	 REG_DO = address[24]; #(CYCLE500k*1);

   // 	 REG_DO = address[23]; #(CYCLE500k*1);
   // 	 REG_DO = address[22]; #(CYCLE500k*1);
   // 	 REG_DO = address[21]; #(CYCLE500k*1);
   // 	 REG_DO = address[20]; #(CYCLE500k*1);
   // 	 REG_DO = address[19]; #(CYCLE500k*1);
   // 	 REG_DO = address[18]; #(CYCLE500k*1);
   // 	 REG_DO = address[17]; #(CYCLE500k*1);
   // 	 REG_DO = address[16]; #(CYCLE500k*1);

   // 	 REG_DO = address[15]; #(CYCLE500k*1);
   // 	 REG_DO = address[14]; #(CYCLE500k*1);
   // 	 REG_DO = address[13]; #(CYCLE500k*1);
   // 	 REG_DO = address[12]; #(CYCLE500k*1);
   // 	 REG_DO = address[11]; #(CYCLE500k*1);
   // 	 REG_DO = address[10]; #(CYCLE500k*1);
   // 	 REG_DO = address[9]; #(CYCLE500k*1);
   // 	 REG_DO = address[8]; #(CYCLE500k*1);

   // 	 REG_DO = address[7]; #(CYCLE500k*1);
   // 	 REG_DO = address[6]; #(CYCLE500k*1);
   // 	 REG_DO = address[5]; #(CYCLE500k*1);
   // 	 REG_DO = address[4]; #(CYCLE500k*1);
   // 	 REG_DO = address[3]; #(CYCLE500k*1);
   // 	 REG_DO = address[2]; #(CYCLE500k*1);
   // 	 REG_DO = address[1]; #(CYCLE500k*1);
   // 	 REG_DO = address[0]; #(CYCLE500k*1);
   // 	 //Write Data
   // 	 REG_DO = data[7]; #(CYCLE500k*1);
   // 	 REG_DO = data[6]; #(CYCLE500k*1);
   // 	 REG_DO = data[5]; #(CYCLE500k*1);
   // 	 REG_DO = data[4]; #(CYCLE500k*1);
   // 	 REG_DO = data[3]; #(CYCLE500k*1);
   // 	 REG_DO = data[2]; #(CYCLE500k*1);
   // 	 REG_DO = data[1]; #(CYCLE500k*1);
   // 	 REG_DO = data[0]; #(CYCLE500k*1);
   // 	 //Unknown bits
   // 	 REG_DO = 1'b1; #(CYCLE500k*1);
   // 	 REG_DO = 1'b1; #(CYCLE500k*1);
   // 	 //normaly 0
   // 	 REG_DO = 1'b0;
   // 	 #(CYCLE500k*2);
   // 	 REG_ACT = 1'b0;
   // 	 REG_DO = 1'b0;
   // 	 #10000;
   //    end
   // endtask // MakeRBCPCommand
   
endmodule

