`timescale 1ns / 1ps

////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer:
//
// Create Date:   23:36:29 11/30/2014
// Design Name:   trigger
// Module Name:   X:/telescope/firmware/debug/v1.0_4tele_SB1/sim/trigger_testbench.v
// Project Name:  multi_chip
// Target Device:  
// Tool versions:  
// Description: 
//
// Verilog Test Fixture created by ISE for module: trigger
//
// Dependencies:
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
////////////////////////////////////////////////////////////////////////////////

module trigger_testbench;

   // Inputs
   reg TRIGGER_CLK_IN;
   reg OPERATE_CLK_IN;
   reg ACTIVE_IN;
   reg BUSY_IN;
   reg START_IN;
   reg PAUSE_IN;
   reg STOP_IN;
   reg RESET_IN;
   reg NIM_TRIGGER;
   reg TRIGGER_RCVED_IN;
   reg INT_TRIG_IN;

   // Outputs
   wire TRIGGER_OUT;
   wire TRIGGERED_FLAG;
   wire RUNNING_FLAG;
   wire [31:0] EVENT_NUM;

   // Instantiate the Unit Under Test (UUT)
   trigger uut (
		.TRIGGER_CLK_IN(TRIGGER_CLK_IN), 
		.OPERATE_CLK_IN(OPERATE_CLK_IN), 
		.ACTIVE_IN(ACTIVE_IN), 
		.BUSY_IN(BUSY_IN),
      		.START_IN(START_IN),
		.PAUSE_IN(PAUSE_IN), 
      		.STOP_IN(STOP_IN), 
		.RESET_IN(RESET_IN), 
		.NIM_TRIGGER(NIM_TRIGGER), 
		.TRIGGER_RCVED_IN(TRIGGER_RCVED_IN), 
		.INT_TRIG_IN(INT_TRIG_IN), 
		.TRIGGER_OUT(TRIGGER_OUT), 
		.TRIGGERED_FLAG(TRIGGERED_FLAG),
		.RUNNING_FLAG(RUNNING_FLAG),
		.EVENT_NUM(EVENT_NUM)
		);

   parameter CYCLE50M = 20;
   parameter CYCLE40M = 25.0;
   
   //-------------------------------------------
   // generating 50 MHz CLK
   //-------------------------------------------
   initial begin
      TRIGGER_CLK_IN <= 1'b0;
      #50; //wait for CLK
      forever begin
	 TRIGGER_CLK_IN <= ~TRIGGER_CLK_IN; #(CYCLE50M/2.0);
      end
   end

   //-------------------------------------------
   // generating 40 MHz CLK
   //-------------------------------------------
   initial begin
      OPERATE_CLK_IN <= 1'b0;
      #50; //wait for CLK
      forever begin
	 OPERATE_CLK_IN <= ~OPERATE_CLK_IN; #(CYCLE40M/2.0);
      end
   end

   //-------------------------------------------
   // generating trigger
   //-------------------------------------------
   initial begin
      NIM_TRIGGER = 1'b1;
      #200; //wait for CLK
      forever begin
	 #330 NIM_TRIGGER = 1'b0;
	 #30  NIM_TRIGGER = 1'b1;
	 #0; // For skew
      end
   end


   initial begin
      TRIGGER_RCVED_IN = 1'b0;
   end
   
   always @(posedge TRIGGERED_FLAG)begin
      #230 TRIGGER_RCVED_IN = 1'b1;
      #50  TRIGGER_RCVED_IN = 1'b0;
   end
   
   initial begin
      BUSY_IN = 1'b0;
   end
   
   always @(posedge TRIGGERED_FLAG)begin
      #30  BUSY_IN = 1'b1;
      #240 BUSY_IN = 1'b0;
   end      

   initial begin
      // Initialize Inputs
      ACTIVE_IN = 0;
      START_IN = 0;
      STOP_IN = 0;
      PAUSE_IN = 0;
      RESET_IN = 0;
      INT_TRIG_IN = 1'b1;

      // Wait 100 ns for global reset to finish
      #100;
      // Add stimulus here
      ACTIVE_IN <= 1'b1;

      #1000 START_IN = 1'b1;
      #100 START_IN = 1'b0;
      
      #10000000 STOP_IN = 1'b1;
      #100 STOP_IN = 1'b0;

      #10000000 START_IN = 1'b1;
      #100 START_IN = 1'b0;
      
      #10000000 PAUSE_IN = 1'b1;
      #100 PAUSE_IN = 1'b0;

      #10000000 START_IN = 1'b1;
      #100 START_IN = 1'b0;
      
      #10000000 PAUSE_IN = 1'b1;
      #100 PAUSE_IN = 1'b0;

      #10000000 STOP_IN = 1'b1;
      #100 STOP_IN = 1'b0;

      #10000000 START_IN = 1'b1;
      #100 START_IN = 1'b0;

      #10000000 RESET_IN = 1'b1;
      #100  RESET_IN = 1'b0;

      #10000000 PAUSE_IN = 1'b1;
      #100 PAUSE_IN = 1'b0;

      #10000000 STOP_IN = 1'b1;
      #100 STOP_IN = 1'b0;

      #10000000 START_IN = 1'b1;
      #100 START_IN = 1'b0;
      
   end
   
endmodule

