
module time_stamp
  (
   CLK,         //IN
   TS_CLK,      //IN
   TRIGGER_IN,  //IN
   RESET,       //IN
   BUSY,        //IN
   TIMESTAMP_OUT//,  //OUT
   //CounterLoop
   );
   
   input CLK;
   input TS_CLK;
   input TRIGGER_IN;
   input RESET;
   input BUSY;
   output reg [23:0] TIMESTAMP_OUT;
   //output reg CounterLoop = 1'b0;
   
   //in upper module //assign RESET = ts_init_tcp_s | run_control_tcp_s;
   
   wire 	     trigger_s = TRIGGER_IN;
   wire 	     busy_s = BUSY;
   wire 	     ts_clk_s = (TS_CLK == 1'b1) ? 1'b1 : 1'b0;
   
   //Detect First Trigger
   reg 		     first_trigger_r = 1'b0;
   always @(posedge CLK or posedge RESET) begin
      if(RESET == 1'b1) begin
	 first_trigger_r <= 1'b0;
      end
      else if(trigger_s && ~first_trigger_r) begin
	 first_trigger_r <= 1'b1;
      end
   end
   wire first_trigger_s = first_trigger_r;
   
   //Detect TS_CLK Edge
   reg [7:0] ts_clk_edge_r = 8'h00;
   reg 	     detect_ts_clk_r = 1'b0;
   always @(posedge CLK or posedge RESET) begin 
      if(RESET == 1'b1) begin
	 ts_clk_edge_r <= 8'h00;
	 detect_ts_clk_r <= 1'b0;
      end
      else begin
	 ts_clk_edge_r[7:0] <= {ts_clk_edge_r[6:0], ts_clk_s}; //TS_CLK edge Detect
	 if(ts_clk_edge_r==8'h01) begin // (8'b00000001)
	    detect_ts_clk_r <= 1'b1;
	 end
	 else begin
	    detect_ts_clk_r <= 1'b0;
	 end
      end
   end
   wire detect_ts_clk_s = detect_ts_clk_r;
   
   reg 	ts_cnt_exe_r = 1'b0;
   reg [23:0] tstmp_cnt_r = 0;
   reg 	      ts_cnt_init_r = 1'b0;
   always @(posedge CLK or posedge RESET) begin //TS_CLK edge Detect and Counter
      if(RESET == 1'b1) begin
	 tstmp_cnt_r <= 0;
	 ts_cnt_exe_r <= 1'b0;
	 ts_cnt_init_r <= 1'b0;
      end
      else if(first_trigger_s) begin
	 if(~ts_cnt_exe_r && trigger_s)begin // Start Counter when First Trigger Detected.
	    tstmp_cnt_r <= 0;
	    ts_cnt_exe_r <= 1'b1;
         end
	 if(detect_ts_clk_s && ts_cnt_exe_r && ~ts_cnt_init_r) begin // Counter Loop
	    if(tstmp_cnt_r == 24'hffffff)begin
	       tstmp_cnt_r <= 0;
	       ts_cnt_exe_r <= 1'b0;
	    end
            else begin
	       tstmp_cnt_r <= tstmp_cnt_r + 1'b1;
	    end
	    ts_cnt_init_r <= 1'b1; // Hold(Lock) Counter
	 end
	 else if(~detect_ts_clk_s && ts_cnt_init_r) begin // UnLock Counter
	    ts_cnt_init_r <= 1'b0;
	    tstmp_cnt_r <= tstmp_cnt_r;
	    ts_cnt_exe_r <= ts_cnt_exe_r;
	 end
	 //CounterLoop <= tstmp_cnt_r[0];
      end
      else begin
	 ts_cnt_init_r <= ts_cnt_init_r;
	 tstmp_cnt_r <= tstmp_cnt_r;
	 ts_cnt_exe_r <= ts_cnt_exe_r;
      end
   end
   
   wire [23:0] tstmp_cnt_s;
   assign tstmp_cnt_s[23:0] = tstmp_cnt_r[23:0];
   
   always @(posedge trigger_s or posedge RESET)begin // Store TimeStamp by Trigger
      if(RESET==1'b1) begin
	 TIMESTAMP_OUT[23:0] <= 24'b000000000000000000000000;
      end
      else begin
	 TIMESTAMP_OUT[23:0] <= tstmp_cnt_s[23:0];
      end
   end 
   /*
    reg ts_hold_r = 1'b0; // Hold TimeStamp control
    always @(posedge CLK or posedge RESET)begin // Store TimeStamp by Trigger
    if(RESET==1'b1)
    begin
    TIMESTAMP_OUT[23:0] <= 24'b000000000000000000000000;
    ts_hold_r <= 1'b0;
        end
    else if(trigger_s && ~ts_hold_r) begin
    TIMESTAMP_OUT[23:0] <= tstmp_cnt_s[23:0];
    ts_hold_r <= 1'b1;
      end
    else if(~trigger_s)
    ts_hold_r <= 1'b0;
    else
    TIMESTAMP_OUT[23:0] <= TIMESTAMP_OUT[23:0];
   end 
    */
   
endmodule
