module trig_evnum(
		  TRIGGER_CLK_IN,
		  OPERATE_CLK_IN,
		  ACTIVE_IN,
		  BUSY_IN,
		  START_IN,
		  PAUSE_IN,
		  STOP_IN,
		  RESET_IN,
		  NIM_TRIGGER,      // IN
		  TRIGGER_RCVED_IN,
		  INT_TRIG_IN,
		  TRIGGER_OUT,
		  TRIGGERED_FLAG,   // OUT
		  RUNNING_FLAG,     //OUT
		  EVENT_NUM         // OUT
		  );

   input           TRIGGER_CLK_IN;	// For receiving Trigger (recommended 50MHz)
   input 	   OPERATE_CLK_IN;	// For making trigger signal
   input 	   ACTIVE_IN;		// Connection Active Flag
   input 	   BUSY_IN;		// Busy (It Cannot be Triggered)
   input 	   START_IN;		// For START or RESUME Command
   input 	   PAUSE_IN;            // For PAUSE command
   input 	   STOP_IN;		// For STOP or PAUSE Command
   input 	   RESET_IN;		// System RESET
   input 	   NIM_TRIGGER;  	// Trigger input
   input 	   TRIGGER_RCVED_IN;    // Flag meaning trigger is received normally
   input 	   INT_TRIG_IN;		// Switch to Internal Trigger
   output reg 	   TRIGGER_OUT;		// Pulse shaped trigger
   output reg 	   TRIGGERED_FLAG;	// Trigger flag
   output reg 	   RUNNING_FLAG;	// indicate DAQ is running
   output reg [31:0] EVENT_NUM;		// Event Number(32bit)


   ////////////////////////////////////////////
   // Prevent to trigger in busy or pile up
   // And Count Event Number
   //
   reg [23:0] 	     trig_wait_counter_r;
   reg [23:0] 	     int_trig_spacer_r;
   reg 		     stopping_r;

   wire 	     ir_busy_in_s;
   double_ff dff_trig(
		      .idata(BUSY_IN),
		      .oclk(TRIGGER_CLK_IN),
		      .odata(ir_busy_in_s)
		      );
   
   parameter [23:0]  TRIG_PERIOD = 24'd5_0000;
   always @(posedge TRIGGER_CLK_IN or posedge RESET_IN)begin
      if(RESET_IN == 1'b1)begin
	 TRIGGERED_FLAG <= 1'b0;
	 EVENT_NUM[31:0] <= 32'd0;
	 int_trig_spacer_r[23:0] <= 24'd0;
      end else begin
   	 if(ACTIVE_IN == 1'b0 || stopping_r == 1'b1)begin
	    TRIGGERED_FLAG <= 1'b0;
	    EVENT_NUM[31:0] <= 32'd0;
	    int_trig_spacer_r[23:0] <= 24'd0;
   	 end else begin
	    
	    if(ir_busy_in_s == 1'b0 && RUNNING_FLAG == 1'b1)begin
	       // Not Busy
	       if(INT_TRIG_IN == 1'b0)begin
		  // External Trigger
		  if(~NIM_TRIGGER == 1'b1 && TRIGGERED_FLAG == 1'b0)begin
		     TRIGGERED_FLAG <= 1'b1;
		  end 
	       end else begin
		  // Internal Trigger
		  if(int_trig_spacer_r[23:0] < TRIG_PERIOD)begin
		     int_trig_spacer_r[23:0] <= int_trig_spacer_r[23:0] + 24'd1;
		  end else begin
		     int_trig_spacer_r[23:0] <= 24'd0;
		     TRIGGERED_FLAG <= 1'b1;
		  end
	       end // else: !if(INT_TRIG_IN == 1'b0)
	    end else if((TRIGGER_RCVED_IN == 1'b1 && TRIGGERED_FLAG == 1'b1)
			|| trig_wait_counter_r[23:0] == 24'd50_0000/*10ms*/)begin
	       // In Busy or Pausing
	       TRIGGERED_FLAG <= 1'b0;
	       EVENT_NUM[31:0] <= EVENT_NUM[31:0] + 32'd1;
	    end
	    
	 end // else: !if(ACTIVE_IN == 1'b0 || stopping_r == 1'b1)
      end // else: !if(RESET_IN == 1'b1)
   end // always @ (posedge TRIGGER_CLK_IN or posedge RESET_IN)


   ////////////////////////////////////////
   // Waiting for TRIGGER_RCVED_IN
   //
   always @(posedge TRIGGER_CLK_IN or posedge RESET_IN)begin
      if(RESET_IN == 1'b1)begin
	 trig_wait_counter_r[23:0] <= 24'd0;
      end else begin
   	 if(ACTIVE_IN == 1'b0)begin
	    trig_wait_counter_r[23:0] <= 24'd0;
   	 end else begin
	    
	    if(TRIGGERED_FLAG == 1'b1)begin
	       trig_wait_counter_r[23:0] <= trig_wait_counter_r[23:0] + 24'd1;
	    end else begin
	       trig_wait_counter_r[23:0] <= 24'd0;
	    end
	    
   	 end // else: !if(ACTIVE_IN == 1'b0)
      end // else: !if(RESET_IN == 1'b1)
   end // always @ (posedge TRIGGER_CLK_IN or posedge RESET_IN)
   

   ////////////////////////////////////////
   // For SCTJDAQ Command Operation
   //
   always @(posedge TRIGGER_CLK_IN or posedge RESET_IN)begin
      if(RESET_IN == 1'b1)begin
	 RUNNING_FLAG <= 1'b0;
	 stopping_r <= 1'b1;
      end else begin
	 if(ACTIVE_IN == 1'b0)begin
	    RUNNING_FLAG <= 1'b0;
	    stopping_r <= 1'b1;
	 end else begin
	    
	    if(STOP_IN == 1'b1)begin
	       RUNNING_FLAG <= 1'b0;
	       stopping_r <= 1'b1;
	    end else if(PAUSE_IN == 1'b1 && RUNNING_FLAG == 1'b1)begin
	       RUNNING_FLAG <= 1'b0;
	    end else if(START_IN == 1'b1 && RUNNING_FLAG == 1'b0)begin
	       RUNNING_FLAG <= 1'b1;
	       stopping_r <= 1'b0;
	    end
	    
	 end // else: !if(ACTIVE_IN == 1'b0)
      end // else: !if(RESET_IN == 1'b1)
   end // always @ (posedge TRIGGER_CLK_IN or posedge RESET_IN)

   
   /////////////////////////////////////////
   // Create pulse shaped trigger
   //
   parameter   Trig_width = 3'd2;
   reg [2:0]   trig_width_cnt_r;
   
   always @(posedge OPERATE_CLK_IN or posedge RESET_IN)begin
      if(RESET_IN == 1'b1)begin
	 trig_width_cnt_r[2:0] <= 3'd0;
	 TRIGGER_OUT <= 1'b0;
      end else begin
	 if(ACTIVE_IN == 1'b0)begin
	    trig_width_cnt_r[2:0] <= 3'd0;
	    TRIGGER_OUT <= 1'b0;
	 end else begin
	    
	    if(TRIGGERED_FLAG == 1'b1)begin
	       if(trig_width_cnt_r[2:0] >= Trig_width)begin
		  trig_width_cnt_r[2:0] <= trig_width_cnt_r[2:0];
		  TRIGGER_OUT <= 1'b0;
	       end else begin
		  trig_width_cnt_r[2:0] <= trig_width_cnt_r[2:0] + 3'd1;
		  TRIGGER_OUT <= 1'b1;
	       end
	    end else begin
	       trig_width_cnt_r[2:0] <= 3'd0;
	       TRIGGER_OUT <= 1'b0;
	    end // else: !if(TRIGGERED_FLAG == 1'b1)
	    
	 end // else: !if(ACTIVE_IN == 1'b0)
      end // else: !if(RESET_IN == 1'b1)
   end // always @ (posedge OPERATE_CLK_IN or posedge RESET_IN)
   
endmodule
