

`timescale 1ns / 1ps
module addr_cnt_sim;



   //sim parameter
   
   parameter [31:0] trigger_cnt_r = 32'd0;
   parameter [15:0] number_event_r = 16'd500;
   parameter USR_TX_AFULL = 1'b0;
   parameter CLK_sel = 1'b0;
   parameter [15:0] ctrl_RD_s = 16'd0;
   
   reg DataSndActive_r = 1'b1;
   reg ctrl2_comp_r;
   reg ctrlActive_r;
   reg CLK_50M;
   reg RST_DLL;
   reg USR_ACTIVE;
   
   reg confActive_r = 1'b0;
   reg CHMODE_r = 0;
   reg FEMODE_r = 0;
   reg BEMODE_r = 0;
   wire CHMODE;
   wire FEMODE;
   wire BEMODE;
   
   
   wire 	clk_210M_s;// back-end clock * 4
   wire 	clk_50M_s;
   wire 	clk_76M_s; 	
   wire 	clk_38M_s;// front-end clock * 5 : to create 7.6MHz
   wire 	clk_25M_s;
   wire 	clk_19M_s;
   
   wire 	locked_s;

   wire 	clk_105M_s;
   wire 	clk_be1_s;// digitize mode
   wire 	clk_be2_s;// readout mode
   wire 	clk_fe1_s;
   wire 	clk_fe2_s;
   wire 	clk_sitcp_s;// 12.5MHz
   wire         clk_100k_s;
   

   wire 	operate_clk_s;   // operation clock
   wire 	clk_TX_s;
   
   
   wire 	feclk_s;
   wire 	clk_acq_s;
   wire 	clk_dig_s;
   wire 	feclk_sel_s;
   wire 	feclk_sel2_s;
   wire 	clk_op_s;
   
   reg [3:0] 	clk_selector_r;
  
 
   reg [23:0] address_cnt_r;
   reg [23:0] wait_cnt_r;

   reg 	      rst_mode_r;
   reg 	      init_rst_r;
   reg        init_rst_end_r;
   reg 	      pipe_rst_r;
   
   wire       pipe_rst_s;
   
  
   parameter wait_p = 24'd1000;


   assign clk_50M_s = CLK_50M;
   assign ctrl_RE_s = ctrl2_comp_r;
   
  

   
   //sim
   
   always #10 begin
      CLK_50M = ~CLK_50M;
   end
 
   initial begin
      CLK_50M = 0;
      USR_ACTIVE = 0;
      RST_DLL = 1;
      clk_selector_r[3:0] = 4'b1111;
      ctrl2_comp_r = 0;
      ctrlActive_r = 0;
      address_cnt_r[23:0] =24'd0;

      init_mode_r = 0;
      acq_mode_r = 0;
      digit_mode_r = 0;
      read_mode_r = 0; 
      
            
      #50 USR_ACTIVE = 1;
      #50 RST_DLL = 0;      
      #100confActive_r = 1;
      #500 ctrl2_comp_r = 1;
      #100 ctrlActive_r = 1;
      #500 digit_mode_r = 1;
    
      
      
      
   end

   // ================================================================ //
   //                 Create operation clocks for SVX4                 //
   // ================================================================ //

   clk_dcm clk_dcm(
		   .U1_CLKIN_IN(CLK_50M), 
		   .U1_RST_IN(RST_DLL), 
		   .U1_CLKDV_OUT(clk_25M_s), 
		   .U1_CLKFX_OUT(clk_210M_s), 
		   .U1_CLK0_OUT(clk_50M_s), 
		   .U2_CLKFX_OUT(clk_76M_s), 
		   .U2_LOCKED_OUT(locked_s)
		   );

   clk_maker clk_maker(
		       .EXT_RESET(RST_DLL), // IN
		       //.EXT_FLAG(CLK_sel), // IN
		       .CLK_210M(clk_210M_s), // IN
		       .CLK_76M(clk_76M_s), // IN
		       .CLK_38M(clk_38M_s),
		       .CLK_19M(clk_19M_s),
		       .CLK_9500k(clk_9500k_s),
		       .CLK_25M(clk_25M_s), // IN
		       .CLK_105M(clk_105M_s), // OUT
		       .CLK_52500k(clk_be1_s), // OUT
		       .CLK_26250k(clk_be2_s), // OUT
		       .CLK_7500k(clk_fe2_s), // OUT
		       .CLK_7600k(clk_fe1_s), // OUT
		       .CLK_12500k(clk_sitcp_s), // OUT
		       .CLK_100k(clk_100k_s)     //OUT
		       );



   assign clk_acq_s = (clk_selector_r[2] == 1'b1) ? clk_76M_s : feclk_sel_s;
   assign feclk_sel_s = (clk_selector_r[3] == 1'b1) ? clk_38M_s : clk_19M_s;
   
   assign clk_dig_s = (clk_selector_r[2] == 1'b1) ? clk_210M_s : feclk_sel2_s;
   assign feclk_sel2_s = (clk_selector_r[3] == 1'b1) ? clk_105M_s : clk_be1_s;

   assign feclk_s = (USR_TX_AFULL == 1'b0) ? clk_TX_s : 1'b0; 
   assign clk_TX_s = (CLK_sel == 1'b0) ? clk_acq_s : clk_dig_s;// select text send clock

   assign clk_op_s = (CLK_sel == 1'b0) ? clk_38M_s : clk_dig_s;
   assign operate_clk_s = (USR_TX_AFULL == 1'b0) ? clk_op_s : 1'b0;

   
//-------------FE CLK -------------------------------
   reg [2:0] 	fe_cnt_r;
   reg 		feclk_in_r;
   wire 	feclk_in_s;
   
   always @(posedge clk_38M_s)begin
      if(locked_s == 1'b0)begin
	 fe_cnt_r[2:0] <= 0;
      end else begin
	 if(fe_cnt_r[2:0] == 3'd5)begin
	    fe_cnt_r[2:0] <= 3'd1;      
	 end else begin
	    fe_cnt_r[2:0] <= fe_cnt_r[2:0] + 1'b1;
	 end
      end
   end
      
   always @(posedge clk_38M_s)begin
      if(locked_s == 1'b0)begin
	 feclk_in_r <= 0;
      end else begin
	 if(fe_cnt_r[2:0] == 3'd1)begin
	    feclk_in_r <= 1'b1;      
	 end else begin
	    feclk_in_r <= 1'b0;
	 end
      end
   end
   
   assign feclk_in_s = feclk_in_r;
//------------------------------------------------------   

  /* ================= operation mode selector ============== */


   
   wire 	femode_s;
   wire 	bemode_s;
   wire 	chmode_s;

   wire 	init_mode_s;
   wire 	acq_mode_s;
   wire 	digit_mode_s;
   wire 	read_mode_s; 
   
   reg 		init_mode_r = 1'b0;
   reg 		acq_mode_r = 1'b0;
   reg 		digit_mode_r = 1'b0;
   reg 		read_mode_r = 1'b0; 

   // mode change creator
   
   reg 		chmode_init_r = 1'b0;
   reg 		chmode_acq_r = 1'b0;
   reg 		chmode_digit_r = 1'b0;
   reg 		chmode_read_r = 1'b0;

   wire 	chmode_init_s;
   wire 	chmode_acq_s;
   wire 	chmode_digit_s;
   wire 	chmode_read_s;

   chmode_creator chmode_creator(
				 // input 
				 .CH_INIT(chmode_init_s),
				 .CH_ACQ(chmode_acq_s),
				 .CH_DIGIT(chmode_digit_s),
				 .CH_READ(chmode_read_s),
				 .CLK_OPERATE(feclk_s),
				 .ACTIVE(USR_ACTIVE),
				 // output				 
				 .CRT_CHMODE(chmode_s),
				 .CRT_FEMODE(femode_s),
				 .CRT_BEMODE(bemode_s)
				 //.TEST(test_s)
				 );

   assign chmode_init_s = init_rst_r == 1'b1 ? 1'b1 : chmode_init_r;
   assign chmode_acq_s = init_rst_end_r == 1'b1 ? 1'b1 : chmode_acq_r;
   assign chmode_digit_s = chmode_digit_r;
   assign chmode_read_s = chmode_read_r;

      
   always @(posedge operate_clk_s)begin
      if(confActive_r == 1'b0)begin
	 init_mode_r <= 1'b1;
	 acq_mode_r <= 1'b0;
	 digit_mode_r <= 1'b0;
	 read_mode_r <= 1'b0;
      end else if(DataSndActive_r == 1'b1 && CHMODE == 1'b1)begin
	 if(FEMODE == 1'b0 && BEMODE  == 1'b0)begin
	    init_mode_r <= 1'b1;
	    acq_mode_r <= 1'b0;
	    digit_mode_r <= 1'b0;
	    read_mode_r <= 1'b0;
	 end else if(FEMODE == 1'b0 && BEMODE  == 1'b1)begin
	    init_mode_r <= 1'b0;
	    acq_mode_r <= 1'b1;
	    digit_mode_r <= 1'b0;
	    read_mode_r <= 1'b0;
	 end else if(FEMODE == 1'b1 && BEMODE  == 1'b1)begin
	    init_mode_r <= 1'b0;
	    acq_mode_r <= 1'b0;
	    digit_mode_r <= 1'b1;
	    read_mode_r <= 1'b0;
	 end else if(FEMODE == 1'b1 && BEMODE  == 1'b0)begin
	    init_mode_r <= 1'b0;
	    acq_mode_r <= 1'b0;
	    digit_mode_r <= 1'b0;
	    read_mode_r <= 1'b1;
	 end
	 /*      end else begin // if (DataSndActive)
	  init_mode_r <= 1'b0;
	  acq_mode_r <= 1'b0;
	  digit_mode_r <= 1'b0;
	  read_mode_r <= 1'b0;*/
      end // else: !if(DataSndActive)
   end // always @ (posedge operate_clk_s)
      
   assign init_mode_s = init_mode_r;
   assign acq_mode_s = acq_mode_r;
   assign digit_mode_s = digit_mode_r;
   assign read_mode_s = read_mode_r;

   // CLOCK selector
   
   wire 	ChCLK_s;
   wire 	beclk_sel_s;
   wire 	beclk_sel2_s;
   wire  	clk_select_s;

   /*
   always @(posedge operate_clk_s)begin
      if(USR_ACTIVE == 1'b0)begin
	 clk_selector_r[3:0] <= 4'b0101;
      end else if(SIO_ADDR[31:0] == 32'hefffffff)begin
	 clk_selector_r[3:0] <= SIO_WD[3:0];
      end
   end
   */
   
   assign ChCLK_s = (digit_mode_r == 1'b1 | read_mode_s == 1'b1) ? 1'b1 : 1'b0;
   assign beclk_sel_s = (read_mode_s == 1'b1) ? clk_25M_s : beclk_sel2_s;
   assign beclk_sel2_s = (clk_selector_r[0] == 1'b1) ? clk_be1_s : clk_select_s;
   assign clk_select_s = (clk_selector_r[1] == 1'b1) ? clk_25M_s : clk_sitcp_s;


   /* =========================================================================== */
   /*                        INPUT SIGNAL ASSIGNMENT                              */
   /* =========================================================================== */

   wire prin_s;
   wire fe_clk_s;
   wire be_clk_s;
   wire[7:0] bus_s;
   
   reg 	serial_prin_r;
   reg 	serial_feclk_r;
   reg [7:0] ctrl_out_r;
   reg 	     shadow_reg_r;
   
   

   assign CHMODE = init_mode_s || rst_mode_r  ? chmode_s : ctrl_RD_s[15];
   assign FEMODE = init_mode_s || rst_mode_r ? femode_s : ctrl_RD_s[14];
   assign BEMODE = init_mode_s || rst_mode_r ? bemode_s : ctrl_RD_s[13];

   assign prin_s = init_mode_s ? serial_prin_r : ctrl_RD_s[12];
   assign fe_clk_s = rst_mode_r ? 1'b0 : init_mode_s ? serial_feclk_r : ctrl_RD_s[10];
   assign be_clk_s = CLK_sel == 1'b1 ? beclk_sel_s : 1'b0;

   //assign CLK_sel  = ctrl_out_r[11];
   
   assign bus_s[0] = init_mode_s ? 1'b0 : ctrl_out_r[7];
   assign bus_s[1] = init_mode_s ? 1'b0 : ctrl_out_r[6];
   assign bus_s[2] = init_mode_s ? 1'b0 : ctrl_out_r[5];
   assign bus_s[3] = init_mode_s ? 1'b0 : ctrl_out_r[4];
   assign bus_s[4] = init_mode_s ? 1'b1 : ctrl_out_r[3];
   assign bus_s[5] = init_mode_s ? 1'b1 : ctrl_out_r[2];
   assign bus_s[6] = init_mode_s ? 1'b0 : ctrl_out_r[1];
//   assign bus_s[7] =  rst_mode_r ? pipe_rst_r : init_mode_s ? shadow_reg_r : ctrl_out_r[0];
   assign bus_s[7] = init_mode_s ? (rst_mode_r ? pipe_rst_r : shadow_reg_r ) : ctrl_out_r[0];
   
   /* ============================================================= */
   /*                     Initialize reset                          */
   /* ============================================================= */



   always @(posedge feclk_s)begin
      if(wait_cnt_r[23:0] == 24'd0)begin
	 rst_mode_r <= 1'b0;
      end else begin
	 if(wait_cnt_r[23:0] == wait_p + 24'd100)begin
	    rst_mode_r <= 1'b1;
	 end else if(wait_cnt_r[23:0] == wait_p + 24'd220)begin
	    rst_mode_r <= 1'b0;
	 end
      end
   end 
   
   //change to initialize mode
   always @(posedge feclk_s)begin
      if(wait_cnt_r[23:0] == 24'd0)begin
	 init_rst_r <= 1'b0;
      end else begin
	 if(wait_cnt_r[23:0] > wait_p + 24'd100 && wait_cnt_r[23:0] < wait_p + 24'd120)begin
	    init_rst_r <= 1'b1;
	 end else begin
	    init_rst_r <= 1'b0;
	 end
      end
   end 

   //change to acquire mode
   always @(posedge feclk_s)begin
      if(wait_cnt_r[23:0] == 24'd0)begin
	 init_rst_end_r <= 1'b0;
      end else begin
	 if(wait_cnt_r[23:0] > wait_p + 24'd200 && wait_cnt_r[23:0] < wait_p + 24'd220)begin
	    init_rst_end_r <= 1'b1;
	 end else begin
	    init_rst_end_r <= 1'b0;
	 end
      end
   end

   //rise CAL_SR for pipeline reset
   always @(posedge feclk_s)begin
      if(wait_cnt_r[23:0] == 24'd0)begin
	 pipe_rst_r <= 1'b0;
      end else begin
	 if(wait_cnt_r[23:0] > wait_p + 24'd175 && wait_cnt_r[23:0] < wait_p + 24'd177)begin
	    pipe_rst_r <= 1'b1;
	 end else begin
	    pipe_rst_r <= 1'b0;
	 end
      end
   end

   assign pipe_rst_s = pipe_rst_r;
      
   

   // Address Counter

      

   always @(posedge feclk_s)begin
      if(ctrlActive_r == 1'b0)begin
	 wait_cnt_r[23:0] <= 24'd0;
	 address_cnt_r[13:0] <= 14'd5;
      end else begin
	 if( ctrl_RE_s == 1'b1 && (address_cnt_r[13:0] < 14'd8535) && (trigger_cnt_r[15:0] < number_event_r[15:0]) )begin
	    
	    if(address_cnt_r[13:0] == 14'd8335)begin
	       if(wait_cnt_r[23:0] != (wait_p + 24'd1000))begin
		  wait_cnt_r[23:0] <= wait_cnt_r[23:0] + 24'd1;
	       end else if(wait_cnt_r[23:0] == (wait_p + 24'd1000))begin
		  address_cnt_r[13:0] <= address_cnt_r[13:0] + 14'd1;
	    	  wait_cnt_r[23:0] <= 24'd0;
	       end
	    end else begin
	       address_cnt_r[13:0] <= address_cnt_r[13:0] + 14'd1;	       
	    end
	    
	 end else if(address_cnt_r[13:0] == 14'd8535
		     && (trigger_cnt_r[15:0] < number_event_r[15:0]))begin
	    address_cnt_r[13:0] <= 14'd2;
	 end else begin
	    address_cnt_r[13:0] <=  address_cnt_r[13:0];
	 end 
      end
   end
   
   
endmodule
