`timescale 1ns / 1ps

////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer:
//
// Create Date:   11:18:17 01/07/2015
// Design Name:   conf_maker
// Module Name:   X:/telescope/firmware/debug/v4.0_4tele_SB1/sim/conf_testbench.v
// Project Name:  multi_chip
// Target Device:  
// Tool versions:  
// Description: 
//
// Verilog Test Fixture created by ISE for module: conf_maker
//
// Dependencies:
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
////////////////////////////////////////////////////////////////////////////////

module conf_testbench;

   // Inputs
   reg OPERATE_CLK_IN;
   reg REG_CLK_IN;
   reg ACTIVE_IN;
   reg CONF_START_IN;
   reg RESET_IN;
   reg [11:0] SIO_ADDR_IN;
   reg [7:0]  SIO_WD_IN;
   reg 	      SIO_WE_IN;
   reg 	      PROUT_IN;

   // Outputs
   wire       RAM_LOADED_OUT;
   wire       CONFIGURED_OUT;
   wire       PRIN_OUT;
   wire       FECLK_OUT;
   wire       CALSR_OUT;

   // Instantiate the Unit Under Test (UUT)
   conf_maker uut (
		   .OPERATE_CLK_IN(OPERATE_CLK_IN), 
		   .REG_CLK_IN(REG_CLK_IN), 
		   .ACTIVE_IN(ACTIVE_IN), 
		   .CONF_START_IN(CONF_START_IN), 
		   .RESET_IN(RESET_IN), 
		   .SIO_ADDR_IN(SIO_ADDR_IN), 
		   .SIO_WD_IN(SIO_WD_IN), 
		   .SIO_WE_IN(SIO_WE_IN), 
		   .PROUT_IN(PROUT_IN), 
		   .RAM_LOADED_OUT(RAM_LOADED_OUT), 
		   .CONFIGURED_OUT(CONFIGURED_OUT),
      		   .CALSR_OUT(CALSR_OUT),
		   .PRIN_OUT(PRIN_OUT),
		   .FECLK_OUT(FECLK_OUT)
		   );

   
   //-------------------------------------------
   //generating 40 MHz CLK
   //-------------------------------------------
   parameter CYCLE40M = 25.0;
   
   initial begin
      OPERATE_CLK_IN <= 1'b0;
      #50 //wait for CLK
      forever begin
	 OPERATE_CLK_IN <= ~OPERATE_CLK_IN; #(CYCLE40M/2.0);
      end
   end


   //-------------------------------------------
   //generating 500 kHz CLK
   //-------------------------------------------
   parameter CYCLE500k = 2000;
   
   initial begin
      REG_CLK_IN <= 1'b1;
      #50 //wait for CLK
      forever begin
	 REG_CLK_IN <= ~REG_CLK_IN; #(CYCLE500k/2.0);
      end
   end


   //-------------------------------------------
   // Emulating Data and OBDV
   //-------------------------------------------
   reg data_emu_r;
   
   initial begin
      SIO_WD_IN = 8'b0;
      SIO_ADDR_IN[11:0] = 12'b0;
   end
   
   always @(posedge REG_CLK_IN)begin
      if(data_emu_r == 1'b1)begin
	 if(SIO_WE_IN == 1'b1)begin
	    SIO_ADDR_IN[11:0] <= SIO_ADDR_IN[11:0] + 12'd1;
	 end else begin
	    SIO_ADDR_IN[11:0] <= 12'd0;
	 end
      end
   end
   
   always @(posedge REG_CLK_IN)begin
      if(data_emu_r == 1'b1)begin
	 if(SIO_WE_IN == 1'b1)begin
	    SIO_WD_IN[7:0] <=  SIO_WD_IN[7:0] + 8'd2;
	 end else begin
	    SIO_WD_IN[7:0] <= 8'd1;
	 end
      end
   end

   
   initial begin
      // Initialize Inputs
      ACTIVE_IN = 0;
      RESET_IN = 0;
      CONF_START_IN = 0;
      SIO_WE_IN = 0;
      PROUT_IN = 0;

      // Wait 100 ns for global reset to finish
      #100;
      ACTIVE_IN = 1'b1;
      data_emu_r = 1'b1;
      
      // Add stimulus here
      #3000;
      SIO_WE_IN = 1'b1;
      #100000;
      SIO_WE_IN = 1'b0;
      #3000;
      data_emu_r = 1'b0;

      #1000;
      SIO_WE_IN = 1'b1;
      SIO_WD_IN[7:0] = 8'b1100_1100;
      SIO_ADDR_IN[11:0] <= 12'd150;
      #2000;
      SIO_WE_IN = 1'b0;
      SIO_WD_IN[7:0] = 8'b0;
      SIO_ADDR_IN[11:0] <= 12'd0;

      #10000;
      CONF_START_IN = 1'b1;
      #2000;
      CONF_START_IN = 1'b0;
      

      #3000;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;

      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;

      #10000;
      CONF_START_IN = 1'b1;
      #2000;
      CONF_START_IN = 1'b0;
      
      #3000;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;

      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;
      #125 PROUT_IN <= 1'b1;
      #125 PROUT_IN <= 1'b0;	
      
      
      #3000;
      RESET_IN <= 1'b1;
      
      // Add stimulus here

   end
   
endmodule

