`timescale 1ns / 1ps

////////////////////////////////////////////////////////////////////////////////
// Company: 
// Engineer:
//
// Create Date:   16:51:01 12/06/2014
// Design Name:   mode_changer
// Module Name:   Z:/Desktop/v1.0_4tele_SB1/sim/mode_testbench.v
// Project Name:  multi_chip
// Target Device:  
// Tool versions:  
// Description: 
//
// Verilog Test Fixture created by ISE for module: mode_changer
//
// Dependencies:
// 
// Revision:
// Revision 0.01 - File Created
// Additional Comments:
// 
////////////////////////////////////////////////////////////////////////////////

module mode_testbench;

   // Inputs
   reg OPERATE_CLK_IN;
   reg ACTIVE_IN;
   reg RESET_IN;
   reg BEMODE_IN;
   reg FEMODE_IN;
   reg RUN_FLAG_IN;

   // Outputs
   wire BEMODE_OUT;
   wire FEMODE_OUT;
   wire CHMODE_OUT;
   wire INIT_FLAG;
   wire ACQ_FLAG;
   wire DIGIT_FLAG;
   wire READ_FLAG;
   wire RST_FLAG;
   wire ERROR_OUT;

   // Instantiate the Unit Under Test (UUT)
   mode_changer uut (
		     .OPERATE_CLK_IN(OPERATE_CLK_IN), 
		     .ACTIVE_IN(ACTIVE_IN), 
		     .RESET_IN(RESET_IN), 
		     .BEMODE_IN(BEMODE_IN), 
		     .FEMODE_IN(FEMODE_IN), 
		     .RUN_FLAG_IN(RUN_FLAG_IN), 
		     .BEMODE_OUT(BEMODE_OUT), 
		     .FEMODE_OUT(FEMODE_OUT), 
		     .CHMODE_OUT(CHMODE_OUT), 
		     .INIT_FLAG(INIT_FLAG), 
		     .ACQ_FLAG(ACQ_FLAG), 
		     .DIGIT_FLAG(DIGIT_FLAG), 
		     .READ_FLAG(READ_FLAG), 
		     .RST_FLAG(RST_FLAG), 
		     .ERROR_OUT(ERROR_OUT)
		     );


   parameter CYCLE40M = 25.0;
   
   //-------------------------------------------
   //generating 40 MHz CLK
   //-------------------------------------------
   initial begin
      OPERATE_CLK_IN <= 1'b0;
      #50 //wait for CLK
      forever begin
	 OPERATE_CLK_IN <= ~OPERATE_CLK_IN; #(CYCLE40M/2.0);
      end
   end

   initial begin
      // Initialize Inputs
      ACTIVE_IN = 0;
      RESET_IN = 0;
      BEMODE_IN = 0;
      FEMODE_IN = 0;
      RUN_FLAG_IN = 0;

      // Wait 100 ns for global reset to finish
      #100;
      
      // Add stimulus here
      #105 ACTIVE_IN = 1'b1;

      #1000;
      BEMODE_IN = 1'b1;
      FEMODE_IN = 1'b0;

      #500;
      RUN_FLAG_IN = 1'b1;
      
      #500;
      BEMODE_IN = 1'b1;
      FEMODE_IN = 1'b1;

      #1000;
      BEMODE_IN = 1'b0;
      FEMODE_IN = 1'b1;

      #450;
      BEMODE_IN = 1'b1;
      FEMODE_IN = 1'b0;
      #50;
      BEMODE_IN = 1'b0;
      FEMODE_IN = 1'b1;

      #500;
      BEMODE_IN = 1'b0;
      FEMODE_IN = 1'b0;

      #1000;
      BEMODE_IN = 1'b1;
      FEMODE_IN = 1'b1;

      #1000;
      ACTIVE_IN = 1'b0;
      RUN_FLAG_IN = 1'b1;

      #1000;
      ACTIVE_IN = 1'b1;

      #3000;
      RESET_IN = 1'b1;
      #200;
      RESET_IN = 1'b0;
      
            
   end
   
endmodule

