module header_tele(
		   OPERATE_CLK_IN,
		   ACTIVE, // IN
		   EVENT_NUM_IN,
		   TIMESTAMP_IN,
		   STATUS_IN,
		   TRIGGER_IN,
		   TRIGGER_RCVED_IN,
		   RESET_IN, // IN
		   HEADER_OUT,
		   HEADER_WE // OUT
		   );
   
   input         OPERATE_CLK_IN;   // CLK for operation of this module
   input         ACTIVE;	   // Connection Active Flag
   input [31:0]  EVENT_NUM_IN;	   // Input of Event Number(32bit)
   input [23:0]  TIMESTAMP_IN;	   // Input of Timestamp(24bit)
   input [7:0] 	 STATUS_IN;     // Input of tele's status
   input 	 TRIGGER_IN;	   // Trigger of writing header
   input 	 TRIGGER_RCVED_IN; // Trigger received
   input 	 RESET_IN;	   // System RESET
   output reg [7:0] HEADER_OUT;	   // Output Header(8bit x 16)
   output reg 	    HEADER_WE;	   // Header Write Enable Flag

   
   reg [3:0] 	    header_counter_r;
   reg 		    header_written_r; // To prevent double header writing
   reg 		    rcved_flag_r;     // Hold TRIGGER_RCVED_IN

   
   ///////////////////////////////////
   // header write enable flag
   // & header counter
   //
   always @(posedge OPERATE_CLK_IN or posedge RESET_IN)begin
      if(RESET_IN == 1'b1)begin
	 HEADER_WE <= 1'b0;
	 header_counter_r[3:0] <= 4'd0;
      end else begin
   	 if(ACTIVE == 1'b0)begin
	    HEADER_WE <= 1'b0;
	    header_counter_r[3:0] <= 4'd0;
   	 end else begin
	    
	    if(HEADER_WE == 1'b0)begin
	       if(TRIGGER_IN == 1'b1
		  && header_written_r == 1'b0)begin
		  HEADER_WE <= 1'b1;
		  header_counter_r[3:0] <= header_counter_r[3:0] + 4'd1;
	       end else begin
		  header_counter_r[3:0] <= 4'd0;
	       end
	    end else begin
	       if(header_counter_r[3:0] >= 4'd15)begin
		  HEADER_WE <= 1'b0;
		  header_counter_r[3:0] <= header_counter_r[3:0];
	       end else begin
		  header_counter_r[3:0] <= header_counter_r[3:0] + 4'd1;
	       end
	    end // else: !if(HEADER_WE == 1'b0)
	    
   	 end // else: !if(ACTIVE == 1'b0)
      end // else: !if(RESET_IN == 1'b1)
   end // always @ (posedge OPERATE_CLK_IN or posedge RESET_IN)
   

   ///////////////////////////
   // header written flag
   //
   always @(posedge OPERATE_CLK_IN or posedge RESET_IN)begin
      if(RESET_IN == 1'b1)begin
	 header_written_r <= 1'b0;
      end else begin
   	 if(ACTIVE == 1'b0)begin
	    header_written_r <= 1'b0;
   	 end else begin
	    
	    if(rcved_flag_r == 1'b1
	       && header_written_r == 1'b1)begin
	       header_written_r <= 1'b0;
	    end else if(header_counter_r[3:0] >= 4'd15)begin
	       header_written_r <= 1'b1;
	    end
	    
   	 end // else: !if(ACTIVE == 1'b0)
      end // else: !if(RESET_IN == 1'b1)
   end // always @ (posedge OPERATE_CLK_IN or posedge RESET_IN)
   
   always @(posedge OPERATE_CLK_IN or posedge RESET_IN)begin
      if(RESET_IN == 1'b1)begin
	 rcved_flag_r <= 1'b0;
      end else begin
   	 if(ACTIVE == 1'b0)begin
	    rcved_flag_r <= 1'b0;
   	 end else begin
	    
	    if(TRIGGER_RCVED_IN == 1'b1)begin
	       rcved_flag_r <= 1'b1;
	    end else if(TRIGGER_IN == 1'b1)begin
	       rcved_flag_r <= 1'b0;
	    end
	    
   	 end // else: !if(ACTIVE == 1'b0)
      end // else: !if(RESET_IN == 1'b1)
   end // always @ (posedge OPERATE_CLK_IN or posedge RESET_IN)
   
   always @(posedge OPERATE_CLK_IN or posedge RESET_IN)begin
      if(RESET_IN == 1'b1)begin
	 HEADER_OUT[7:0] <= 8'd0;
      end else begin
   	 if(ACTIVE == 1'b0)begin
	    HEADER_OUT[7:0] <= 8'd0;
   	 end else begin
	    
	    case(header_counter_r)
	      4'd1: HEADER_OUT[7:0] <= 8'd0;
	      4'd2: HEADER_OUT[7:0] <= 8'd3;
	      4'd3: HEADER_OUT[7:0] <= 8'd6;
	      4'd4: HEADER_OUT[7:0] <= 8'd13;
       	      4'd5: HEADER_OUT[7:0] <= EVENT_NUM_IN[31:24];
	      4'd6: HEADER_OUT[7:0] <= EVENT_NUM_IN[23:16];
	      4'd7: HEADER_OUT[7:0] <= EVENT_NUM_IN[15:8];
	      4'd8: HEADER_OUT[7:0] <= EVENT_NUM_IN[7:0];
	      4'd9: HEADER_OUT[7:0] <= TIMESTAMP_IN[23:16];
	      4'd10: HEADER_OUT[7:0] <= TIMESTAMP_IN[15:8];
	      4'd11: HEADER_OUT[7:0] <= TIMESTAMP_IN[7:0];
	      4'd12: HEADER_OUT[7:0] <= STATUS_IN[7:0];
	      4'd13: HEADER_OUT[7:0] <= 8'd255;
	      4'd14: HEADER_OUT[7:0] <= 8'd0;
	      default: HEADER_OUT[7:0] <= 8'd0;
	    endcase // case (header_counter_r)
	    
   	 end // else: !if(ACTIVE == 1'b0)
      end // else: !if(RESET_IN == 1'b1)
   end // always @ (posedge OPERATE_CLK_IN or posedge RESET_IN)
   
endmodule
