module RST_GEN(
	       CLK_IN, //in  : Raw clock
	       // For DCM
	       DCM_LOCKED, // in  : dcm_locked signal
	       DCM_RST   , // out : RST for DCM
	       // For PLL
	       PLL_LOCKED, // in  : pll_locked signal
	       PLL_RST,    // out : RST for PLL
               WAIT        // out : Have to halt DAQ when it's "Hi".
	       );
   
   //-------- Input/Output -------------
   input  CLK_IN;
   input  DCM_LOCKED;
   output DCM_RST;
   input  PLL_LOCKED;
   output PLL_RST;
   output WAIT;
   
   reg [19:0] dcmLocked_cnt;
   reg [19:0] pllLocked_cnt;
   reg        orRST_DCM;
   reg        orRST_PLL;
   reg        irDCMLocked;
   reg        irPLLLocked;
   reg        rstFlag_DCM;
   reg        rstFlag_PLL;
   initial begin
      dcmLocked_cnt <= 20'b0;
      pllLocked_cnt <= 20'b0;
      orRST_DCM     <= 1'b0;
      orRST_PLL     <= 1'b0;
      irDCMLocked   <= 1'b0;
      irPLLLocked   <= 1'b0;
      rstFlag_DCM   <= 1'b0;
      rstFlag_PLL   <= 1'b0;
   end // initial begin
   always @(posedge CLK_IN) begin
      irDCMLocked <= DCM_LOCKED;
      irPLLLocked <= PLL_LOCKED;
      //Checking unlocked clocks
      if(irDCMLocked==1'b1 && DCM_LOCKED==1'b0) rstFlag_DCM <= 1'b1;
      if(irPLLLocked==1'b1 && PLL_LOCKED==1'b0) rstFlag_PLL <= 1'b1;
      //Generating RST pulse for DCM
      if(rstFlag_DCM==1'b1) begin
	 dcmLocked_cnt <= dcmLocked_cnt+20'd1;
	 orRST_DCM <= (dcmLocked_cnt!=20'd0 && dcmLocked_cnt<20'd10) ? 1'b1 : 1'b0;
	 if(dcmLocked_cnt>20'd300000) begin //wait for 6 ms to lock clk.
	    dcmLocked_cnt <= 20'b0;
	    rstFlag_DCM <= 1'b0;
	 end
      end // if (rstFlag_DCM==1'b1)
      //Generating RST pulse for PLL
      if(rstFlag_PLL==1'b1) begin
	 pllLocked_cnt <= pllLocked_cnt+20'd1;
	 orRST_PLL <= (dcmLocked_cnt!=20'd0 && dcmLocked_cnt<20'd10) ? 1'b1 : 1'b0;
	 if(pllLocked_cnt>20'd300000) begin //wait for 6 ms to lock clk.
	    pllLocked_cnt <= 20'b0;
	    rstFlag_PLL <= 1'b0;
	 end
      end // if (rstFlag_PLL==1'b1)
   end // always @ (posedge CLK_IN)
   assign DCM_RST = orRST_DCM;
   assign PLL_RST = orRST_PLL;
   assign WAIT    = rstFlag_DCM || rstFlag_PLL;
endmodule