#pragma once

#include "svxconfig.h"

#include <string>
#include "vector"

#include "TFile.h"
#include "TTree.h"
#include "TH1F.h"
#include "TF1.h"
#include "TH2F.h"
#include "TF2.h"
#include "TProfile.h"
#include "TCanvas.h"
#include "TGraph.h"
#include "TGraphErrors.h"
#include "TStopwatch.h"
#include "TObject.h"
// end

#define TEST_END -1

namespace svx{

  class Analyze{
    
  public:
    Analyze(Test_Mode test_mode=Default); // constructor
    ~Analyze(); // deconstructor
      
    int analyze_data(const char *data);
    void Reset_hists();
    void write_rootfile();
  
    void get_config_param_ana(SVXconfig* config);
    void SetFileName(std::string name){filename = name;};

    int analyze_test_result(Run_Mode run_mode, int iteration,
			    std::vector <struct change_param> &change_params);
    void write_test_result();
    void show_message(int iteration);
    void init_conf_for_test(SVXconfig* config);
    int rewrite_config_file(SVXconfig* config);

    void HitPosition(const char *data,Int_t *hitx, Int_t *hity); // 20151110 Yamauchi added.
  
  private:
    int unpack_data(const char *data);

    int fill_adc_vs_ch(const int tele_i, int &most_hitch_F, int &most_hitch_R);
    int fill_timestamp();
    int fill_ev_valid(const int tele_i);

    void create_test_object(Test_Mode test_mode);
    void delete_test_object(Test_Mode test_mode);

    bool whether_rewritten(param_names param, Test_Mode test_mode);
  
    // Mask Scan
    int analyze_dead_ch(Run_Mode run_mode, int iteration,
			std::vector <struct change_param> &change_params);
    void write_mask_pattern(std::string filename);
    void set_mask_param(int tele_i,
			std::vector <struct change_param> &change_params);
    TH2C* mask_pattern[TELESCOPE_NUM];
    int dead_ch_num;
  
    // Gain Measurement
    int SetPoint_gain_curve(Run_Mode run_mode, int point_num);
    void write_gain_curve(std::string filename);
    TGraphErrors* gain_curve_Front[TELESCOPE_NUM][256];
    TGraphErrors* gain_curve_Rear[TELESCOPE_NUM][256];

    // Threshold Scan
    int analyze_threshold(Run_Mode run_mode, int iteration,
			  std::vector <struct change_param> &change_params);
    void write_threshold_data(std::string filename);
    TH1D* pedestal_mean_Front[TELESCOPE_NUM];
    TH1D* pedestal_mean_Rear[TELESCOPE_NUM];

    // Pickdel Scan
    int analyze_hitnum_vs_pickdel(Run_Mode run_mode, int point_num,
				  std::vector <struct change_param> &change_params);
    void write_pickdel_scan_result(std::string filename);
    TGraphErrors* hitnum_vs_pickdel;

    // Delay Scan
    int analyze_hitnum_vs_delay(Run_Mode run_mode, int point_num);
    void write_delay_scan_result(std::string filename);
    TGraphErrors* hitnum_vs_delay;

    Double_t test_value;
    
    int num_event;

    bool Mask_mode;
    bool masked_ch[TELESCOPE_NUM][512];
    bool prev_masked_ch[TELESCOPE_NUM][512];
    int mask_config[TELESCOPE_NUM][4][16];
    int disable_config[TELESCOPE_NUM][4];
    int chipID_config[TELESCOPE_NUM][4];
    int thresh_config[TELESCOPE_NUM][4];

    int ts_log;
  
    bool rest_data_exist;

    SVX_EF_HEADER ef_header_ana;
    SVX_EF *svx_ef_ana[TELESCOPE_NUM];
  
    TH1I* hist_time_stamp;
    TH1I* SVX4_TSvsEv;
    TH2I* hist_svx_Front[TELESCOPE_NUM];
    TH2I* hist_svx_Rear[TELESCOPE_NUM];
    TH2I* hitmap_svx[TELESCOPE_NUM];
    TH2I* hist_pipelineID_svx_Front[TELESCOPE_NUM];
    TH2I* hist_pipelineID_svx_Rear[TELESCOPE_NUM];
    TProfile* Meanch_svx_Front[TELESCOPE_NUM];
    TProfile* Meanch_svx_Rear[TELESCOPE_NUM];
    TH1I* event_valid[TELESCOPE_NUM];
    TH2I* correlation_svx_Front[TELESCOPE_NUM][4];
    TH2I* correlation_svx_Rear[TELESCOPE_NUM][4];
  
    std::string filename;
    Test_Mode m_test_mode;
  
  };

} // namespace svx
