#include "svxcommon.h"

#include <string>
#include "vector"

namespace svx{

  //////////////////////////////////////////////////////////
  // SVX common variables
  //
  std::vector<struct change_param> g_change_params;
  int g_num_event = 100;
  Run_Mode g_run_mode = DATA_ANA;
  Test_Mode g_test_mode = Default;

  int g_verbose_level = 1;
  std::string g_filename;


  //////////////////////////////////////////////////////////
  // SVX common methods
  //
  // Gray code decoder
  unsigned char gray_encoder(unsigned char binary){
    unsigned char tmp = 0;
    tmp |= binary;
    return tmp^(tmp >> 1);
  }


  unsigned char gray_decoder(unsigned char gray){
    unsigned char tmp = 0;
    tmp |= gray;
    while(gray){
      gray >>= 1;
      tmp ^= gray;
    }
    return tmp;
  }


  std::string uc2binary(const unsigned char cval){
    int digit = sizeof(unsigned char)*8;
    std::string str;
    
    for(int a=0; a<digit; a++){

      if(((cval>>(digit-a-1)) & 0x1) == 1)
	str += "1";
      else
	str += "0";
    }
  
    return str;
  }


  std::string inv_str(const char* cval){
    std::string str;

    int size = 0;
    while(cval[size])
      size++;
  
    for(int i=0; i<size; i++)
      str += cval[size-i-1];

    return str;
  }

} // namespace svx
