#include <sstream>
#include <iostream>
#include <fstream>
#include <iomanip>

#include <sys/time.h>


class Stopwatch {
  
 public:
  
  Stopwatch() {
    m_preset_time = 1.0; // default preset time : 1.0 sec.
    Start();
  }
  Stopwatch(double preset_time) {
    m_preset_time = preset_time;
    Start();
  }
  ~Stopwatch() {}
  
  void Start() {
    gettimeofday(&m_tv, &m_tz);
    m_start_time = (double)m_tv.tv_sec + (double)m_tv.tv_usec/1000000.;
  }
  double GetElapsedTime() {
    gettimeofday(&m_tv, &m_tz);
    return ((double)m_tv.tv_sec + (double)m_tv.tv_usec/1000000. - m_start_time);
  }
  void SetPresetTime(double preset_time) {
    m_preset_time = preset_time;
  }
  bool IsFired() {
    double current_elapsedtime = GetElapsedTime();
    if (current_elapsedtime > m_preset_time){
      Start();
      return true;
    }else
      return false;
  }
  
 private:
  struct timeval m_tv;
  struct timezone m_tz;
  double m_start_time;
  double m_preset_time;
};


class EventCounter{
  
public:
  
  EventCounter(int event_number, std::string header="") :
    m_interval(60.0/133.3), // BPM 133.3...
    m_timer(),
    m_header(header),
    m_event_number(event_number),
    m_event_counter(1)
  {}
  ~EventCounter(){};
  
  void Count(){
    
    if(	m_event_counter == m_event_number ||
	m_interval.IsFired() ){

      double time = m_timer.GetElapsedTime();
      double parcent = (m_event_counter * 100) / (double)m_event_number;
      
      if(m_header != "") std::cout << m_header << " : ";
      std::cout << std::setw(8) << m_event_counter << '/' << m_event_number << " [";
      for(int i=0; i<20; i++){
	if( i < (int)parcent/5 ) std::cout << '=';
	else                     std::cout << ' ';
      }
      std::cout << ']' << (int)parcent << "%  "
		<< "Elapsed/Remaining " << time << "sec./";
      if(m_event_counter == m_event_number)
	std::cout << "0sec.                                   " << std::endl;
      else
	std::cout << (time/parcent)*(100-parcent) << "sec.  \r" << std::flush;
    }

    m_event_counter++;
  }

  
private:
  
  Stopwatch m_interval;
  Stopwatch m_timer;
  std::string m_header;
  int m_event_number;
  int m_event_counter;
  
};
