#pragma once

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <sys/types.h>
#include <unistd.h>

#include "mytypeinfo.h"

#define _ERRORC(fmt, ...) err_msg(Demangle(typeid(*this)), __func__, "ERROR", fmt, __VA_ARGS__)
#define _WARNC(fmt, ...) err_msg(Demangle(typeid(*this)), __func__, "WARNING", fmt, __VA_ARGS__)
#define _INFOC(fmt, ...) info_msg(Demangle(typeid(*this)), __func__, "INFO", fmt, __VA_ARGS__)
#define _ERROR(fmt, ...) err_msg("TBD", __func__, "ERROR", fmt, ##__VA_ARGS__)
#define _WARN(fmt, ...) err_msg("TBD", __func__, "WARNING", fmt, ##__VA_ARGS__)
#define _INFO(fmt, ...) info_msg("TBD", __func__, "INFO", fmt, ##__VA_ARGS__)

void
err_msg(const char *classname, const char *funcname, const char *type, const char *fmt, ...);

void
info_msg(const char *classname, const char *funcname, const char *type, const char *fmt, ...);
