#pragma once

#include "svxcommon.h"
#include "comm.h"

namespace svx{

  struct param{
    unsigned char value[TELESCOPE_NUM][4];

    // propertys of parameter
    int min;
    int max;
    int digit;
    int position;
    bool direction;
    bool gray;
    int name_length;
  };


  class Conf_param{
  public:
    Conf_param();
    ~Conf_param(){};
    
    int min(param_names param_name){return conf_param[param_name].min;};
    int max(param_names param_name){return conf_param[param_name].max;};
    int digit(param_names param_name){return conf_param[param_name].digit;};
    int position(param_names param_name){return conf_param[param_name].position;};
    bool direction(param_names param_name){return conf_param[param_name].direction;};
    bool gray(param_names param_name){return conf_param[param_name].gray;};
    int name_length(param_names param_name){return conf_param[param_name].name_length;};
    
  protected:
    void set_value(param_names param_name, int tele_i, int chip_i, unsigned char val){
      conf_param[param_name].value[tele_i][chip_i] = val;};
    int get_value(param_names param_name, int tele_i, int chip_i){
      return conf_param[param_name].value[tele_i][chip_i];};

  private:
    struct param conf_param[PARAM_INDEX_END];
  
  };


  class SVXconfig : public Conf_param{
  public:
    SVXconfig();
    ~SVXconfig();
  
    //
    // configuration-related method
    //
    int load_config(const int tele_num);
    int send_config(Comm* comm, int tele_num);
    int rcv_conf_output(Comm* comm);
    int decode_conf_output(); // to move private futurely
    int decode_check_conf_output(std::string conflog_name);
    int send_config_to_svx(Comm* comm);
  
    int display(int tele_num, const int output = 0);
    unsigned char getparam(param_names param_name, const int tele_num,
			   const int chip_num, int output = 0);
    int writeparam(param_names param_name, const int tele_num,
		   const int chip_num, int val, int output = 1);
    int writeparam_allchips(param_names param_name, int val, int output = 1);
    void set_RdAll();
    void set_sparsification();
    void set_allMask(int val);
    void set_Qinj_taking();
    void set_pedestal_taking();
    
    
    //
    // control-related method
    //
    int load_ctrlsig();
    int send_ctrlsig(Comm* comm);

  private:
  
    int write_conf_output(std::string filenamem);
    int check_conf_output(int output = 0);
  
    int check_param(param_names param_name, int param_val);
    std::string str_prin[TELESCOPE_NUM];
    std::string str_feclk[TELESCOPE_NUM];

    std::string bin_odd[8];
    std::string bin_even[8];
    int ctrlsig_len;

    //
    // For confirmation of configuration
    //
    int msg_len;
    unsigned char conf_outdata[5000];
    std::string prout[TELESCOPE_NUM];
    std::string prin[TELESCOPE_NUM];

    //
    // Configuration Parameter Sent Flag
    //
    bool m_conf_sent[TELESCOPE_NUM];
    bool m_conf_sent_to_svx;
  
  };

} // namespace svx
