#include "SiTCP.h"
#include "unistd.h"


SiTCP::SiTCP(){
  std::cout << std::endl
	    << "SiTCP():SiTCP control -> Start" << std::endl
	    << std::endl;
};


SiTCP::~SiTCP(){};


bool SiTCP::SetIPPort(const char* IpAddr, unsigned int tcp, unsigned int udp){
  
  if(tcp <= 0 || tcp >= 65535){
    std::cout << "SiTCP::SetIPPort() : ERROR:invalid port number of TCP(" << tcp << ')'
	      << std::endl;
    exit(1);// return false;
  }
  
  if(udp <= 0 || udp >= 65535){
    std::cout << "ERROR : invalid port number of UDP(" << udp << ')' << std::endl;
    exit(1);// return false;
  }

  tcpPort = tcp;
  udpPort = udp;
  sitcpIpAddr = IpAddr;
  
  std::cout << "SiTCP:IP Address = " << sitcpIpAddr << std::endl
	    << "      TCP Port   = " << tcpPort << std::endl
	    << "      UDP Port   = " << udpPort << std::endl
	    << std::endl;
  
  return true;
}


bool SiTCP::CreateUDPSock(){
  std::cout << "Create socket for UDP connection.....";
  
  udpsock = socket(AF_INET, SOCK_DGRAM, 0);
  
  if(udpsock < 0){
    perror("SiTCP()::CreateUDPSock()");
    std::cout << "errno = " << errno << std::endl;
    exit(1); // return false;
  }
  
  memset(&udpAddr, 0, sizeof(udpAddr));
  udpAddr.sin_family      = AF_INET;
  udpAddr.sin_port        = htons(udpPort);
  udpAddr.sin_addr.s_addr = inet_addr(sitcpIpAddr);
  
  std::cout << "Done" << std::endl;
  
  return true;
}


bool SiTCP::CloseUDPSock(){
  std::cout << "Close UDP Socket.....";
  close(udpsock);
  std::cout << "Done" << std::endl;
  
  return true;
}


bool SiTCP::CreateTCPSock(){
  std::cout << "Create socket for TCP connection.....";
  
  tcpsock = socket(AF_INET, SOCK_STREAM, 0);
  
  if(tcpsock < 0){
    perror("SiTCP::CreateTCPSock()");
    std::cout << "errno = " << errno << std::endl;
    exit(1); // return false;
  }
  
  memset(&tcpAddr, 0, sizeof(tcpAddr));
  tcpAddr.sin_family      = AF_INET;
  tcpAddr.sin_port        = htons(tcpPort);
  tcpAddr.sin_addr.s_addr = inet_addr(sitcpIpAddr);
  std::cout << "Done" << std::endl;

  if(check_TCPconnection() != 0)
    return false;

  return true;
}


bool SiTCP::CloseTCPSock(){
  std::cout << "Close TCP Socket.....";
  close(tcpsock);
  std::cout << "Done" << std::endl;
  
  return true;
}


int SiTCP::check_TCPconnection(){
  std::cout << "  ->Trying to connect to " << sitcpIpAddr << " ..." << std::endl;
  if(connect(tcpsock, (struct sockaddr *)&tcpAddr, sizeof(tcpAddr)) < 0){
    
    if(errno != EINPROGRESS)
      perror("SiTCP::check_TCPconnection()");
    
    FD_ZERO(&rmask);
    FD_SET(tcpsock, &rmask);
    wmask = rmask;

    timeout.tv_sec = 1;
    timeout.tv_usec = 0;
    int select_re = select(tcpsock+1, &rmask, NULL, NULL, &timeout);
    if(select_re < 0)
      perror("SiTCP::check_TCPconnection()");
    
    if(select_re == 0){
      std::cout << "ERROR:TCP connection Time out!!!" << std::endl;
      return 1;
    }else{
      std::cout << "ERROR:TCP connection has error!!!" << std::endl;
      return 1;
    }
  }
  
  FD_ZERO(&readfds);
  FD_SET(tcpsock, &readfds);
  FD_SET(0, &readfds);
 
  std::cout << "  ->Connect success!" << std::endl
	    << std::endl;
  
  return 0;
}


// set header for RBCP Packet
void SiTCP::set_RBCPHeader(unsigned char type, unsigned char command,
			   unsigned char id, unsigned char length,
			   unsigned int address){
  snd_RBCP_Header.type=type;
  snd_RBCP_Header.command=command;
  snd_RBCP_Header.id=id;
  snd_RBCP_Header.length=length;
  snd_RBCP_Header.address=htonl(address);
  memcpy(sndBuf, &snd_RBCP_Header, sizeof(snd_RBCP_Header));
}


int SiTCP::set_RBCPData(unsigned char data){
  sndData[0] = data;
  for(int i=1; i<256; i++)
    sndData[i] = 0;
  
  memcpy(sndBuf+sizeof(Get_RBCP_Header()), sndData, sizeof(sndData));

  return 1;
}


int SiTCP::set_RBCPData(unsigned char* data, int datasize){
  
  if(datasize > 255 || datasize <= 0)
    std::cout << "SiTCP::set_RBCPData() :"
	      << "WARNING:Data size is more than 255byte or negative("
	      << datasize << ')' << std::endl;
  
  for(int i=0; i<255; i++){
    if(i < datasize)
      sndData[i] = data[i];
    else
      sndData[i] = 0x00;
  }
  
  memcpy(sndBuf+sizeof(Get_RBCP_Header()), sndData, sizeof(sndData));

  return datasize;
}
