#include "svxconfig.h"

#include <iostream>
#include <fstream>
#include <string>

#include "unistd.h"
#include "stdio.h"
#include "stdlib.h"

namespace svx{

  // Constructor
  SVXconfig::SVXconfig(){
    for(int i=0; i<TELESCOPE_NUM; i++) m_conf_sent[i] = false;
    m_conf_sent_to_svx = false;
  }

  // Deconstructor
  SVXconfig::~SVXconfig(){}

  int SVXconfig::load_config(const int tele_num){

    for(int i=0; i<TELESCOPE_NUM; i++) m_conf_sent[i] = false;
    m_conf_sent_to_svx = false;
  
    std::string conf_file;
    std::string tmpStr;

#ifdef SCTJDAQ_COMPILE
    conf_file = "/home/sctjdaq/src/telescope/text/";
#else
    conf_file = "../text/";
#endif

    char filename[20];
    sprintf(filename, "config_tele%d.dat", tele_num+1);
    conf_file += filename;
  
    std::ifstream inf(conf_file.c_str());
    if(!inf)
      std::cout << "File can't be opened!!" << std::endl;
    std::cout << "Now loding configuration file"
	      << conf_file << "..." << std::endl;

    int chip_num = 0;
    int tmp_val = -1;
    // To confirm that all parameters has been loaded
    bool conf_loaded[4][PARAM_INDEX_END] = {{false}};
  
    while(inf >> tmpStr){
      if(tmpStr=="header_1"){
	inf >> tmpStr;
	str_prin[tele_num] += "10101010"; // 170
	str_feclk[tele_num] += "11111111";
      }else if(tmpStr=="header_2"){
	inf >> tmpStr;
	str_prin[tele_num] += "01010101"; // 85
	str_feclk[tele_num] += "11111111";
      }else if(tmpStr=="#chip_no."){
	inf >> tmpStr;
	str_prin[tele_num] += "00000000";
	str_feclk[tele_num] += "00000000";
	chip_num = atoi(tmpStr.c_str()) - (tele_num*4) - 1;
      }else{
	if(tmpStr.find_first_of('[') != std::string::npos)
	  tmpStr.erase(tmpStr.find_first_of('[')); // To trim the end of tmpStr
	
	tmpStr += " ";
	for(int i=0; i<PARAM_INDEX_END; i++){
	  if(strncmp(Strparam_names((param_names)i).c_str(),
		     tmpStr.c_str(),
		     Strparam_names((param_names)i).find_first_of(" ") + 1) == 0){
	    // tmpStr.c_str(), name_length((param_names)i) + 1) == 0){
	    inf >> tmpStr;
	    str_prin[tele_num] += tmpStr;
	    conf_loaded[chip_num][i] = true;
	    for(int j=0; j<digit((param_names)i); j++)
	      str_feclk[tele_num] += '1';
	  
	    if(direction((param_names)i))
	      tmp_val = binary(tmpStr.c_str());
	    else
	      tmp_val = binary(inv_str(tmpStr.c_str()).c_str());

	    if(gray((param_names)i))
	      tmp_val = gray_decoder((unsigned char)tmp_val);

	    if(ID == (param_names)i)
	      tmp_val += 128;
	    
	    if(check_param((param_names)i, tmp_val) == 0)
	      set_value((param_names)i, tele_num, chip_num, (unsigned char)tmp_val);
	    else
	      exit(-2);
	  }
	}
      }
    }
  
    inf.close();

    // confirmation
    for(int chip_i=0; chip_i<4; chip_i++){
      for(int j=0; j<PARAM_INDEX_END; j++){
	if(!conf_loaded[chip_i][j]){
	  std::cout << "Failed to Load Configuration parameter!!("
		    << Strparam_names((param_names)j) << ")" << std::endl;
	  exit(-1);
	}
      }
    }

    int prin_len = 0;
    int feclk_len = 0;
  
    prin_len = str_prin[tele_num].size(); // display(tele_num);
    feclk_len = str_feclk[tele_num].size(); // display(tele_num, 1);

    std::cout << "PRin length  = " << prin_len << std::endl;
    std::cout << "FECLK length = " << feclk_len << std::endl;

    if(prin_len != feclk_len){
      perror("different length : prin & feclk");
      exit(-1);
    }
  
    std::cout << "Configuration parameter is loaded." << std::endl
	      << std::endl;
    return 0;
  }


  int SVXconfig::send_config(Comm* comm, int tele_num){
  
    // Encoding...
    std::cout<<"Encoding configration parameter..."<<std::endl;

    std::string prin;
    std::string feclk;

    for(int j=0; j<10; j++){
      prin+="00000000";
      feclk+="00000000";
    }

    for(int i=0; str_feclk[tele_num][i]; i++){
      if(str_prin[tele_num][i]=='1'){
	prin+="11111";
      }else if(str_prin[tele_num][i]=='0'){
	prin+="00000";
      }
    
      if(str_feclk[tele_num][i]=='1'){
	feclk+="00100";
      }else if(str_feclk[tele_num][i]=='0'){
	feclk+="00000";
      }
    }

    for(int j=0; j<10; j++){
      prin+="00000000";
      feclk+="00000000";
    }
  
    if(prin.size() != feclk.size()){
      perror("fault!");
      exit(-1);
    }

    std::string byteprin;
    std::string bytefeclk;

    unsigned char SndConfig[2000];
    int totlen = 0;
  
    while(prin[totlen*8]){
      // initialize
      byteprin = "";
      bytefeclk = "";

      byteprin = prin.substr(8*totlen,8);
      bytefeclk = feclk.substr(8*totlen,8);

      SndConfig[2*totlen] = (unsigned char)binary(byteprin.c_str());
      SndConfig[2*totlen+1] = (unsigned char)binary(bytefeclk.c_str());

      ++totlen;
    }

    std::cout<<"Total Data Length = " << totlen*2 << " byte." << std::endl;
    std::cout<<"Configration parameter is encoded."<<std::endl;

    // Sending...
    std::cout<<"Send SVX4chip configuration parameter."<<std::endl;

    int addr_offset = 0x100000; // reserved space
    if(tele_num == 0)
      addr_offset = 0x1000;
    else if(tele_num == 1)
      addr_offset = 0x2000;
    else if(tele_num == 2)
      addr_offset = 0x4000;
    else if(tele_num == 3)
      addr_offset = 0x8000;
  
    comm->RBCP_multi_packet_send(0x0001 + addr_offset, totlen*2, SndConfig);
    usleep(1000);
  
    // end RBCP packet sending: trailer send
    comm->udp_send(totlen*2+1 + addr_offset, 0xcc);
    usleep(1000);

    std::cout<<"Finish sending SVX4chip configuration parameter!"<<std::endl;
    m_conf_sent[tele_num] = true;

    return 0;
  }


  int SVXconfig::rcv_conf_output(Comm* comm){

    usleep(50000); // Waiting for finishing writing FIFO
  
    int select_re;
    select_re = comm->read_tcp_data(msg_len, conf_outdata, 5000);
#ifdef SCTJDAQ_COMPILE
    write_conf_output("/home/sctjdaq/data/data_conf/conf_log.dat");
#else
    write_conf_output("data_conf/conf_log.dat");
#endif

    return msg_len;
  }


  int SVXconfig::write_conf_output(std::string filename){
    std::ofstream outf(filename.c_str(), std::ios::trunc);
    if(!outf){
      std::cout << "Error! Failed to Open File. ("
		<< filename <<')' << std::endl;
      return -1;
    }

    for(int i=0; i<msg_len; i++)
      outf << i << '\t' << uc2binary(conf_outdata[i]) << std::endl;
  
    outf.close();

    return 0;
  }


  int SVXconfig::decode_conf_output(){

    std::string tmp_data[5] = {"0"};
    for(int i=0; i<TELESCOPE_NUM; i++){
      prin[i].erase();
      prout[i].erase();
    }
  
    for(int k=0; k<msg_len; k++){

      int lag_feclk_prout = 2;
      for(int i=0; i<4; i++)
	tmp_data[4-i] = tmp_data[4-i-1]; // To fix lag between feclk & prout
      tmp_data[0] = uc2binary(conf_outdata[k]);

      for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
	if(tmp_data[0][7 - tele_i*2 - 1] == '1'){
	  prout[tele_i] += tmp_data[lag_feclk_prout][7 - tele_i*2];
	}
      }
    }
  
    for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
      int index = 0;
      while(str_prin[tele_i][index]){
	if(str_feclk[tele_i][index] == '1')
	  prin[tele_i] += str_prin[tele_i][index];
      
	index++;
      }
    }

    return 0;
  }


  int SVXconfig::decode_check_conf_output(std::string conflog_name){

    std::string tmp_byte;
    std::string tmp_data[5] = {"0"};
    for(int i=0; i<TELESCOPE_NUM; i++){
      prin[i].erase();
      prout[i].erase();
    }
  
    std::ifstream inf(conflog_name.c_str());
    if(!inf){
      std::cout << "Error! Failed to Open File. ("
		<< conflog_name <<')' << std::endl;
      return -1;
    }

    while(!inf.eof()){
      int lag_feclk_prout = 2;
      for(int i=0; i<4; i++)
	tmp_data[4-i] = tmp_data[4-i-1]; // To fix lag between feclk & prout
      inf >> tmp_byte >> tmp_data[0];

      for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
	if(tmp_data[0][7 - tele_i*2 - 1] == '1'){
	  prout[tele_i] += tmp_data[lag_feclk_prout][7 - tele_i*2];
	}
      }
    }
  
    inf.close();
  
    for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
      int index = 0;
      while(str_prin[tele_i][index]){
	if(str_feclk[tele_i][index] == '1')
	  prin[tele_i] += str_prin[tele_i][index];
      
	index++;
      }
    }

    int re = check_conf_output(2);
    return re;
  }


  int SVXconfig::check_conf_output(int output){
  
    // To confirm PRout corresponding PRin
    int re = 0;
    int comp_re = 1;
    for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
      comp_re = prout[tele_i].compare(0, 192*4, prin[tele_i], 16, 192*4);
    
      if(comp_re == 0){
	std::cout << "Successed to configure Tele #" << tele_i << " !!" << std::endl;
      }else{
	re = -1;
	std::cout << "ERROR:Failed to config Tele #" << tele_i << " !!" << std::endl;
	if(output == 2){
	  std::cout << " " << prout[tele_i].c_str() << std::endl
		    << " " << prin[tele_i].c_str() + 16 << std::endl << std::endl;
	}
      }
    }
  
#ifdef SCTJDAQ_COMPILE
    if(re == -1 && output > 0)
      write_conf_output("/home/sctjdaq/data/data_conf/conf_errlog.dat");
#else
    if(re == -1 && output > 0)
      write_conf_output("data_conf/conf_errlog.dat");
#endif
  
    return re;
  }


  int SVXconfig::send_config_to_svx(Comm* comm){
    for(int i=0; i<TELESCOPE_NUM; i++){
      if(!m_conf_sent[i]){
	std::cout << "ERROR : #" << i << " Telescope's "
		  << "conf parameters hasn't been sent to FPGA!" <<  std::endl;
	exit(-1);
      }
    }
    
    comm->udp_send(COMMAND, COM_CONFIGURE); //start send conf to SVX
    rcv_conf_output(comm);
      
    int check_conf_re = 0;
    decode_conf_output();
    check_conf_re = check_conf_output(1);

    m_conf_sent_to_svx = true;

    return check_conf_re;
  }


  int SVXconfig::display(int tele_num, const int output){
    int param_len = 0;

    if(output == 0){

      while(str_prin[tele_num][param_len]){
	std::cout << str_prin[tele_num][param_len];
	if(param_len%8 == 7){
	  printf(" %-5d", param_len+1);
	  if(param_len%64 == 63)
	    std::cout << std::endl;
	}
	++param_len;
      }
      std::cout << std::endl;
    
    }else{
    
      while(str_feclk[tele_num][param_len]){
	std::cout << str_feclk[tele_num][param_len];
	if(param_len%8 == 7){
	  printf(" %-5d", param_len+1);
	  if(param_len%64 == 63)
	    std::cout<<std::endl;
	}
	++param_len;
      }
      std::cout << std::endl;
    
    }

    return param_len;
  }


  unsigned char SVXconfig::getparam(param_names param_name, const int tele_num, const int chip_num, int output){
  
    unsigned char return_param = 0;
  
    if(param_name >= 0 && param_name < PARAM_INDEX_END){
      return_param = get_value(param_name, tele_num, chip_num);
    }else{
      std::cout << "Invalid argument param_name." << std::endl;
      return 0;
    }

    char param_c[10] = "";
  
    if(param_name >= 0 && param_name < 16)
      sprintf(param_c, "%s", uc2binary(return_param).c_str()); // Mask parameters
    else
      sprintf(param_c, "%d", (int)return_param); // Other parameters

    if(output == 3)
      std::cout << '#' << tele_num << " Telescope's chip" << chip_num << " : "
		<< Strparam_names(param_name) << "== "
		<< param_c << std::endl;
    else if(output == 2)
      std::cout << Strparam_names(param_name) << "== "
		<< param_c << std::endl;
    else if(output == 1)
      std::cout << param_c << " ";
    
    return return_param;
  }


  int SVXconfig::writeparam(param_names param_name, const int tele_num, const int chip_num, int val, int output){

    m_conf_sent[tele_num] = false;
    
    std::string tmp_str;

    if(check_param(param_name, val) != 0)
      return val;

    unsigned char uc_val = (unsigned char)val;

    if(param_name >= 0 && param_name < PARAM_INDEX_END){
    
      if(gray(param_name))
	tmp_str = uc2binary(gray_encoder(uc_val));
      else
	tmp_str = uc2binary(uc_val);

      if(direction(param_name)){
	str_prin[tele_num].replace((3 - chip_num)*200 + position(param_name) + 24,
				   digit(param_name), tmp_str, 8 - digit(param_name),
				   digit(param_name));
      }else{
	tmp_str = inv_str(tmp_str.c_str());
	str_prin[tele_num].replace((3 - chip_num)*200 + position(param_name) + 24,
				   digit(param_name), tmp_str, 0, digit(param_name));
      }
    
      set_value(param_name, tele_num, chip_num, uc_val);
    }else{
      std::cout << "Invalid argument or this parameter is not allowed to write." << std::endl;
      return -1;
    }

    char param_c[10] = "";
    if(param_name >= 0 && param_name < 16)
      sprintf(param_c, "%s", uc2binary(uc_val).c_str()); // Mask parameters
    else
      sprintf(param_c, "%d", (int)uc_val); // Other parameters

    if(output > 0){
      std::cout << "Changed #" << tele_num << " Telescope's chip" << chip_num << " : "
		<< Strparam_names(param_name) << "into "
		<< param_c << std::endl;
    }

    return 0;
  }


  int SVXconfig::writeparam_allchips(param_names param_name, int val, int output){
    int re = 0;
  
    for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
      for(int chip_i=0; chip_i<4; chip_i++){
	re = writeparam(param_name, tele_i, chip_i, val, 0);
	if(re != 0) return re;
      }
    }
  
    char param_c[10] = "";
    if(param_name >= 0 && param_name < 16)
      sprintf(param_c, "%s", uc2binary((unsigned char)val).c_str()); // Mask parameters
    else
      sprintf(param_c, "%d", val); // Other parameters

    if(output > 0){
      std::cout << "Changed all tele's all chip  : "
		<< Strparam_names(param_name) << "into "
		<< param_c << std::endl;
    }

    return 0;
  }


  void SVXconfig::set_RdAll(){
    writeparam_allchips(Rd127, 0);
    writeparam_allchips(Rd63, 0);
    writeparam_allchips(RdAll, 1);
    writeparam_allchips(RdNeigh, 0);
  }


  void SVXconfig::set_sparsification(){
    writeparam_allchips(Rd127, 1);
    writeparam_allchips(Rd63, 1);
    writeparam_allchips(RdAll, 0);
    writeparam_allchips(RdNeigh, 1);
  }


  void SVXconfig::set_allMask(int val){
    for(int param=0; param<16; param++)
      writeparam_allchips((param_names)param, val); // Mask_n
  
  }


  void SVXconfig::set_Qinj_taking(){
    writeparam_allchips(VCAL, 0);
    writeparam_allchips(Disable, 0);
    writeparam_allchips(PickDel, 2/*chrage injected cell*/);
    set_allMask(60);
    // writeparam_allchips(Mask_9, 255);
    writeparam_allchips(Thresh, 1);
    writeparam_allchips(CntrMod, 255);
  }


  void SVXconfig::set_pedestal_taking(){
    writeparam_allchips(VCAL, 0);
    writeparam_allchips(Disable, 1);
    writeparam_allchips(PickDel, 15/*Not chrage injected cell*/);
    writeparam_allchips(Thresh, 1);
    writeparam_allchips(CntrMod, 255);
  }


  int SVXconfig::check_param(param_names param_name, int param_val){

    bool invalid_val = false;

    if(param_name >= 0 && param_name < PARAM_INDEX_END){
      if(param_val < min(param_name) || param_val > max(param_name))
	invalid_val = true;
    }else{
      std::cout << "Invalid parameter name." << std::endl;
      return -1;
    }

    if(invalid_val == true){
      std::cout << Strparam_names(param_name)
		<< " has invalid value." << '(' << param_val << ')' << std::endl;
      return param_val;
    }

    return 0;
  }


  int SVXconfig::load_ctrlsig(){

    /* ----------load 8 line control signals to member variable----------- */

#ifdef SCTJDAQ_COMPILE
    std::ifstream inf("/home/sctjdaq/src/telescope/text/svx4_diagram.dat");
#else
    std::ifstream inf("../text/svx4_diagram.dat");
#endif
    
    std::string tmpStr;
    std::string s_temp;

    std::string txt_odd[8];
    std::string txt_even[8];

    std::cout << "load_ctrlsig():"
	      << "Start to conversion from SVX4 diagram to binary data." << std::endl
	      << std::endl;

    while(inf >> tmpStr){
      if(tmpStr=="CHMODE.......:"){
	inf >> s_temp;
	txt_odd[0] = s_temp;
      }else if(tmpStr=="FEMODE.......:"){
	inf >> s_temp;
	txt_odd[1] = s_temp;
      }else if(tmpStr=="BEMODE.......:"){
	inf >> s_temp;
	txt_odd[2] = s_temp;
      }else if(tmpStr=="PRin.........:"){
	inf >> s_temp;
	txt_odd[3] = s_temp;
      }else if(tmpStr=="CLK_sel......:"){
	inf >> s_temp;
	txt_odd[4] = s_temp;
      }else if(tmpStr=="FECLK........:"){
	inf >> s_temp;
	txt_odd[5] = s_temp;
      }else if(tmpStr=="BECLK........:"){
	inf >> s_temp;
	txt_odd[6] = s_temp;
      }else if(tmpStr=="OBDV.........:"){
	inf >> s_temp;
	txt_odd[7] = s_temp;
      }else if(tmpStr=="BUS0/Comp_rst:"){
	inf >> s_temp;
	txt_even[0] = s_temp;
      }else if(tmpStr=="BUS1/Ramp_rst:"){
	inf >> s_temp;
	txt_even[1] = s_temp;
      }else if(tmpStr=="BUS2/PR2.....:"){
	inf >> s_temp;
	txt_even[2] = s_temp;
      }else if(tmpStr=="BUS3/Rref_sel:"){
	inf >> s_temp;
	txt_even[3] = s_temp;
      }else if(tmpStr=="BUS4/PARST...:"){
	inf >> s_temp;
	txt_even[4] = s_temp;
      }else if(tmpStr=="BUS5/L1A.....:"){
	inf >> s_temp;
	txt_even[5] = s_temp;
      }else if(tmpStr=="BUS6/PR1.....:"){
	inf >> s_temp;
	txt_even[6] = s_temp;
      }else if(tmpStr=="BUS7/CALSR...:"){
	inf >> s_temp;
	txt_even[7] = s_temp;
      }
    }

    inf.close();

    int odd_depth = -1;
    int even_depth = -1;

    // "_X_X_X___X" -> "0101010001"
    for(int ctrl_ch_odd=0; ctrl_ch_odd<8; ++ctrl_ch_odd){
    
      unsigned int odd_addr = 0;
      while(txt_odd[ctrl_ch_odd][odd_addr]){
	if(txt_odd[ctrl_ch_odd][odd_addr]=='_'){
	  bin_odd[ctrl_ch_odd] += '0';
	}else if(txt_odd[ctrl_ch_odd][odd_addr]=='X'){
	  bin_odd[ctrl_ch_odd] += '1';
	}
	++odd_addr;
      }
    
      // std::cout << bin_odd[ctrl_ch_odd] << std::endl;
      if(odd_depth == -1)
	odd_depth = odd_addr;
      else{
	if(odd_depth != (int)odd_addr){
	  std::cout << "load_ctrlsig() : ERROR:Diagram has WRONG description "
		    << "{CtrlRAM(Odd) : (" << ctrl_ch_odd << ")}" << std::endl;
	  exit(1);
	}
      }
    
    }

    std::cout << "ctrl memory(odd) depth == " << odd_depth << std::endl;

    for(int ctrl_ch_even=0; ctrl_ch_even<8; ++ctrl_ch_even){
    
      unsigned int even_addr = 0;
      while(txt_even[ctrl_ch_even][even_addr]){
	if(txt_even[ctrl_ch_even][even_addr]=='_'){
	  bin_even[ctrl_ch_even] += '0';
	}else if(txt_even[ctrl_ch_even][even_addr]=='X'){
	  bin_even[ctrl_ch_even] += '1';
	}
	++even_addr;
      }
    
      // std::cout << bin_even[ctrl_ch_even] << std::endl;
      if(even_depth == -1)
	even_depth = even_addr;
      else{
	if(even_depth != (int)even_addr){
	  std::cout << "load_ctrlsig() : ERROR:Diagram has WRONG description "
		    << "{CtrlRAM(Even) : (" << ctrl_ch_even << ")}" << std::endl;
	  exit(1);
	}
      }
    
    }

    std::cout << "ctrl memory(even) depth = " << even_depth << std::endl;

    if(odd_depth != even_depth){
      std::cout << "load_ctrlsig() : ERROR:Diagram has WRONG description" << std::endl; 
      exit(1);
    }else
      ctrlsig_len = odd_depth;

    std::cout << "Total Signal Length = " << ctrlsig_len << std::endl;
  
    std::cout << std::endl
	      << "load_ctrlsig():"
	      << "Finish to conversion from SVX4 diagram to binary data." << std::endl
	      << std::endl;

    return 0;
  }


  int SVXconfig::send_ctrlsig(Comm* comm){
  
    unsigned char send_data[20000];
  
    for(int addr=0; addr<ctrlsig_len-1; addr++){
    
      char ctrl_odd[9] = "";
      char ctrl_even[9] = "";
    
      for(int width=0; width<8; ++width){
	std::strncat(ctrl_odd, (bin_odd[width].c_str()) + addr, 1);
	std::strncat(ctrl_even, (bin_even[width].c_str()) + addr + 1, 1);
      }
    
      // std::cout << addr << " " << ctrl_odd << " " << ctrl_even << std::endl;
    
      send_data[(2*addr)] = (unsigned char)binary(ctrl_even);
      send_data[(2*addr)+1] = (unsigned char)binary(ctrl_odd);
    }

    int addr_offset = 0x10000;
  
    comm->RBCP_multi_packet_send(0x00 + addr_offset, ctrlsig_len*2, send_data);
    comm->udp_send((ctrlsig_len-2)*2 + addr_offset, 0xff);// Address = signal depth
    comm->udp_send((ctrlsig_len-2)*2 + 1 + addr_offset, 0xff);// Address = signal depth

    return 0;
  }


  Conf_param::Conf_param(){
    struct param init_param[40]
      // val, min, max, digit, pos, dir, gray, name_len
      = {{{{0}},   0, 255, 8,  8*0,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*1,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*2,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*3,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*4,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*5,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*6,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*7,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*8,  true, false, 6},
	 {{{0}},   0, 255, 8,  8*9,  true, false, 6},
	 {{{0}},   0, 255, 8, 8*10,  true, false, 7},
	 {{{0}},   0, 255, 8, 8*11,  true, false, 7},
	 {{{0}},   0, 255, 8, 8*12,  true, false, 7},
	 {{{0}},   0, 255, 8, 8*13,  true, false, 7},
	 {{{0}},   0, 255, 8, 8*14,  true, false, 7},
	 {{{0}},   0, 255, 8, 8*15,  true, false, 7},
	 {{{0}},   0,   1, 1,  128,  true, false, 5}, // spare
	 {{{0}},   0,   1, 1,  129,  true, false, 4}, // VCAL
	 {{{0}},   0,   1, 1,  130,  true, false, 7}, // Disable
	 {{{0}},   0,  15, 4,  131, false, false, 2}, // BW
	 {{{0}},   0,  15, 4,  135, false, false, 4}, // Isel
	 {{{0}},   0,   3, 2,  139, false, false, 5}, // IWsel
	 {{{0}},   0,   3, 2,  141, false, false, 5}, // IRsel
	 {{{0}},   0,  42, 6,  143, false, false, 7}, // PickDel
	 {{{0}},   0,   1, 1,  149,  true, false, 2}, // PB
	 {{{0}}, 128, 255, 7,  150,  true, false, 2}, // ID
	 {{{0}},   0,   1, 1,  157,  true, false, 4}, // RTPS
	 {{{0}},   0,   1, 1,  158,  true, false, 5}, // Rd127
	 {{{0}},   0,   1, 1,  159,  true, false, 4}, // Rd63
	 {{{0}},   0,   1, 1,  160,  true, false, 5}, // RdAll
	 {{{0}},   0,   1, 1,  161,  true, false, 7}, // RdNeigh
	 {{{0}},   0,  16, 4,  162, false, false, 7}, // RampPed
	 {{{0}},   0,   1, 1,  166,  true, false, 7}, // RampDir
	 {{{0}},   0,   1, 1,  167,  true, false, 7}, // CompPol
	 {{{0}},   0,   7, 3,  168, false, false, 7}, // RampRng
	 {{{0}},   0, 255, 8,  171,  true,  true, 6}, // Thresh
	 {{{0}},   0, 255, 8,  179,  true,  true, 7}, // CntrMod
	 {{{0}},   0,   1, 1,  187,  true, false, 2}, // FC
	 {{{0}},   0,   1, 1,  188,  true, false, 2}, // LC
	 {{{0}},   0,   7, 3,  189,  true, false, 7}}; // DriverI

    for(int i=0; i<40; i++)
      conf_param[i] = init_param[i];

  }

} // namespace svx
