#pragma once

#include "svxconfig.h"

#include <string>
#include "vector"

namespace svx{

  void PrintCurrentTime();
  int getOptions(int argc, char *argv[]);
  void show_options();
  void show_help();

  void modify_conf_param(SVXconfig* config, std::vector<struct change_param> &change_params);

  void confirm_connection(const char* IpAddr, unsigned int tcp, unsigned int udp);
  void show_firmware_info(Comm* comm);
  
  void Load_all_configurations(SVXconfig* config);
  void SetParstVetoParam(Comm* comm, unsigned char pickdel, unsigned char latency, unsigned char width, bool scanmode=false);
  void SetUseTele(Comm* comm, int tele_num);

  std::string get_rawfile_name(Test_Mode test_mode, int iteration);
  std::string get_rootfile_name(Test_Mode test_mode, int iteration);
  std::string get_treefile_name(Test_Mode test_mode, int iteration);

} // namespace svx
