#include "comm.h"

#include "unistd.h"


Comm::Comm(){};


Comm::~Comm(){};


// Send 1 data & address by UDP
// data: send only 1byte data length
int Comm::udp_send(unsigned int address, unsigned char data){
  
  set_RBCPData(data);
  set_RBCPHeader(0xff, 0x80, address, 0x01, address);
  
  int len = sendto(GetUDPSock(), sndBuf, 1 + sizeof(Get_RBCP_Header()), 0,
		   (struct sockaddr *)&udpAddr, sizeof(udpAddr));//important!
  if(len < 0){
    perror("Comm::udp_send()");
    exit(1);
  }
  
  rcvRBCP_ACK(0);
  return 0;
}


// Send 1 packet data & address by UDP
int Comm::RBCPpacket_send(unsigned int address,
			  int length, unsigned char* data){

  set_RBCPData(data, length);
  set_RBCPHeader(0xff, 0x80, address, (unsigned char)length, address);

  int len = sendto(GetUDPSock(), sndBuf,
		   length + sizeof(Get_RBCP_Header()), 0,
		   (struct sockaddr *)&udpAddr, sizeof(udpAddr));//important!
  if(len < 0){
    perror("Comm::RBCPpacket_send()");
    exit(1);
  }

  rcvRBCP_ACK(0);

  return 0;
}


/*=============== multi packet sending method ===============*/
int Comm::RBCP_multi_packet_send(unsigned int address,
				  int total_length, unsigned char* data){

  int num_packet = (total_length/255) + 1;

  std::cout << std::endl
	    << "========== RBCP packet sending Start ==========" << std::endl;

  for(int packetNo = 0; packetNo < num_packet; ++packetNo){
    if(packetNo < num_packet-1)
      RBCPpacket_send(address+(packetNo*255), 255, data + packetNo*255);
    else
      RBCPpacket_send(address+(packetNo*255),
		      total_length%255, data + packetNo*255);

    std::cout << '.';
    fflush(stdout);
  }

  std::cout << "All packet has sended!!!" << std::endl
	    << "Number of sent packets = " << num_packet << std::endl
	    << std::endl;

  return 0;
}


// Is it needed?
void Comm::clear_all(){
  unsigned char address = 0x00;
  unsigned char data = 0x0;
  
  // Send register clear
  udp_send(address, data);
  udp_send(0x10a, 0x0);
  usleep(5000);

  std::cout << "Clear All Register in FPGA." << std::endl;
}


int Comm::read_udp_data(unsigned int address, unsigned char* data,
			int array_size, int length, int output){
  
  int num_packet = (length/255) + 1;
  if(array_size < num_packet*255){
    std::cout << "read_udp_data() : ERROR:Size of array \"data\" is too small!" << std::endl;
    return -1;
  }

  for(int packetNo = 0; packetNo < num_packet; ++packetNo){
    // Send Request for read through UDP connection
    unsigned int packet_addr = address + packetNo*255;
    
    if(packetNo < num_packet-1)
      set_RBCPHeader(0xff, 0xc0, packet_addr, 255, packet_addr);
    else
      set_RBCPHeader(0xff, 0xc0, packet_addr, length%255, packet_addr);
    
    int len = sendto(GetUDPSock(), sndBuf, sizeof(Get_RBCP_Header()), 0,
		     (struct sockaddr *)&udpAddr, sizeof(udpAddr));//important!
    if(len < 0){
      perror("Failed to Send RBCP Packet");
      exit(1);
    }
  
    // Receive RBCP packet
    int msg_len = -1;
    unsigned char rcvdData[255+8];
    msg_len = recv_RBCPpacket(255+8, rcvdData);
    memcpy(data + packetNo*255, rcvdData + 8, 255); // Be attention!! size of "data"

    if(output == 1){
      std::cout << "Received data:" << std::endl;
      for(int i=0; i<msg_len; i++){
	if(i%4 == 0)
	  printf("\t[%.3x]:%.2x ",i,rcvdData[i]);
	else if(i%4 == 3)
	  printf("%.2x\n",rcvdData[i]);
	else
	  printf("%.2x ",rcvdData[i]);
      }
      std::cout << std::endl;
    }
  }
  
  return 0;
}


int Comm::read_tcp_data(int &msg_len, unsigned char* data, int max_length){
  
  fd_set fdset;
  int select_re = -1;
  
  FD_ZERO(&fdset);
  FD_SET(GetTCPSock(), &fdset);
  
  int cnt = 0;

  while(true){
    timeout.tv_sec = 0;
    timeout.tv_usec = 500000;
    select_re = select(GetTCPSock()+1, &fdset, NULL, NULL, &timeout);

    if(select_re == 1){
      // int status = ioctl(GetTCPSock(),FIONREAD,&msg_len); // environment dependence
      // data = (unsigned char*)calloc(msg_len, sizeof(char));
      break;
    }else if(select_re == 0){
      if(cnt < 3){
	// std::cout << "read_tcp_data():Waiting for Data....."<< std::endl
	std::cout << '.';    fflush(stdout);;
	cnt++;
      }else{
	std::cout << "read_tcp_data():No Data!"<< std::endl;
	throw -1;// return select_re;
      }
    }else if(select_re < 0){
      std::cout << std::endl
		<< "Comm::read_tcp_data() : ERROR:UDP connection has error." << std::endl;
      throw (char*)"UDP Connection ERROR";// return select_re;
    }
  }
  
  // std::cout << "Reading Data from TCP..." << std::endl;
  if(data == NULL){
    unsigned char* dump = (unsigned char*)malloc(max_length);
    recv(GetTCPSock(), dump, sizeof(char)*max_length, 0); //read data from kernel buffer
    free(dump);
  }else{
    msg_len = recv(GetTCPSock(), data, sizeof(char)*max_length, 0); //read data from kernel buffer
  }
  
  if(msg_len < 0){
    perror("Comm::read_tcp_data():Received data length is negative.");
    exit(-1);
  }
  
  return select_re;
}


int Comm::recv_RBCPpacket(int array_size, unsigned char* data){

  if(array_size < 255+8){
    std::cout << "recv_RBCPpacket() : ERROR:Size of array \"data\" is too small!" << std::endl;
    return -1;
  }
  
  fd_set set_rbcp;
  int rcvdBytes = -1;
  int select_re = -1;
  
  FD_ZERO(&set_rbcp);
  FD_SET(GetUDPSock(), &set_rbcp);
  
  int cnt = 0;
  while(true){
    timeout.tv_sec = 1;
    timeout.tv_usec = 0;
    select_re = select(GetUDPSock()+1, &set_rbcp, NULL, NULL, &timeout);

    if(select_re == 1)
      break;
    else if(select_re == 0){
      if(cnt < 5){
	std::cout << "recv_RBCPpacket():Waiting for Data....."<< std::endl;
	cnt++;
      }else{
	std::cout << "recv_RBCPpacket():No Data!"<< std::endl;
	return select_re;
      }
    }else if(select_re < 0){
      std::cout << std::endl
		<< "recv_RBCPpacket() : WARNING:UDP connection has error." << std::endl;
      return select_re;
    }
  }

  rcvdBytes = recv(GetUDPSock(), data,
		   sizeof(char)*(255+8), 0); //read data from kernel buffer
  if(rcvdBytes < 0){
    perror("recv_RBCPpacket():Received data length is negative.");
    exit(-1);
  }
  
  return rcvdBytes;
}


int Comm::rcvRBCP_ACK(int output){

  unsigned char rcvdBuf[255+8];
  
  if(output == 1)
    std::cout << "Wait to receive the ACK packet.....";

  int rcvdBytes = recv_RBCPpacket(sizeof(rcvdBuf)/sizeof(unsigned char), rcvdBuf);
  if(rcvdBytes <= 0){
    std::cout << "rcvRBCP_ACK() : WARNING:Failed to receive ACK packet!" << std::endl;
    return -1;
  }
  
  if(output == 1){
    std::cout << "Received!" << std::endl
	      << "Received data:" << std::endl;

    for(int i=0; i<rcvdBytes; i++){
      if(i%4 == 0)
	printf("\tACK[%.3x]:%.2x ",i,rcvdBuf[i]);
      else if(i%4 == 3)
	printf("%.2x\n",rcvdBuf[i]);
      else
	printf("%.2x ",rcvdBuf[i]);
    }
    std::cout << std::endl;
	  
  }
  
  return 0;
}
