#ifndef SiTCP_H
#define SiTCP_H

#include<iostream>
#include<fstream>

#include<stdio.h>
#include<stdlib.h>

#include<errno.h>

#include<string>
#include<cstring>

#include<arpa/inet.h>


struct rbcp_header{
  unsigned char type;
  unsigned char command;
  unsigned char id;
  unsigned char length;
  unsigned int address;
};


class SiTCP{
public:
  SiTCP();
  ~SiTCP();
  
  bool SetIPPort(const char* IpAddr, unsigned int tcp, unsigned int udp);
  
  bool CreateUDPSock();
  bool CloseUDPSock();

  bool CreateTCPSock();
  int  check_TCPconnection();
  bool CloseTCPSock();
  
  int GetTCPSock() const {return tcpsock;}
  int GetUDPSock() const {return udpsock;}
  rbcp_header Get_RBCP_Header() const {return snd_RBCP_Header;}

protected:
  void set_RBCPHeader(unsigned char type, unsigned char command, unsigned char id, 
		      unsigned char length, unsigned int address);
  int set_RBCPData(unsigned char data);
  int set_RBCPData(unsigned char* data, int datasize);
  
  struct rbcp_header snd_RBCP_Header;
  unsigned char sndBuf[255+8];
  unsigned char sndData[255];
  struct sockaddr_in udpAddr;
  struct sockaddr_in tcpAddr;

  struct timeval timeout;
  
private:
  const char* sitcpIpAddr;
  unsigned int tcpPort;
  unsigned int udpPort;
  
  int udpsock;
  int tcpsock;

  fd_set rmask, wmask, readfds;
  
};

#endif
