#include "log.h"

void
err_msg(const char *classname, const char *funcname, const char *type, const char *fmt, ...)
{
  if(!strcmp(classname, "TBD"))
    fprintf(stderr, "%s : [%s()] : ", type, funcname);
  else
    fprintf(stderr, "%s : [%s::%s()] : ", type, classname, funcname);

  va_list ap;
  va_start(ap, fmt);
  vfprintf(stderr, fmt, ap);
  va_end(ap);

  fputc('\n', stderr);
}

void
info_msg(const char *classname, const char *funcname, const char *type, const char *fmt, ...)
{
  if(!strcmp(classname, "TBD"))
    fprintf(stdout, "%s : [%s()] : ", type, funcname);
  else
    fprintf(stdout, "%s : [%s::%s()] : ", type, classname, funcname);

  va_list ap;
  va_start(ap, fmt);
  vfprintf(stdout, fmt, ap);
  va_end(ap);

  fputc('\n', stdout);
}
