#include <iostream>
#include <fstream>
#include <string>

#include "unistd.h"
#include "stdio.h"
#include "stdlib.h"

#define binary(bit) strtol(bit,NULL,2)

void send_ctrlsig();

int main(){
  std::ofstream outf("../text/simulate.v", std::ios::out);
  outf.close();

  send_ctrlsig();

  return 0;
}

void send_ctrlsig(){

  /* ----------send 8 line control signals to FPGA memory----------- */

  std::ifstream inf("../text/svx4_diagram.dat");
  std::string tmpStr;
  std::string s_temp;

  std::string txt_odd[8];
  std::string txt_even[8];

  std::string bin_odd[8];
  std::string bin_even[8];

  std::cout << std::endl
	    << "Start to conversion : SVX4 diagram to binary data." << std::endl
	    << std::endl;

  while(inf >> tmpStr){
    if(tmpStr=="CHMODE.......:"){
      inf >> s_temp;
      txt_odd[0] = s_temp;
    }else if(tmpStr=="FEMODE.......:"){
      inf >> s_temp;
      txt_odd[1] = s_temp;
    }else if(tmpStr=="BEMODE.......:"){
      inf >> s_temp;
      txt_odd[2] = s_temp;
    }else if(tmpStr=="PRin.........:"){
      inf >> s_temp;
      txt_odd[3] = s_temp;
    }else if(tmpStr=="CLK_sel......:"){
      inf >> s_temp;
      txt_odd[4] = s_temp;
    }else if(tmpStr=="FECLK........:"){
      inf >> s_temp;
      txt_odd[5] = s_temp;
    }else if(tmpStr=="BECLK........:"){
      inf >> s_temp;
      txt_odd[6] = s_temp;
    }else if(tmpStr=="OBDV.........:"){
      inf >> s_temp;
      txt_odd[7] = s_temp;
    }else if(tmpStr=="BUS0/Comp_rst:"){
      inf >> s_temp;
      txt_even[0] = s_temp;
    }else if(tmpStr=="BUS1/Ramp_rst:"){
      inf >> s_temp;
      txt_even[1] = s_temp;
    }else if(tmpStr=="BUS2/PR2.....:"){
      inf >> s_temp;
      txt_even[2] = s_temp;
    }else if(tmpStr=="BUS3/Rref_sel:"){
      inf >> s_temp;
      txt_even[3] = s_temp;
    }else if(tmpStr=="BUS4/PARST...:"){
      inf >> s_temp;
      txt_even[4] = s_temp;
    }else if(tmpStr=="BUS5/L1A.....:"){
      inf >> s_temp;
      txt_even[5] = s_temp;
    }else if(tmpStr=="BUS6/PR1.....:"){
      inf >> s_temp;
      txt_even[6] = s_temp;
    }else if(tmpStr=="BUS7/CALSR...:"){
      inf >> s_temp;
      txt_even[7] = s_temp;
    }
  }

  inf.close();

  int odd_depth = -1;
  int even_depth = -1;

  // "_X_X_X___X" -> "0101010001"
  for(int ctrl_ch_odd=0; ctrl_ch_odd<8; ++ctrl_ch_odd){
    
    unsigned int odd_addr = 0;
    while(txt_odd[ctrl_ch_odd][odd_addr]){
      if(txt_odd[ctrl_ch_odd][odd_addr]=='_'){
	bin_odd[ctrl_ch_odd] += '0';
      }else if(txt_odd[ctrl_ch_odd][odd_addr]=='X'){
	bin_odd[ctrl_ch_odd] += '1';
      }
      ++odd_addr;
    }
    
    // std::cout << bin_odd[ctrl_ch_odd] << std::endl;
    if(odd_depth == -1)
      odd_depth = odd_addr;
    else{
      if(odd_depth != odd_addr){
	std::cout << "CtrlRAM(Odd) : (" << ctrl_ch_odd << ')' << std::endl;
	perror("Diagram has WRONG description");
	exit(1);
      }
    }
    
  }

  std::cout << "ctrl memory(odd) depth == " << odd_depth << std::endl;

  for(int ctrl_ch_even=0; ctrl_ch_even<8; ++ctrl_ch_even){
    
    unsigned int even_addr = 0;
    while(txt_even[ctrl_ch_even][even_addr]){
      if(txt_even[ctrl_ch_even][even_addr]=='_'){
	bin_even[ctrl_ch_even] += '0';
      }else if(txt_even[ctrl_ch_even][even_addr]=='X'){
	bin_even[ctrl_ch_even] += '1';
      }
      ++even_addr;
    }
    
    // std::cout << bin_even[ctrl_ch_even] << std::endl;
    if(even_depth == -1)
      even_depth = even_addr;
    else{
      if(even_depth != even_addr){
	std::cout << "CtrlRAM(Even) : (" << ctrl_ch_even << ')' << std::endl;
	perror("Diagram has WRONG description");
	exit(1);
      }
    }
    
  }

  std::cout << "ctrl memory(even) depth = " << even_depth << std::endl;

  unsigned int totlen;

  if(odd_depth != even_depth){
    perror("Diagram has WRONG description");
    exit(1);
  }else{
    totlen = odd_depth;
  }

  std::cout << "total signal length = " << totlen << std::endl;
  
  std::cout << std::endl
	    << "Finish to conversion : SVX4 diagram to binary data." << std::endl
	    << std::endl;
  

  /* -------------------- end file stream -------------------------- */

  std::ofstream outf("../text/simulate.v", std::ios::app);
  if(!outf){
    std::cout << "Failed to open file." << std::endl;
    exit(-1);
  }

  outf<<"#0       SIO_WE = 1'b1;"<<std::endl;
  
  int send_data[20000];
  int addr_offset = 0x10000;
  
  for(int addr=0; addr<totlen; addr++){
    
    char ctrl_odd[9] = "";
    char ctrl_even[9] = "";
    
    for(int width=0; width<8; ++width){
      std::strncat(ctrl_odd, (bin_odd[width].c_str()) + addr, 1);
      std::strncat(ctrl_even, (bin_even[width].c_str()) + addr, 1);
    }
    
    // std::cout << addr << " " << ctrl_odd << " " << ctrl_even << std::endl;
    
    outf<<"#RATE    SIO_ADDR[31:0] = 32'd"<< addr*2 + addr_offset <<';'<<std::endl;
    outf<<"#0       SIO_WD[7:0] = 8'b"<<ctrl_even<<';'<<std::endl;
    outf<<"#RATE    SIO_ADDR[31:0] = 32'd"<< addr*2+1 + addr_offset <<';'<<std::endl;
    outf<<"#0       SIO_WD[7:0] = 8'b"<<ctrl_odd<<';'<<std::endl;
  }

  outf<<"#0       SIO_WE = 1'b0;"<<std::endl;
  
  outf<<"#0       SIO_WE = 1'b1;"<<std::endl;
  outf<<"#RATE    SIO_ADDR[31:0] = 32'd"<< totlen*2 + addr_offset <<';'<<std::endl;
  outf<<"#0       SIO_WD[7:0] = 8'b1111_1111;"<<std::endl;
  outf<<"#RATE    SIO_ADDR[31:0] = 32'd"<< totlen*2+1 + addr_offset <<';'<<std::endl;
  outf<<"#0       SIO_WD[7:0] = 8'b1111_1111;"<<std::endl;
  outf<<"#0       SIO_WE = 1'b0;"<<std::endl;
  
  // comm->RBCP_multi_packet_send(0x00 + addr_offset, totlen*2, send_data);
  // comm->udp_send(totlen*2 + addr_offset, 0xff);// Address = signal depth
  // comm->udp_send(totlen*2 + 1 + addr_offset, 0xff);// Address = signal depth
}
