#pragma once

#include "svxconfig.h"

#include "TFile.h"
#include "TTree.h"

#include <iostream>
#include <iomanip>
#include <fstream>
#include <cstdlib>

#define STORAGE_DATASIZE 15

namespace svx{

  class Daq{
  public:
#ifdef SCTJDAQ_COMPILE
    Daq(std::string file_name = "/home/sctjdaq/data/test_teleraw.dat");
    Daq(Comm* arg_comm, std::string file_name = "/home/sctjdaq/data/test_teleraw.dat");
#else
    Daq(std::string file_name = "/data/test_teleraw.dat");
    Daq(Comm* arg_comm, std::string file_name = "data/test_teleraw.dat");
#endif
    
    ~Daq();
  
    int GetDecodedData(char* Data);
    int GetDecodedDataSize();
  
    int get_config_param(SVXconfig* config);
  
    int read_svxdata();
    int DecodeSVXData();

    void SetFileName(std::string name){rawfile_name = name;};
    void SetVerbose(int val){verbose_level = val;};
    
  private:
  
    int read_bitdata(std::string file_name);
    int write_svxdata(std::string rawfile_name);
    int write_errdata(std::string errmsg, int data_cnt, int backward=10, int forward=10);
  
    void init_vals();
  
    int get_rawdata(const int data_index);
    void DataIncrement(int &data_index, int width, bool retry=true);
  
    int find_ev_header(int decoded_index);
    int decode_eventnum(int decoded_index);
    int decode_timestamp(int decoded_index);
    int decode_quality_info(int decoded_index);
    int find_chip_header(int decoded_index);
    int find_missing_chip_header(int decoded_index);
    int decode_ch_adc(int decoded_index);
    int decode_missing_ch_adc(int decoded_index);
    int likelihood_chID(int chID, int prev_chID, const int data_cnt);

    //
    // member valuables
    //
    int verbose_level;
    
    Comm* comm;
  
    std::string rawfile_name;
    unsigned char raw_data[100000];
    unsigned char store_data[STORAGE_DATASIZE];
    int msg_len;
    int msg_len_tot;
  
    int ev_num;
    SVX_EF_HEADER m_ef_header;
    SVXDataBuf m_svxdata_buf[TELESCOPE_NUM]; 
  
    int found_tele_no;
    int found_chip_no;
    int chipID_config[TELESCOPE_NUM][4];
  
    //
    // Flags
    //
    bool dummy_data;
    bool found_chip[TELESCOPE_NUM][4];
    bool start_decode_next_ev;

    bool first_event;
  };


  inline int Daq::get_rawdata(const int data_index){
    if(data_index < 0)
      return (int)store_data[-data_index - 1];

    return (int)raw_data[data_index];
  }


  inline void Daq::DataIncrement(int &data_index, const int width, bool retry){
    
      if(msg_len - data_index < 10){
	int tmp_len = msg_len;

	if(verbose_level > 0)
	  std::cout << data_index
		    << " ===== To Read Next data from buffer =====" << std::endl;
	
	while(true){
	  try{
	    if(dummy_data)  read_bitdata(rawfile_name);
	    else            read_svxdata();

	    data_index = data_index - tmp_len + width;
	    break;
	  }catch(int e){
	    if(retry)  continue;
	    else       throw -1;
	  }
	}
	
      }else
	data_index = data_index + width;
      
  }

} // namespace svx
