#pragma once

#include "svxcommon.h"

#include "TFile.h"
#include "TTree.h"

#include <iostream>
#include <iomanip>
#include <fstream>
#include <cstdlib>

namespace svx{

  struct SVX_Tree{
    Int_t eventnum;
    Int_t timestamp;
#ifdef NEW_HEADER_FORMAT
    Int_t status;
#endif
    Short_t chip_ID[TELESCOPE_NUM][4];
    Short_t pipeline_ID[TELESCOPE_NUM][4];
    // Char_t hit_pattern[4][4];
    Short_t hit_num[TELESCOPE_NUM][4];
    Short_t adc[TELESCOPE_NUM][4][128];
  };


  struct SVX_Tree_endo{
    Int_t EventNumber;
    Int_t timestamp;
    std::vector<Int_t> *chipID;
    std::vector<Int_t> *pipelineID;
    std::vector<std::vector<Int_t> > *hitch;
    std::vector<std::vector<Int_t> > *hitadc;
  };

  class Logger{

  public:
  
    Logger(std::string treefile_name = "data/tele_tree.root");
    ~Logger();

    int FillTBranches(char* data);
    void SetFileName(std::string name){file_name = name;};
    void write_rootfile();

  private:
    int unpack_data(const char* data);
    void init_vals();

    struct SVX_EF_HEADER ef_header_log;
    struct SVX_EF *svx_ef_log[TELESCOPE_NUM];

    std::string file_name;
    TTree* tree;
    TFile* file;

    struct SVX_Tree svx_tree;
  
  };

} // namespace svx
