#pragma once

#ifdef SCTJDAQ_COMPILE
#include "DataStructure.h"
#endif

#include <string>
#include "vector"
#define TELESCOPE_NUM 4
#define PARAM_INDEX_END 40

/////////////////////////////
// COMMANDs
#define COMMAND 0xa5a

#define COM_ACTIVE 0xff
#define COM_DEACTIVE 0x00

#define COM_CONTROL 0x01
#define COM_CONTROL_STOP 0x03
#define COM_CONFIGURE 0x05
#define COM_START 0x55
#define COM_PAUSE 0x5a
#define COM_RESUME 0xa5
#define COM_STOP 0xaa
#define COM_UNCONFIGURE 0xa0

#define binary(bit) strtol(bit,NULL,2)

namespace svx{

#ifndef SCTJDAQ_COMPILE
  struct SVXdata{
    unsigned short hitch;
    unsigned char hitadc;
  };


  struct SVXDataBuf{
    // unsigned int event_number;
    // unsigned int time_stamp;
    // unsigned char status;
    unsigned short telescope_No;
    unsigned char chipID[4];
    unsigned char pipelineID[4];
    unsigned short hitnum;
    std::vector<SVXdata> svx_data;
  };


  struct SVX_EF{
    unsigned short telescope_No;
    unsigned char chipID[4];
    unsigned char pipelineID[4];
    unsigned short hitnum;
    SVXdata svx_data[1];
  };


  struct SVX_EF_HEADER{
    // Common region
    unsigned short magicdata;
    unsigned short totalsize;
    unsigned int event_number;
    unsigned int time_stamp;

    // SVX region
    unsigned short ef_number;
    unsigned short ef_length[4];
#ifdef NEW_HEADER_FORMAT
    unsigned char data_quality;
    unsigned char data_type;
#endif
  };
  
#endif // SCTJDAQ_COMPILE

  enum Run_Mode{
    DATA = 1,
    ANA = 2,
    DATA_ANA = 3,
  };


  enum Test_Mode{
    Default = 0,
    Mask = 1,
    Gain = 2,
    Threshold = 3,
    Pickdel_scan = 4,
    Trig_delay = 5,
  };


  enum param_names{
    Mask_0 = 0,
    Mask_1 = 1,
    Mask_2 = 2,
    Mask_3 = 3,
    Mask_4 = 4,
    Mask_5 = 5,
    Mask_6 = 6,
    Mask_7 = 7,
    Mask_8 = 8,
    Mask_9 = 9,
    Mask_10 = 10,
    Mask_11 = 11,
    Mask_12 = 12,
    Mask_13 = 13,
    Mask_14 = 14,
    Mask_15 = 15,
    spare, VCAL, Disable,
    BW, Isel, IWsel, IRsel,
    PickDel, PB, ID, RTPS,
    Rd127, Rd63, RdAll, RdNeigh,
    RampPed, RampDir, CompPol, RampRng,
    Thresh, CntrMod,
    FC, LC, DriverI
  };


  struct Strparam_names : public std::string{
    Strparam_names(param_names e){
      switch(e) {
	break; case Mask_0 : { assign("Mask_0  "); }
	break; case Mask_1 : { assign("Mask_1  "); }
	break; case Mask_2 : { assign("Mask_2  "); }
	break; case Mask_3 : { assign("Mask_3  "); }
	break; case Mask_4 : { assign("Mask_4  "); }
	break; case Mask_5 : { assign("Mask_5  "); }
	break; case Mask_6 : { assign("Mask_6  "); }
	break; case Mask_7 : { assign("Mask_7  "); }
	break; case Mask_8 : { assign("Mask_8  "); }
	break; case Mask_9 : { assign("Mask_9  "); }
	break; case Mask_10: { assign("Mask_10 "); }
	break; case Mask_11: { assign("Mask_11 "); }
	break; case Mask_12: { assign("Mask_12 "); }
	break; case Mask_13: { assign("Mask_13 "); }
	break; case Mask_14: { assign("Mask_14 "); }
	break; case Mask_15: { assign("Mask_15 "); }
	break; case spare  : { assign("spare   "); }
	break; case VCAL   : { assign("VCAL    "); }
	break; case Disable: { assign("Disable "); }
	break; case BW     : { assign("BW      "); }
	break; case Isel   : { assign("Isel    "); }
	break; case IWsel  : { assign("IWsel   "); }
	break; case IRsel  : { assign("IRsel   "); }
	break; case PickDel: { assign("PickDel "); }
	break; case PB     : { assign("PB      "); }
	break; case ID     : { assign("ID      "); }
	break; case RTPS   : { assign("RTPS    "); }
	break; case Rd127  : { assign("Rd127   "); }
	break; case Rd63   : { assign("Rd63    "); }
	break; case RdAll  : { assign("RdAll   "); }
	break; case RdNeigh: { assign("RdNeigh "); }
	break; case RampPed: { assign("RampPed "); }
	break; case RampDir: { assign("RampDir "); }
	break; case CompPol: { assign("CompPol "); }
	break; case RampRng: { assign("RampRng "); }
	break; case Thresh : { assign("Thresh  "); }
	break; case CntrMod: { assign("CntrMod "); }
	break; case FC     : { assign("FC      "); }
	break; case LC     : { assign("LC      "); }
	break; case DriverI: { assign("DriverI "); }
	break; default: { assign("illegal "); }
      }
    }
  };


  // Gray code decoder
  unsigned char gray_encoder(unsigned char binary);
  unsigned char gray_decoder(unsigned char gray);
  std::string uc2binary(unsigned char val);
  std::string inv_str(const char* cval);

  struct change_param{
    param_names name;
    int val;
    int tele_i;
    int chip_i;
    bool change_all;
  };

  // common flag of test data
  extern std::vector<struct change_param> g_change_params;
  extern int g_num_event;
  extern enum Run_Mode g_run_mode;
  extern enum Test_Mode g_test_mode;

  extern int g_verbose_level;
  extern std::string g_filename;
  
} // namespace svx
