#pragma once

#include <iostream>
#include <cxxabi.h>


class Demangle
{
private:
  char* realname;

public:
  
  Demangle(const std::type_info& ti){
    int status = 0;
    realname = abi::__cxa_demangle(ti.name(), 0, 0, &status);
  }

  Demangle(const Demangle& other) = delete;
  Demangle& operator=(const Demangle& other) = delete;

  ~Demangle(){std::free( realname );}

  operator char const*() const{return realname;}

};
