#include "logger.h"

#include "stdio.h"
#include "stdlib.h"
#include "unistd.h"

#define SVX4_MAGIC_NUM 25104 //magic number

namespace svx{

  Logger::Logger(std::string treefile_name){
    file_name = treefile_name;

    file = new TFile(file_name.c_str(), "recreate");
    tree = new TTree("svx_ev_tree", "SVX4_EventTree");
    
    tree->Branch("Ev_Num", &(svx_tree.eventnum), "Ev_Num/I");
    tree->Branch("Timestamp", &(svx_tree.timestamp), "Timestamp/I");

    tree->Branch("chipID", svx_tree.chip_ID, "chipID[4][4]/S");
    tree->Branch("pipeID", svx_tree.pipeline_ID, "pipeID[4][4]/S");
    tree->Branch("hitnum", svx_tree.hit_num, "hitnum[4][4]/S");
    tree->Branch("adc", svx_tree.adc, "chipID[4][4][128]/S");
    
    // for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
    //   tree->Branch(Form("chipID_%d", tele_i),
    //   		   svx_tree.chip_ID[tele_i], Form("chipID_%d[4]/S", tele_i));
    //   tree->Branch(Form("pipeID_%d", tele_i),
    //   		   svx_tree.pipeline_ID[tele_i], Form("pipeID_%d[4]/S", tele_i));
    //   tree->Branch(Form("hit_ptn_%d", tele_i),
    //   		 hit_pattern[tele_i], Form("hit_ptn_%d[4]/C", tele_i));
    //   tree->Branch(Form("hitnum_%d", tele_i),
    //   		   svx_tree.hit_num[tele_i], Form("hitnum_%d[4]/S", tele_i));
    //   for(int chip_i=0; chip_i<4; chip_i++)
    // 	tree->Branch(Form("adc_%d_%d", tele_i, chip_i),
    // 		     svx_tree.adc[tele_i][chip_i],
    // 		     Form("adc_%d_%d[128]/S", tele_i, chip_i));
    // }
    
  }


  Logger::~Logger(){
    file->Write();
    file->Close();
    // delete tree;
    delete file;
  }

  
  void Logger::init_vals(){

    svx_tree.eventnum = -1;
    svx_tree.timestamp = -1;
  
    for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
      for(int chip_i=0; chip_i<4; chip_i++){
	svx_tree.chip_ID[tele_i][chip_i] = -1;
	svx_tree.pipeline_ID[tele_i][chip_i] = -1;
	svx_tree.hit_num[tele_i][chip_i] = -1;
	for(int k=0; k<128; k++)
	  svx_tree.adc[tele_i][chip_i][k] = -1;
      }
    }
  
  }


  int Logger::unpack_data(const char *data){
  
    const char *buf_pointer;

    memcpy((char*)&ef_header_log, data, sizeof(SVX_EF_HEADER));
    buf_pointer = data + sizeof(SVX_EF_HEADER);
  
    for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
      int data_size = (int)ef_header_log.ef_length[tele_i];
      svx_ef_log[tele_i] = (SVX_EF*)malloc(data_size);
    
      std::cout << "telescope No. " << tele_i << std::endl
		<< "data_size = " << data_size << std::endl;
    
      if(svx_ef_log == NULL){
	std::cout << "Memory Allocaiton Error! Telescope data" << tele_i << std::endl;
	
	return -1;
      }
 
      memcpy((char*)svx_ef_log[tele_i], buf_pointer , data_size);
      buf_pointer += data_size; // Shift Pointer to Next EF
    }
  
    return 0;
  }


  int Logger::FillTBranches(char* data){
    
    int re = unpack_data(data);
    if(re != 0)
      return -1;
    
    init_vals();

    svx_tree.eventnum = ef_header_log.event_number;
    svx_tree.timestamp = ef_header_log.time_stamp;
  
    for(int tele_i=0; tele_i<TELESCOPE_NUM; tele_i++){
      int total_hitnum = svx_ef_log[tele_i]->hitnum;
      int chip_hitnum[4] = {0};
      for(int n=0; n<total_hitnum; n++){
	int ch = (int)svx_ef_log[tele_i]->svx_data[n].hitch;
	int adc = (int)svx_ef_log[tele_i]->svx_data[n].hitadc;
	if(ch < 128 && ch >= 0){
	  svx_tree.adc[tele_i][0][ch] = adc;
	  chip_hitnum[0]++;
	}else if(ch < 128*2 && ch >= 128){
	  svx_tree.adc[tele_i][1][ch - 128] = adc;
	  chip_hitnum[1]++;
	}else if(ch < 128*3 && ch >= 128*2){
	  svx_tree.adc[tele_i][2][ch - 128*2] = adc;
	  chip_hitnum[2]++;
	}else if(ch < 128*4 && ch >= 128*3){
	  svx_tree.adc[tele_i][3][ch - 128*3] = adc;
	  chip_hitnum[3]++;
	}
      }
    
      for(int chip_i=0; chip_i<4; chip_i++){
	svx_tree.chip_ID[tele_i][chip_i] = svx_ef_log[tele_i]->chipID[chip_i];
	svx_tree.pipeline_ID[tele_i][chip_i] = svx_ef_log[tele_i]->pipelineID[chip_i];
	svx_tree.hit_num[tele_i][chip_i] = chip_hitnum[chip_i];
      }
    }

    tree->Fill();
    
    for(int i=0; i<TELESCOPE_NUM; i++)
      free(svx_ef_log[i]);
    
    return 0;
  }

} // namespace svx
