library IEEE, work;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use work.AddressMap.all;
use work.BusSignalTypes.all;
use work.AddressBook.all;

entity SigSel_Module is
	port(
		rst	: in std_logic;
		clk	: in std_logic;
		-- Module output --
		outSelNIM1	: out std_logic_vector(3 downto 0);
		outSelNIM2	: out std_logic_vector(3 downto 0);
		outSelNIM3	: out std_logic_vector(3 downto 0);
		outSelNIM4	: out std_logic_vector(3 downto 0);
		-- Local bus --
		addrLocalBus		: in LocalAddressType;
		dataLocalBusIn		: in LocalBusInType;
		dataLocalBusOut	    : out LocalBusOutType;
		reLocalBus			: in std_logic;
		weLocalBus			: in std_logic;
		readyLocalBus		: out std_logic
	);
end SigSel_Module;

architecture RTL of SigSel_Module is
	-- internal signal declaration ----------------------------------------
	signal reg_sel_nim1	: std_logic_vector(3 downto 0);
	signal reg_sel_nim2	: std_logic_vector(3 downto 0);
	signal reg_sel_nim3	: std_logic_vector(3 downto 0);
	signal reg_sel_nim4	: std_logic_vector(3 downto 0);
	signal state_lbus	: BusProcessType;

	-- =============================== body ===============================
begin	
    outSelNIM1	<= reg_sel_nim1;
    outSelNIM2	<= reg_sel_nim2;
	outSelNIM3	<= reg_sel_nim3;
	outSelNIM4	<= reg_sel_nim4;

	u_BusProcess : process(clk, rst)
	begin
		if(rst = '1') then
			state_lbus	<= Init;
		elsif(clk'event and clk = '1') then
			case state_lbus is
			when Init =>
				dataLocalBusOut 	<= x"00";
				readyLocalBus		<= '0';
				reg_sel_nim1		<= (others => '0');
				reg_sel_nim2		<= (others => '0');
				reg_sel_nim3		<= (others => '0');
				reg_sel_nim4		<= (others => '0');
				state_lbus			<= Idle;
				
			when Idle =>
				readyLocalBus	<= '0';
				if(weLocalBus = '1' or reLocalBus = '1') then
					state_lbus	<= Connect;
				end if;
			
			when Connect =>
				if(weLocalBus = '1') then
					state_lbus	<= Write;
				else
					state_lbus	<= Read;
				end if;
				
			when Write =>
				case addrLocalBus is
				when sel_nim1 =>
				    reg_sel_nim1	<= dataLocalBusIn(3 downto 0);
				when sel_nim2 =>
				    reg_sel_nim2	<= dataLocalBusIn(3 downto 0);
				when sel_nim3 =>
					reg_sel_nim3	<= dataLocalBusIn(3 downto 0);
			    when sel_nim4 =>
			        reg_sel_nim4	<= dataLocalBusIn(3 downto 0);
				when others => null;
				end case;
				state_lbus	<= Done;
				
			when Read =>
    			dataLocalBusOut <= x"ff";
				state_lbus	<= Done;
				
			when Done =>
				readyLocalBus	<= '1';
				if(weLocalBus = '0' and reLocalBus = '0') then
					state_lbus	<= Idle;
				end if;
			
			-- probably this is error --
			when others =>
				state_lbus	<= Init;
			end case;
		end if;
	end process u_BusProcess;

end RTL;

