library IEEE, work;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.std_logic_arith.all;
use ieee.std_logic_unsigned.all;
use work.AddressMap.all;
use work.BusSignalTypes.all;
use work.AddressBook.all;

entity coinFBH is
    generic(
        width       : integer
    );
    Port (
        rst         : in std_logic;
        clk         : in std_logic;
        inFD        : in std_logic_vector(2*NofFBH_Raw -1 downto 0);
        outFBHRaw   : out std_logic_vector(NofFBH_Raw -1 downto 0)
    );
end coinFBH;

architecture RTL of coinFBH is
    -- Internal signal declaration ------------------------------------------------------------
    signal fbh_u, fbh_d : std_logic_vector(NofFBH_Raw-1 downto 0);
    signal coin_fbh    : std_logic_vector(NofFBH_Raw-1 downto 0);
    signal pedge_fbh    : std_logic_vector(NofFBH_Raw-1 downto 0);
    signal out_fbh_raw  : std_logic_vector(NofFBH_Raw-1 downto 0);
    
    component EdgeDetector
        port (
            rst : in std_logic;
            clk : in std_logic;
            dIn : in std_logic;
            dOut : out std_logic 
        );
    end component;
    
    component WidthGen
        generic(
            width   : integer 
        );
        Port (
            rst     : in std_logic;
            clk     : in std_logic;
            dataIn  : in std_logic;
            dataOut : out std_logic
        );
    end component;
    
begin
    -- ========================================== body ===============================================
    outFBHRaw   <= out_fbh_raw;
    
    gen_coin_fbh : for i in 0 to NofFBH_Raw-1 generate
        fbh_u(i)    <= inFD(i);
        fbh_d(i)    <= inFD(31 - i);
        coin_fbh(i) <= fbh_u(i) AND fbh_d(i);
        
        u_pedge_coin : EdgeDetector
            port map(rst=>rst, clk=>clk, dIn=>coin_fbh(i), dOut=>pedge_fbh(i));
        
        u_width_coin : WidthGen
            generic map(width => width)
            port map(rst=>rst, clk=>clk, dataIn=>pedge_fbh(i), dataOut=>out_fbh_raw(i));
    end generate;
end RTL;
