
//#define pai 3.141592

void TimingCorrect(char *run_number,char *ped_number){

   gROOT->Reset();

   char filename[40];
   sprintf(filename,"../raw_data/%s.dat",run_number);
   
   char filename2[40];
   sprintf(filename2,"../Root_File/%s_ped.root",ped_number);
   
   TFile f(filename2);
   
   Double_t ch1_pedy[1024];
   Double_t ch2_pedy[1024];
   Double_t ch3_pedy[1024];
   Double_t ch4_pedy[1024];
   Double_t ch5_pedy[1024];
   Double_t ch6_pedy[1024];
   Double_t ch7_pedy[1024];
   Double_t ch8_pedy[1024];
   Double_t ch9_pedy[1024];
   Double_t ch10_pedy[1024];
   Double_t ch11_pedy[1024];
   Double_t ch12_pedy[1024];
   Double_t ch13_pedy[1024];
   Double_t ch14_pedy[1024];
   Double_t ch15_pedy[1024];
   Double_t ch16_pedy[1024];
   
   for (int i=0; i<1024; i++) {
      ch1_pedy[i]  = ped_graph1->Eval(i,0,"");
      ch2_pedy[i]  = ped_graph2->Eval(i,0,"");
      ch3_pedy[i]  = ped_graph3->Eval(i,0,"");
      ch4_pedy[i]  = ped_graph4->Eval(i,0,"");
      ch5_pedy[i]  = ped_graph5->Eval(i,0,"");
      ch6_pedy[i]  = ped_graph6->Eval(i,0,"");
      ch7_pedy[i]  = ped_graph7->Eval(i,0,"");
      ch8_pedy[i]  = ped_graph8->Eval(i,0,"");
      ch9_pedy[i]  = ped_graph9->Eval(i,0,"");
      ch10_pedy[i] = ped_graph10->Eval(i,0,"");
      ch11_pedy[i] = ped_graph11->Eval(i,0,"");
      ch12_pedy[i] = ped_graph12->Eval(i,0,"");
      ch13_pedy[i] = ped_graph13->Eval(i,0,"");
      ch14_pedy[i] = ped_graph14->Eval(i,0,"");
      ch15_pedy[i] = ped_graph15->Eval(i,0,"");
      ch16_pedy[i] = ped_graph16->Eval(i,0,"");
      
      if (((i+1)%100)==0) {
         printf("%d times pedestal data read\n",i);
      }
   }
      
   f.Close();
   
   FILE *fp;
   if ((fp = fopen(filename,"rb+"))==NULL){
      printf("File open Error\n");
      return -1;
   }
   
   TTree t("t","t");
   
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;
   
   Double_t chip1_wave[1024];
   Double_t chip2_wave[1024];
   Double_t wave_time[1024];
   
   t.Branch("chip1_wave", chip1_wave, "chip1_wave[1024]/D_t");
   t.Branch("chip2_wave", chip2_wave, "chip2_wave[1024]/D_t");
   
   //int next_high;
   //int next_low;
   
   Double_t wave[2];
   Double_t time[2];
   
   Double_t amp1;
   Double_t freq1;
   Double_t phase1;
   Double_t period1;
   Double_t abs_period1;
   
   t.Branch("amp1",    &amp1,    "amp1/D_t");
   t.Branch("freq1",   &freq1,   "freq1/D_t");
   t.Branch("phase1",  &phase1,  "phase1/D_t");
   t.Branch("period1", &period1, "period1/D_t");
   
   Double_t amp2;
   Double_t freq2;
   Double_t phase2;
   Double_t period2;
   Double_t abs_period2;
   
   t.Branch("amp2",    &amp2,    "amp2/D_t");
   t.Branch("freq2",   &freq2,   "freq2/D_t");
   t.Branch("phase2",  &phase2,  "phase2/D_t");
   t.Branch("period2", &period2, "period2/D_t");
   
   Double_t correct_val;
   
   t.Branch("correct_val", &correct_val, "correct_val/D_t");
   
   Double_t freq5MHz = ((2.0*TMath::Pi())/200.0)*(1000.0/1024.0) ;
   //double phase_min = ((2.0*TMath::Pi())/(-200.0));
   //double phase_max =  (2.0*TMath::Pi())/200.0;
   
   for (int i=0; i<1024; i++) {
      wave_time[i] = i;
   }
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
            
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Data Packet Read */
      hitnum = Length/2060;
      int cap_point;
      
      for (int i=0; i<hitnum; i++) {
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,data_length,fp);
         
         if (ch_num==1) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               chip1_wave[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch2_pedy[cap_point]) / 2.0;
            }
         } else if (ch_num==8) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               chip2_wave[n] = ((((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF)) - ch9_pedy[cap_point]) / 2.0;
            }
         }
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
      }
      
//      TCanvas *c1 = new TCanvas("c1","c1",800,800);
//      c1->cd();
      
      TGraph *g1 = new TGraph(1024,wave_time,chip1_wave);
      TF1    *f1 = new TF1("f1","[0]+[1]*sin([2]*x-[3])");
      
      f1->SetParameters(0.0,400.0,freq5MHz,0.0);
      f1->SetParLimits(1,390.0,410.0);
      f1->SetParLimits(3,(-2.0*TMath::Pi()),(2.0*TMath::Pi()));
      //g1->Fit("f1","","",50,500);
      g1->Fit("f1","","",50,250);
      amp1    = g1->GetFunction("f1")->GetParameter(1);
      freq1   = g1->GetFunction("f1")->GetParameter(2);
      phase1  = g1->GetFunction("f1")->GetParameter(3);
      period1 = ((2.0*TMath::Pi()) / freq1);

      if ((((195.0 < period1) && (period1 < 215.0)) || (((-215.0) < period1) && (period1 < (-195.0))))==0){
         f1->SetParameters(0.0,400.0,freq5MHz,(0.5*TMath::Pi()));
         f1->SetParLimits(1,390.0,410.0);
         f1->SetParLimits(3,(-2.0*TMath::Pi()),(2.0*TMath::Pi()));
         //g1->Fit("f1","","",50,500);
         g1->Fit("f1","","",50,250);
         amp1    = g1->GetFunction("f1")->GetParameter(1);
         freq1   = g1->GetFunction("f1")->GetParameter(2);
         phase1  = g1->GetFunction("f1")->GetParameter(3);
         period1 = ((2.0*TMath::Pi()) / freq1);
         
         if ((((195.0 < period1) && (period1 < 215.0)) || (((-215.0) < period1) && (period1 < (-195.0))))==0){
            f1->SetParameters(0.0,400.0,freq5MHz,(TMath::Pi()));
            f1->SetParLimits(1,390.0,410.0);
            f1->SetParLimits(3,(-2.0*TMath::Pi()),(2.0*TMath::Pi()));
            //g1->Fit("f1","","",50,500);
            g1->Fit("f1","","",50,250);
            amp1    = g1->GetFunction("f1")->GetParameter(1);
            freq1   = g1->GetFunction("f1")->GetParameter(2);
            phase1  = g1->GetFunction("f1")->GetParameter(3);
            period1 = ((2.0*TMath::Pi()) / freq1);
            
            if ((((195.0 < period1) && (period1 < 215.0)) || (((-215.0) < period1) && (period1 < (-195.0))))==0){
               f1->SetParameters(0.0,400.0,freq5MHz,(1.5*TMath::Pi()));
               f1->SetParLimits(1,390.0,410.0);
               f1->SetParLimits(3,(-2.0*TMath::Pi()),(2.0*TMath::Pi()));
               //g1->Fit("f1","","",50,500);
               g1->Fit("f1","","",50,250);
               amp1    = g1->GetFunction("f1")->GetParameter(1);
               freq1   = g1->GetFunction("f1")->GetParameter(2);
               phase1  = g1->GetFunction("f1")->GetParameter(3);
               period1 = ((2.0*TMath::Pi()) / freq1);
               
               if ((((195.0 < period1) && (period1 < 215.0)) || (((-215.0) < period1) && (period1 < (-195.0))))==0){
                  phase1 = (0.002*TMath::Pi()) ;
               }
            }
         }
      }
      
      phase1 = phase1 / freq1 ;
//      phase1 = (period1*phase1) / (2.0*TMath::Pi()) ;
      
//      g1->Draw("A*");
//      printf("phase1 = %lf\n",((2.0*TMath::Pi())/phase1));
      
      /*if ((195.0 < period1) && (period1 < 215.0)) {
         if (((-period1) < phase1) && (phase1 < 0.0)) {
            phase1 = (period1 + phase1) ;
         } else if ((period1 < phase1) && (phase1 < (2*period1))) {
            phase1 = (phase1 - period1) ;
         } else {
            phase1 =  phase1 ;
         }
      } else if (((-215.0) < period1) && (period1 < (-195.0))) {
         if ((period1 < phase1) && (phase1 < 0.0)) {
            phase1 = ((-period1) + phase1) ;
         } else if (((-period1) < phase1) && (phase1 < (2*(-period1)))) {
            phase1 = (phase1 + period1) ;
         } else {
            phase1 =  phase1 ;
         }
      } else {
         f1->SetParameters(0,400,0.0306,50);
         f1->SetParLimits(1,390,410);
         f1->SetParLimits(3,-200,200);
         g1->Fit("f1","","",50,500);
         amp1    = g1->GetFunction("f1")->GetParameter(1);
         freq1   = g1->GetFunction("f1")->GetParameter(2);
         phase1  = g1->GetFunction("f1")->GetParameter(3);
         period1 = ((2.0*pai) / freq1);
         if ((195.0 < period1) && (period1< 215.0)) {
            if (((-period1) < phase1) && (phase1 < 0.0)) {
               phase1 = (period1 + phase1) ;
            } else if ((period1 < phase1) && (phase1 < (2*period1))) {
               phase1 = (phase1 - period1) ;
            } else {
               phase1 =  phase1 ;
            }
         } else if (((-215.0) < period1) && (period1 < (-195.0))) {
            if ((period1 < phase1) && (phase1 < 0.0)) {
               phase1 = ((-period1) + phase1) ;
            } else if (((-period1) < phase1) && (phase1 < (2*(-period1)))) {
               phase1 = (phase1 + period1) ;
            } else {
               phase1 =  phase1 ;
            }
         } else {
            f1->SetParameters(0,400,0.0306,100);
            f1->SetParLimits(1,390,410);
            f1->SetParLimits(3,-200,200);
            g1->Fit("f1","","",50,500);
            amp1    = g1->GetFunction("f1")->GetParameter(1);
            freq1   = g1->GetFunction("f1")->GetParameter(2);
            phase1  = g1->GetFunction("f1")->GetParameter(3);
            period1 = ((2.0*pai) / freq1);
            if ((195.0 < period1) && (period1< 215.0)) {
               if (((-period1) < phase1) && (phase1 < 0.0)) {
                  phase1 = (period1 + phase1) ;
               } else if ((period1 < phase1) && (phase1 < (2*period1))) {
                  phase1 = (phase1 - period1) ;
               } else {
                  phase1 =  phase1 ;
               }
            } else if (((-215.0) < period1) && (period1 < (-195.0))) {
               if ((period1 < phase1) && (phase1 < 0.0)) {
                  phase1 = ((-period1) + phase1) ;
               } else if (((-period1) < phase1) && (phase1 < (2*(-period1)))) {
                  phase1 = (phase1 + period1) ;
               } else {
                  phase1 =  phase1 ;
               }
            } else {
               f1->SetParameters(0,400,0.0306,150);
               f1->SetParLimits(1,390,410);
               f1->SetParLimits(3,-200,200);
               g1->Fit("f1","","",50,500);
               amp1    = g1->GetFunction("f1")->GetParameter(1);
               freq1   = g1->GetFunction("f1")->GetParameter(2);
               phase1  = g1->GetFunction("f1")->GetParameter(3);
               period1 = ((2.0*pai) / freq1);
               if ((195.0 < period1) && (period1< 215.0)) {
                  if (((-period1) < phase1) && (phase1 < 0.0)) {
                     phase1 = (period1 + phase1) ;
                  } else if ((period1 < phase1) && (phase1 < (2*period1))) {
                     phase1 = (phase1 - period1) ;
                  } else {
                     phase1 =  phase1 ;
                  }
               } else if (((-215.0) < period1) && (period1 < (-195.0))) {
                  if ((period1 < phase1) && (phase1 < 0.0)) {
                     phase1 = ((-period1) + phase1) ;
                  } else if (((-period1) < phase1) && (phase1 < (2*(-period1)))) {
                     phase1 = (phase1 + period1) ;
                  } else {
                     phase1 =  phase1 ;
                  }
               } else {
                     phase1 =  400.0 ;
               }
            }
         }
      }*/
      
      
      /*
//      if (phase1 < ((-2.0*pai)/0.032)) {
      if (phase1 < (-200.0)) {
         f1->SetParameters(0,400,0.03,-50);
         g1->Fit("f1","","",50,300);
         cycle1 = g1->GetFunction("f1")->GetParameter(2);
         phase1 = g1->GetFunction("f1")->GetParameter(3);
         if ((-200.0) < phase1 < 0.0) {
            phase1   = (((2.0*pai) / cycle1) + phase1) ;
            phase1_2 = ((2.0*pai) / cycle1);
         }
//      } else if (((2.0*pai) / 0.032) < phase1) {
      } else if (400.0 < phase1) {
         f1->SetParameters(0,400,0.03,50);
         g1->Fit("f1","","",50,300);
         cycle1 = g1->GetFunction("f1")->GetParameter(2);
         phase1 = g1->GetFunction("f1")->GetParameter(3);
         if (((2.0*pai) / cycle1) < phase1 < (2*((2.0*pai) / cycle1))) {
            phase1   = (phase1 - ((2.0*pai) / cycle1)) ;
            phase1_2 = ((2.0*pai) / cycle1);
         }
      } else if ((-((2.0*pai) / cycle1)) < phase1 < 0.0) {
         phase1   = (((2.0*pai) / cycle1) + phase1) ;
         phase1_2 = ((2.0*pai) / cycle1);
      } else if (((2.0*pai) / cycle1) < phase1 < (2*((2.0*pai) / cycle1))) {
         phase1   = (phase1 - ((2.0*pai) / cycle1)) ;
         phase1_2 = ((2.0*pai) / cycle1);
      }*/
         
      
      /*TCanvas *c2 = new TCanvas("c2","c2",1200,600);
      c2->Divide(2,1);
      c2->cd(1);
      g1->Draw("A*");
      
      TF1 *f2;
      f2 = g1->GetFunction("f1");

      g1->Draw("A*");
      c2->cd(2);
      f2->Draw();*/
      
      /* Chip1 Zero Point Search */
      /*next_high = 0;
      next_low  = 0;
      
      if (chip1_wave[1]<0.0) {
         next_high = 1;
      } else if (chip1_wave[1]>0.0) {
         next_low = 1;
      }
      
      if (next_high==1) {
         for (int i=0; i<1000; i++) {
            wave[0] = chip1_wave[i];
            wave[1] = chip1_wave[i+1];
            time[0] = i;
            time[1] = i+1;
            if (wave[1]>0.0) {
               break;
            }
         }
      } else if (next_low==1) {
         for (int i=0; i<1000; i++) {
            wave[0] = chip1_wave[i];
            wave[1] = chip1_wave[i+1];
            time[0] = i;
            time[1] = i+1;
            if (wave[1]<0.0) {
               break;
            }
         }
      } else {
         chip1_zero_time = 1.0;
      }*/
      
//      TCanvas *c2 = new TCanvas("c2","c2",800,800);
//      c2->cd();
      
      TGraph *g1 = new TGraph(1024,wave_time,chip2_wave);
      TF1    *f1 = new TF1("f1","[0]+[1]*sin([2]*x-[3])");
      
      f1->SetParameters(0,400,freq5MHz,0.0);
      f1->SetParLimits(1,390,410);
      f1->SetParLimits(3,(-2.0*TMath::Pi()),(2.0*TMath::Pi()));
      //g1->Fit("f1","","",50,500);
      g1->Fit("f1","","",50,250);
      amp2    = g1->GetFunction("f1")->GetParameter(1);
      freq2   = g1->GetFunction("f1")->GetParameter(2);
      phase2  = g1->GetFunction("f1")->GetParameter(3);
      period2 = ((2.0*TMath::Pi()) / freq2);
      
      if ((((195.0 < period2) && (period2 < 215.0)) || (((-215.0) < period2) && (period2 < (-195.0))))==0) {
         f1->SetParameters(0,400,freq5MHz,(0.5*TMath::Pi()));
         f1->SetParLimits(1,390,410);
         f1->SetParLimits(3,(-2.0*TMath::Pi()),(2.0*TMath::Pi()));
         //g1->Fit("f1","","",50,500);
         g1->Fit("f1","","",50,250);
         amp2    = g1->GetFunction("f1")->GetParameter(1);
         freq2   = g1->GetFunction("f1")->GetParameter(2);
         phase2  = g1->GetFunction("f1")->GetParameter(3);
         period2 = ((2.0*TMath::Pi()) / freq2);
         if ((((195.0 < period2) && (period2 < 215.0)) || (((-215.0) < period2) && (period2 < (-195.0))))==0) {
            f1->SetParameters(0,400,freq5MHz,(TMath::Pi()));
            f1->SetParLimits(1,390,410);
            f1->SetParLimits(3,(-2.0*TMath::Pi()),(2.0*TMath::Pi()));
            //g1->Fit("f1","","",50,500);
            g1->Fit("f1","","",50,250);
            amp2    = g1->GetFunction("f1")->GetParameter(1);
            freq2   = g1->GetFunction("f1")->GetParameter(2);
            phase2  = g1->GetFunction("f1")->GetParameter(3);
            period2 = ((2.0*TMath::Pi()) / freq2);
            if ((((195.0 < period2) && (period2 < 215.0)) || (((-215.0) < period2) && (period2 < (-195.0))))==0) {
               f1->SetParameters(0,400,freq5MHz,(1.5*TMath::Pi()));
               f1->SetParLimits(1,390,410);
               f1->SetParLimits(3,(-2.0*TMath::Pi()),(2.0*TMath::Pi()));
               //g1->Fit("f1","","",50,500);
               g1->Fit("f1","","",50,250);
               amp2    = g1->GetFunction("f1")->GetParameter(1);
               freq2   = g1->GetFunction("f1")->GetParameter(2);
               phase2  = g1->GetFunction("f1")->GetParameter(3);
               period2 = ((2.0*TMath::Pi()) / freq2);
               if ((((195.0 < period2) && (period2 < 215.0)) || (((-215.0) < period2) && (period2 < (-195.0))))==0) {
                  phase2 = (0.002*TMath::Pi()) ;
               }
            }
         }
      }      
      
      phase2 = phase2 / freq2 ;
      //phase2 = (period2*phase2) / (2.0*TMath::Pi()) ;
      
//      g1->Draw("A*");
//      printf("phase2 = %lf\n",((2.0*TMath::Pi())/phase2));
      
      /*if ((195.0 < period2) && (period2 < 215.0)) {
         if (((-period2) < phase2) && (phase2 < 0.0)) {
            phase2 = (period2 + phase2) ;
         } else if ((period2 < phase2) && (phase2 < (2*period2))) {
            phase2 = (phase2 - period2) ;
         } else {
            phase2 =  phase2 ;
         }
      } else if (((-215.0) < period2) && (period2 < (-195.0))) {
         if ((period2 < phase2) && (phase2 < 0.0)) {
            phase2 = ((-period2) + phase2) ;
         } else if (((-period2) < phase2) && (phase2 < (2*(-period2)))) {
            phase2 = (phase2 + period2) ;
         } else {
            phase2 =  phase2 ;
         }
      } else {
         f1->SetParameters(0,400,0.0306,50);
         f1->SetParLimits(1,390,410);
         //f1->SetParLimits(2,0.029,0.032);
         f1->SetParLimits(3,-200,200);
         g1->Fit("f1","","",50,500);
         amp2    = g1->GetFunction("f1")->GetParameter(1);
         freq2   = g1->GetFunction("f1")->GetParameter(2);
         phase2  = g1->GetFunction("f1")->GetParameter(3);
         period2 = ((2.0*pai) / freq2);
         if ((195.0 < period2) && (period2< 215.0)) {
            if (((-period2) < phase2) && (phase2 < 0.0)) {
               phase2 = (period2 + phase2) ;
            } else if ((period2 < phase2) && (phase2 < (2*period2))) {
               phase2 = (phase2 - period2) ;
            } else {
               phase2 =  phase2 ;
            }
         } else if (((-215.0) < period2) && (period2 < (-195.0))) {
            if ((period2 < phase2) && (phase2 < 0.0)) {
               phase2 = ((-period2) + phase2) ;
            } else if (((-period2) < phase2) && (phase2 < (2*(-period2)))) {
               phase2 = (phase2 + period2) ;
            } else {
               phase2 =  phase2 ;
            }
         } else {
            f1->SetParameters(0,400,0.0306,100);
            f1->SetParLimits(1,390,410);
            //f1->SetParLimits(2,0.029,0.032);
            f1->SetParLimits(3,-200,200);
            g1->Fit("f1","","",50,500);
            amp2    = g1->GetFunction("f1")->GetParameter(1);
            freq2   = g1->GetFunction("f1")->GetParameter(2);
            phase2  = g1->GetFunction("f1")->GetParameter(3);
            period2 = ((2.0*pai) / freq2);
            if ((195.0 < period2) && (period2< 215.0)) {
               if (((-period2) < phase2) && (phase2 < 0.0)) {
                  phase2 = (period2 + phase2) ;
               } else if ((period2 < phase2) && (phase2 < (2*period2))) {
                  phase2 = (phase2 - period2) ;
               } else {
                  phase2 =  phase2 ;
               }
            } else if (((-215.0) < period2) && (period2 < (-195.0))) {
               if ((period2 < phase2) && (phase2 < 0.0)) {
                  phase2 = ((-period2) + phase2) ;
               } else if (((-period2) < phase2) && (phase2 < (2*(-period2)))) {
                  phase2 = (phase2 + period2) ;
               } else {
                  phase2 =  phase2 ;
               }
            } else {
               f1->SetParameters(0,400,0.0306,150);
               f1->SetParLimits(1,390,410);
               //f1->SetParLimits(2,0.029,0.032);
               f1->SetParLimits(3,-200,200);
               g1->Fit("f1","","",50,500);
               amp2    = g1->GetFunction("f1")->GetParameter(1);
               freq2   = g1->GetFunction("f1")->GetParameter(2);
               phase2  = g1->GetFunction("f1")->GetParameter(3);
               period2 = ((2.0*pai) / freq2);
               if ((195.0 < period2) && (period2< 215.0)) {
                  if (((-period2) < phase2) && (phase2 < 0.0)) {
                     phase2 = (period2 + phase2) ;
                  } else if ((period2 < phase2) && (phase2 < (2*period2))) {
                     phase2 = (phase2 - period2) ;
                  } else {
                     phase2 =  phase2 ;
                  }
               } else if (((-215.0) < period2) && (period2 < (-195.0))) {
                  if ((period2 < phase2) && (phase2 < 0.0)) {
                     phase2 = ((-period2) + phase2) ;
                  } else if (((-period2) < phase2) && (phase2 < (2*(-period2)))) {
                     phase2 = (phase2 + period2) ;
                  } else {
                     phase2 =  phase2 ;
                  }
               } else {
                     phase2 =  310.0 ;
               }
            }
         }
      }*/
            
      /*c2->cd(2);
      g1->Draw("A*");
      
      TGraph *g1 = new TGraph(2,wave,time);
      g1->Fit("pol1");
      TF1 *func1;
      func1 = g1->GetFunction("pol1");
      chip1_zero_time = func1->Eval(0);
      printf("chip1_zero_time %lf \n",chip1_zero_time);*/
      
      /* Chip2 Zero Point Search */
      /*next_high = 0;
      next_low  = 0;
      
      if (chip2_wave[1]<0.0) {
         next_high = 1;
      } else if (chip2_wave[1]>0.0) {
         next_low = 1;
      }
      
      if (next_high==1) {
         for (int i=0; i<1000; i++) {
            wave[0] = chip2_wave[i];
            wave[1] = chip2_wave[i+1];
            time[0] = i;
            time[1] = i+1;
            if (wave[1]>0.0) {
               break;
            }
         }
      } else if (next_low==1) {
         for (int i=0; i<1000; i++) {
            wave[0] = chip2_wave[i];
            wave[1] = chip2_wave[i+1];
            time[0] = i;
            time[1] = i+1;
            if (wave[1]<0.0) {
               break;
            }
         }
      } else {
         chip2_zero_time = 1.0;
      }
      
      TGraph *g2 = new TGraph(2,wave,time);
      g2->Fit("pol1");
      g2->Draw("A*");
      TF1 *func2;
      func2 = g2->GetFunction("pol1");
      chip2_zero_time = func2->Eval(0);
      printf("chip2_zero_time %lf \n",chip2_zero_time);*/

      if ((phase1==1000.0) || (phase2==1000.0)) {
         correct_val = 100.0;
      } else {
         correct_val = phase1 - phase2;
      }
      
      abs_period1 = fabs(period1);
      abs_period2 = fabs(period2);
      
      if (correct_val>170.0) {
         correct_val = phase1 - phase2 - abs_period2;
      } else if (correct_val<(-170.0)) {
         correct_val = phase1 - phase2 + abs_period1;
      } else if (correct_val>50.0) {
         correct_val = phase1 - phase2 - (abs_period1/2.0);
      } else if (correct_val<(-50.0)) {
         correct_val = phase1 - phase2 + (abs_period2/2.0);
      } else {
         correct_val = correct_val;
      }
      
      t.Fill();
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
   }
   
   fclose(fp);
   t.SetAlias("time","Iteration$");
   t.SetAlias("Eve","Entry$");
   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s_tim.root",run_number);
   
   TFile file(rootfile,"recreate");
   t.Write();
   file.Close();
}
