
void CrosstalkComp(char *fname1,char *fname2)
{

   double ch[16];
   double ch_error[16];

   for (int i=0; i<16; i++) {
      ch[i]       = (double)(i+1);
      ch_error[i] = 0.0;
   }

   double Min_Mean1[16];
   double Min_RMS1[16];
   double Max_Mean1[16];
   double Max_RMS1[16];

   FILE *fp1 = fopen(fname1,"r+");
   char line[512];
   int j=0;

   while(fgets(line,sizeof(line),fp1)) {
      if (j==0) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_Mean1[0], &Min_Mean1[1], &Min_Mean1[2],  &Min_Mean1[3],  &Min_Mean1[4],  &Min_Mean1[5],  &Min_Mean1[6],  &Min_Mean1[7]);
      } else if (j==1) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_RMS1[0],  &Min_RMS1[1],  &Min_RMS1[2],   &Min_RMS1[3],   &Min_RMS1[4],   &Min_RMS1[5],   &Min_RMS1[6],   &Min_RMS1[7]);
      } else if (j==2) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_Mean1[8], &Min_Mean1[9], &Min_Mean1[10], &Min_Mean1[11], &Min_Mean1[12], &Min_Mean1[13], &Min_Mean1[14], &Min_Mean1[15]);
      } else if (j==3) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_RMS1[8],  &Min_RMS1[9],  &Min_RMS1[10],  &Min_RMS1[11],  &Min_RMS1[12],  &Min_RMS1[13],  &Min_RMS1[14],  &Min_RMS1[15]);
      } else if (j==4) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_Mean1[0], &Max_Mean1[1], &Max_Mean1[2],  &Max_Mean1[3],  &Max_Mean1[4],  &Max_Mean1[5],  &Max_Mean1[6],  &Max_Mean1[7]);
      } else if (j==5) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_RMS1[0],  &Max_RMS1[1],  &Max_RMS1[2],   &Max_RMS1[3],   &Max_RMS1[4],   &Max_RMS1[5],   &Max_RMS1[6],   &Max_RMS1[7]);
      } else if (j==6) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_Mean1[8], &Max_Mean1[9], &Max_Mean1[10], &Max_Mean1[11], &Max_Mean1[12], &Max_Mean1[13], &Max_Mean1[14], &Max_Mean1[15]);
      } else if (j==7) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_RMS1[8],  &Max_RMS1[9],  &Max_RMS1[10],  &Max_RMS1[11],  &Max_RMS1[12],  &Max_RMS1[13],  &Max_RMS1[14],  &Max_RMS1[15]);
      }
      j++;
   }


   double Min_Mean2[16];
   double Min_RMS2[16];
   double Max_Mean2[16];
   double Max_RMS2[16];

   FILE *fp2 = fopen(fname2,"r+");
   j=0;

   while(fgets(line,sizeof(line),fp2)) {
      if (j==0) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_Mean2[0], &Min_Mean2[1], &Min_Mean2[2],  &Min_Mean2[3],  &Min_Mean2[4],  &Min_Mean2[5],  &Min_Mean2[6],  &Min_Mean2[7]);
      } else if (j==1) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_RMS2[0],  &Min_RMS2[1],  &Min_RMS2[2],   &Min_RMS2[3],   &Min_RMS2[4],   &Min_RMS2[5],   &Min_RMS2[6],   &Min_RMS2[7]);
      } else if (j==2) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_Mean2[8], &Min_Mean2[9], &Min_Mean2[10], &Min_Mean2[11], &Min_Mean2[12], &Min_Mean2[13], &Min_Mean2[14], &Min_Mean2[15]);
      } else if (j==3) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Min_RMS2[8],  &Min_RMS2[9],  &Min_RMS2[10],  &Min_RMS2[11],  &Min_RMS2[12],  &Min_RMS2[13],  &Min_RMS2[14],  &Min_RMS2[15]);
      } else if (j==4) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_Mean2[0], &Max_Mean2[1], &Max_Mean2[2],  &Max_Mean2[3],  &Max_Mean2[4],  &Max_Mean2[5],  &Max_Mean2[6],  &Max_Mean2[7]);
      } else if (j==5) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_RMS2[0],  &Max_RMS2[1],  &Max_RMS2[2],   &Max_RMS2[3],   &Max_RMS2[4],   &Max_RMS2[5],   &Max_RMS2[6],   &Max_RMS2[7]);
      } else if (j==6) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_Mean2[8], &Max_Mean2[9], &Max_Mean2[10], &Max_Mean2[11], &Max_Mean2[12], &Max_Mean2[13], &Max_Mean2[14], &Max_Mean2[15]);
      } else if (j==7) {
         sscanf(line,"%lf %lf %lf %lf %lf %lf %lf %lf", &Max_RMS2[8],  &Max_RMS2[9],  &Max_RMS2[10],  &Max_RMS2[11],  &Max_RMS2[12],  &Max_RMS2[13],  &Max_RMS2[14],  &Max_RMS2[15]);
      }
      j++;
   }

   for (int i=0; i<16; i++) {
      Min_RMS1[i] = (double)(Min_RMS1[i] / sqrt(1000)) ;
      Min_RMS2[i] = (double)(Min_RMS2[i] / sqrt(1000)) ;
      Max_RMS1[i] = (double)(Max_RMS1[i] / sqrt(1000)) ;
      Max_RMS2[i] = (double)(Max_RMS2[i] / sqrt(1000)) ;
   }

// printf("%lf %lf %lf %lf %lf %lf %lf %lf\n", Min_Mean1[0], Min_Mean1[1], Min_Mean1[2],  Min_Mean1[3],  Min_Mean1[4],  Min_Mean1[5],  Min_Mean1[6],  Min_Mean1[7]);
// printf("%lf %lf %lf %lf %lf %lf %lf %lf\n", Min_RMS1[0], Min_RMS1[1], Min_RMS1[2],  Min_RMS1[3],  Min_RMS1[4],  Min_RMS1[5],  Min_RMS1[6],  Min_RMS1[7]);

   TGraphErrors *gr1 = new TGraphErrors(16,ch,Min_Mean1,ch_error,Min_RMS1);
   TGraphErrors *gr2 = new TGraphErrors(16,ch,Max_Mean1,ch_error,Max_RMS1);

   TGraphErrors *gr3 = new TGraphErrors(16,ch,Min_Mean2,ch_error,Min_RMS2);
   TGraphErrors *gr4 = new TGraphErrors(16,ch,Max_Mean2,ch_error,Max_RMS2);

   TCanvas *c5 = new TCanvas("c5","c5",1400,700);
   c5->Divide(2,1);
// c5->SetLeftMargin(0.15);
   c5->SetGrid();

   c5->cd(1);
   gr1->SetLineColor(4);
   gr1->SetMarkerColor(4);
   gr1->SetTitle("Crosstalk Min Peak");
   gr1->GetXaxis()->SetTitle("ch");
   gr1->GetYaxis()->SetTitle("volt [mV]");
   gr1->GetYaxis()->SetTitleOffset(1.5);
   gr1->Draw("A*");

   gr3->SetLineColor(2);
   gr3->SetMarkerColor(2);
   gr3->Draw("*");

   c5->cd(2);
   gr2->SetLineColor(4);
   gr2->SetMarkerColor(4);
   gr2->SetTitle("Crosstalk Max Peak");
   gr2->GetXaxis()->SetTitle("ch");
   gr2->GetYaxis()->SetTitle("volt [mV]");
   gr2->GetYaxis()->SetTitleOffset(1.5);
   gr2->Draw("A*");

   gr4->SetLineColor(2);
   gr4->SetMarkerColor(2);
   gr4->Draw("*");

   fclose(fp1);

}
