
void PedestalWaveROI(char *run_number){

   gROOT->Reset();

   char filename[32];
   sprintf(filename,"../raw_data/%s.dat",run_number);

   FILE *fp;
   if ((fp = fopen(filename,"rb+"))==NULL){
      printf("File open Error\n");
      return -1;
   }
   
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];
   unsigned double tmp_data[1024];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;
   
   TH1F *h1[1024];
   TH1F *h2[1024];
   TH1F *h3[1024];
   TH1F *h4[1024];
   TH1F *h5[1024];
   TH1F *h6[1024];
   TH1F *h7[1024];
   TH1F *h8[1024];
   TH1F *h9[1024];
   TH1F *h10[1024];
   TH1F *h11[1024];
   TH1F *h12[1024];
   TH1F *h13[1024];
   TH1F *h14[1024];
   TH1F *h15[1024];
   TH1F *h16[1024];

   for (int m=0; m<1024; m++){
      h1[m]  = new TH1F(Form("h1_%dth",m), Form("hist1_%dth",m), 4096,-2048,2048);
      h2[m]  = new TH1F(Form("h2_%dth",m), Form("hist2_%dth",m), 4096,-2048,2048);
      h3[m]  = new TH1F(Form("h3_%dth",m), Form("hist3_%dth",m), 4096,-2048,2048);
      h4[m]  = new TH1F(Form("h4_%dth",m), Form("hist4_%dth",m), 4096,-2048,2048);
      h5[m]  = new TH1F(Form("h5_%dth",m), Form("hist5_%dth",m), 4096,-2048,2048);
      h6[m]  = new TH1F(Form("h6_%dth",m), Form("hist6_%dth",m), 4096,-2048,2048);
      h7[m]  = new TH1F(Form("h7_%dth",m), Form("hist7_%dth",m), 4096,-2048,2048);
      h8[m]  = new TH1F(Form("h8_%dth",m), Form("hist8_%dth",m), 4096,-2048,2048);
      h9[m]  = new TH1F(Form("h9_%dth",m), Form("hist9_%dth",m), 4096,-2048,2048);
      h10[m] = new TH1F(Form("h10_%dth",m),Form("hist10_%dth",m),4096,-2048,2048);
      h11[m] = new TH1F(Form("h11_%dth",m),Form("hist11_%dth",m),4096,-2048,2048);
      h12[m] = new TH1F(Form("h12_%dth",m),Form("hist12_%dth",m),4096,-2048,2048);
      h13[m] = new TH1F(Form("h13_%dth",m),Form("hist13_%dth",m),4096,-2048,2048);
      h14[m] = new TH1F(Form("h14_%dth",m),Form("hist14_%dth",m),4096,-2048,2048);
      h15[m] = new TH1F(Form("h15_%dth",m),Form("hist15_%dth",m),4096,-2048,2048);
      h16[m] = new TH1F(Form("h16_%dth",m),Form("hist16_%dth",m),4096,-2048,2048);
   }

   TH1F *stop_hist1 = new TH1F("stop_hist1", "stop_hist1", 1024,0,1024);
   TH1F *stop_hist2 = new TH1F("stop_hist2", "stop_hist2", 1024,0,1024);

   printf("Making Histgram finished\n");
   
   int k;

   double alldata1;
   double alldata2;
   double alldata3;
   double alldata4;
   double alldata5;
   double alldata6;
   double alldata7;
   double alldata8;
   double alldata9;
   double alldata10;
   double alldata11;
   double alldata12;
   double alldata13;
   double alldata14;
   double alldata15;
   double alldata16;

   double meandata1;
   double meandata2;
   double meandata3;
   double meandata4;
   double meandata5;
   double meandata6;
   double meandata7;
   double meandata8;
   double meandata9;
   double meandata10;
   double meandata11;
   double meandata12;
   double meandata13;
   double meandata14;
   double meandata15;
   double meandata16;
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
            
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Data Packet Read */
      hitnum = Length/2060;
      int cap_point;
      
      for (int i=0; i<hitnum; i++) {
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,data_length,fp);
         
         alldata1  = 0.0;
         alldata2  = 0.0;
         alldata3  = 0.0;
         alldata4  = 0.0;
         alldata5  = 0.0;
         alldata6  = 0.0;
         alldata7  = 0.0;
         alldata8  = 0.0;
         alldata9  = 0.0;
         alldata10 = 0.0;
         alldata11 = 0.0;
         alldata12 = 0.0;
         alldata13 = 0.0;
         alldata14 = 0.0;
         alldata15 = 0.0;
         alldata16 = 0.0;

         if (ch_num==0) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata1            = alldata1 + tmp_data[cap_point] ;
               }
            }
            meandata1 = alldata1 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h1[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata1);
                  } else {
                     h1[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata1);
                  }
               }
            }
         } else if (ch_num==1) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata2            = alldata2 + tmp_data[cap_point] ;
               }
            }
            meandata2 = alldata2 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h2[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata2);
                  } else {
                     h2[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata2);
                  }
               }
            }
         } else if (ch_num==2) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata3            = alldata3 + tmp_data[cap_point] ;
               }
            }
            meandata3 = alldata3 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h3[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata3);
                  } else {
                     h3[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata3);
                  }
               }
            }
         } else if (ch_num==3) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata4            = alldata4 + tmp_data[cap_point] ;
               }
            }
            meandata4 = alldata4 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h4[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata4);
                  } else {
                     h4[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata4);
                  }
               }
            }
         } else if (ch_num==4) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata5            = alldata5 + tmp_data[cap_point] ;
               }
            }
            meandata5 = alldata5 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h5[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata5);
                  } else {
                     h5[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata5);
                  }
               }
            }
         } else if (ch_num==5) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata6            = alldata6 + tmp_data[cap_point] ;
               }
            }
            meandata6 = alldata6 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h6[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata6);
                  } else {
                     h6[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata6);
                  }
               }
            }
         } else if (ch_num==6) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata7            = alldata7 + tmp_data[cap_point] ;
               }
            }
            meandata7 = alldata7 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h7[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata7);
                  } else {
                     h7[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata7);
                  }
               }
            }
         } else if (ch_num==7) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata8            = alldata8 + tmp_data[cap_point] ;
               }
            }
            meandata8 = alldata8 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h8[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata8);
                  } else {
                     h8[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata8);
                  }
               }
            }
         } else if (ch_num==8) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata9            = alldata9 + tmp_data[cap_point] ;
               }
            }
            meandata9 = alldata9 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h9[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata9);
                  } else {
                     h9[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata9);
                  }
               }
            }
         } else if (ch_num==9) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata10           = alldata10 + tmp_data[cap_point] ;
               }
            }
            meandata10 = alldata10 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h10[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata10);
                  } else {
                     h10[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata10);
                  }
               }
            }
         } else if (ch_num==10) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata11           = alldata11 + tmp_data[cap_point] ;
               }
            }
            meandata11 = alldata11 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h11[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata11);
                  } else {
                     h11[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata11);
                  }
               }
            }
         } else if (ch_num==11) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata12           = alldata12 + tmp_data[cap_point] ;
               }
            }
            meandata12 = alldata12 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h12[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata12);
                  } else {
                     h12[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata12);
                  }
               }
            }
         } else if (ch_num==12) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata13           = alldata13 + tmp_data[cap_point] ;
               }
            }
            meandata13 = alldata13 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h13[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata13);
                  } else {
                     h13[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata13);
                  }
               }
            }
         } else if (ch_num==13) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata14           = alldata14 + tmp_data[cap_point] ;
               }
            }
            meandata14 = alldata14 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h14[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata14);
                  } else {
                     h14[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata14);
                  }
               }
            }
         } else if (ch_num==14) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata15           = alldata15 + tmp_data[cap_point] ;
               }
            }
            meandata15 = alldata15 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h15[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata15);
                  } else {
                     h15[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata15);
                  }
               }
            }
         } else if (ch_num==15) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               if ((4<n)&&(n<1005)) {
                  tmp_data[cap_point] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
                  alldata16           = alldata16 + tmp_data[cap_point] ;
               }
            }
            meandata16 = alldata16 / 1000.0 ;
            if (EventID!=1) {
               for (int j=5; j<1005; j++) {
                  if ((j+stop_ch)>=1024) {
                     h16[j+stop_ch-1024]->Fill(tmp_data[j+stop_ch-1024]-meandata16);
                  } else {
                     h16[j+stop_ch]->Fill(tmp_data[j+stop_ch]-meandata16);
                  }
               }
            }
         }
         
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         if (ch_num==7) {
            stop_hist1->Fill(stop_ch);
         }
         if (ch_num==15) {
            stop_hist2->Fill(stop_ch);
         }
      }
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      k = k + 1;
      if ((k%100)==0) {
         printf("%d times finished\n",k);
      }
   }

   fclose(fp);
   
   int x1[1024];
   int x2[1024];
   int x3[1024];
   int x4[1024];
   int x5[1024];
   int x6[1024];
   int x7[1024];
   int x8[1024];
   int x9[1024];
   int x10[1024];
   int x11[1024];
   int x12[1024];
   int x13[1024];
   int x14[1024];
   int x15[1024];
   int x16[1024];
   
   for(int l=0; l<1024; l=l+1){
      x1[l]=h1[l]->GetMean();
//      x1_error[l]=h1[l]->GetRMS();
//      h1[l]->Fit("gaus","","",1500,2000);
//      h1[l]->Fit("gaus");
//      x1[l]=h1[l]->GetFunction("gaus")->GetParameter(1);
      x2[l]=h2[l]->GetMean();
//      x2_error[l]=h2[l]->GetRMS();
//      h2[l]->Fit("gaus","","",1500,2000);
//      h2[l]->Fit("gaus");
//      x2[l]=h2[l]->GetFunction("gaus")->GetParameter(1);
      x3[l]=h3[l]->GetMean();
//      x3_error[l]=h3[l]->GetRMS();
//      h3[l]->Fit("gaus","","",1500,2000);
//      h3[l]->Fit("gaus");
//      x3[l]=h3[l]->GetFunction("gaus")->GetParameter(1);
      x4[l]=h4[l]->GetMean();
//      x4_error[l]=h4[l]->GetRMS();
//      h4[l]->Fit("gaus","","",1500,2000);
//      h4[l]->Fit("gaus");
//      x4[l]=h4[l]->GetFunction("gaus")->GetParameter(1);
      x5[l]=h5[l]->GetMean();
//      x5_error[l]=h5[l]->GetRMS();
//      h5[l]->Fit("gaus","","",1500,2000);
//      h5[l]->Fit("gaus");
//      x5[l]=h5[l]->GetFunction("gaus")->GetParameter(1);
      x6[l]=h6[l]->GetMean();
//      x6_error[l]=h6[l]->GetRMS();
//      h6[l]->Fit("gaus","","",1500,2000);
//      h6[l]->Fit("gaus");
//      x6[l]=h6[l]->GetFunction("gaus")->GetParameter(1);
      x7[l]=h7[l]->GetMean();
//      x7_error[l]=h7[l]->GetRMS();
//      h7[l]->Fit("gaus","","",1500,2000);
//      h7[l]->Fit("gaus");
//      x7[l]=h7[l]->GetFunction("gaus")->GetParameter(1);
      x8[l]=h8[l]->GetMean();
//      x8_error[l]=h8[l]->GetRMS();
//      h8[l]->Fit("gaus","","",1500,2000);
//      h8[l]->Fit("gaus");
//      x8[l]=h8[l]->GetFunction("gaus")->GetParameter(1);
      x9[l]=h9[l]->GetMean();
//      x9_error[l]=h9[l]->GetRMS();
//      h9[l]->Fit("gaus","","",1500,2000);
//      h9[l]->Fit("gaus");
//      x9[l]=h9[l]->GetFunction("gaus")->GetParameter(1);
      x10[l]=h10[l]->GetMean();
//      x10_error[l]=h10[l]->GetRMS();
//      h10[l]->Fit("gaus","","",1500,2000);
//      h10[l]->Fit("gaus");
//      x10[l]=h10[l]->GetFunction("gaus")->GetParameter(1);
      x11[l]=h11[l]->GetMean();
//      x11_error[l]=h11[l]->GetRMS();
//      h11[l]->Fit("gaus","","",1500,2000);
//      h11[l]->Fit("gaus");
//      x11[l]=h11[l]->GetFunction("gaus")->GetParameter(1);
      x12[l]=h12[l]->GetMean();
//      x12_error[l]=h12[l]->GetRMS();
//      h12[l]->Fit("gaus","","",1500,2000);
//      h12[l]->Fit("gaus");
//      x12[l]=h12[l]->GetFunction("gaus")->GetParameter(1);
      x13[l]=h13[l]->GetMean();
//      x13_error[l]=h13[l]->GetRMS();
//      h13[l]->Fit("gaus","","",1500,2000);
//      h13[l]->Fit("gaus");
//      x13[l]=h13[l]->GetFunction("gaus")->GetParameter(1);
      x14[l]=h14[l]->GetMean();
//      x14_error[l]=h14[l]->GetRMS();
//      h14[l]->Fit("gaus","","",1500,2000);
//      h14[l]->Fit("gaus");
//      x14[l]=h14[l]->GetFunction("gaus")->GetParameter(1);
      x15[l]=h15[l]->GetMean();
//      x15_error[l]=h15[l]->GetRMS();
//      h15[l]->Fit("gaus","","",1500,2000);
//      h15[l]->Fit("gaus");
//      x15[l]=h15[l]->GetFunction("gaus")->GetParameter(1);
      x16[l]=h16[l]->GetMean();
//      x16_error[l]=h16[l]->GetRMS();
//      h16[l]->Fit("gaus","","",1500,2000);
//      h16[l]->Fit("gaus");
//      x16[l]=h16[l]->GetFunction("gaus")->GetParameter(1);
   }
   
   int time[1024];
   
   for (int i=0; i<1024; i++) {
      time[i] = i;
   }
   
   TGraph *pedgr1  = new TGraph(1024,time,x1);
   TGraph *pedgr2  = new TGraph(1024,time,x2);
   TGraph *pedgr3  = new TGraph(1024,time,x3);
   TGraph *pedgr4  = new TGraph(1024,time,x4);
   TGraph *pedgr5  = new TGraph(1024,time,x5);
   TGraph *pedgr6  = new TGraph(1024,time,x6);
   TGraph *pedgr7  = new TGraph(1024,time,x7);
   TGraph *pedgr8  = new TGraph(1024,time,x8);
   TGraph *pedgr9  = new TGraph(1024,time,x9);
   TGraph *pedgr10 = new TGraph(1024,time,x10);
   TGraph *pedgr11 = new TGraph(1024,time,x11);
   TGraph *pedgr12 = new TGraph(1024,time,x12);
   TGraph *pedgr13 = new TGraph(1024,time,x13);
   TGraph *pedgr14 = new TGraph(1024,time,x14);
   TGraph *pedgr15 = new TGraph(1024,time,x15);
   TGraph *pedgr16 = new TGraph(1024,time,x16);
   
/* TCanvas *c1;
   c1 = new TCanvas("c1","Pedestal Check1",1400,800);
   c1->SetLeftMargin(0.15);
   c1->SetGrid();
   c1->Divide(4,2);
   
   TCanvas *c2;
   c2 = new TCanvas("c4","Pedestal Check2",1400,800);
   c2->SetLeftMargin(0.15);
   c2->SetGrid();
   c2->Divide(4,2);
   
   c1->cd(1);
   pedgr1->SetLineColor(2);
   pedgr1->Draw("AL");

   c1->cd(2);
   pedgr2->SetLineColor(2);
   pedgr2->Draw("AL");

   c1->cd(3);
   pedgr3->SetLineColor(2);
   pedgr3->Draw("AL");

   c1->cd(4);
   pedgr4->SetLineColor(2);
   pedgr4->Draw("AL");

   c1->cd(5);
   pedgr5->SetLineColor(2);
   pedgr5->Draw("AL");

   c1->cd(6);
   pedgr6->SetLineColor(2);
   pedgr6->Draw("AL");

   c1->cd(7);
   pedgr7->SetLineColor(2);
   pedgr7->Draw("AL");

   c1->cd(8);
   pedgr8->SetLineColor(2);
   pedgr8->Draw("AL");

   c2->cd(1);
   pedgr9->SetLineColor(2);
   pedgr9->Draw("AL");

   c2->cd(2);
   pedgr10->SetLineColor(2);
   pedgr10->Draw("AL");

   c2->cd(3);
   pedgr11->SetLineColor(2);
   pedgr11->Draw("AL");

   c2->cd(4);
   pedgr12->SetLineColor(2);
   pedgr12->Draw("AL");

   c2->cd(5);
   pedgr13->SetLineColor(2);
   pedgr13->Draw("AL");

   c2->cd(6);
   pedgr14->SetLineColor(2);
   pedgr14->Draw("AL");

   c2->cd(7);
   pedgr15->SetLineColor(2);
   pedgr15->Draw("AL");

   c2->cd(8);
   pedgr16->SetLineColor(2);
   pedgr16->Draw("AL");*/
   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s_ped.root",run_number);
   
   TFile file(rootfile,"recreate");
   
   for (int i=0; i<1024; i++) {
      h1[i]->Write(Form("ch1_%d",i));
      h2[i]->Write(Form("ch2_%d",i));
      h3[i]->Write(Form("ch3_%d",i));
      h4[i]->Write(Form("ch4_%d",i));
      h5[i]->Write(Form("ch5_%d",i));
      h6[i]->Write(Form("ch6_%d",i));
      h7[i]->Write(Form("ch7_%d",i));
      h8[i]->Write(Form("ch8_%d",i));
      h9[i]->Write(Form("ch9_%d",i));
      h10[i]->Write(Form("ch10_%d",i));
      h11[i]->Write(Form("ch11_%d",i));
      h12[i]->Write(Form("ch12_%d",i));
      h13[i]->Write(Form("ch13_%d",i));
      h14[i]->Write(Form("ch14_%d",i));
      h15[i]->Write(Form("ch15_%d",i));
      h16[i]->Write(Form("ch16_%d",i));
      
      if ((i%100)==0) {
         printf("%d times hist write\n",i);
      }
   }

/* c1->Write("canvas_c1");
   c2->Write("canvas_c2");*/

   pedgr1->Write("ped_graph1");
   pedgr2->Write("ped_graph2");
   pedgr3->Write("ped_graph3");
   pedgr4->Write("ped_graph4");
   pedgr5->Write("ped_graph5");
   pedgr6->Write("ped_graph6");
   pedgr7->Write("ped_graph7");
   pedgr8->Write("ped_graph8");
   pedgr9->Write("ped_graph9");
   pedgr10->Write("ped_graph10");
   pedgr11->Write("ped_graph11");
   pedgr12->Write("ped_graph12");
   pedgr13->Write("ped_graph13");
   pedgr14->Write("ped_graph14");
   pedgr15->Write("ped_graph15");
   pedgr16->Write("ped_graph16");

   printf("pedestal graph write\n");
   
   file.Close();
   
/* double read_xtmp[1024];
   double read_ytmp[1024];

   for (int i=0; i<1024; i++) {
      pedgr1->GetPoint(i,read_xtmp[i],read_ytmp[i]);
   }

   TCanvas *c1;
   c1 = new TCanvas("c1","Pedestal Check1",1400,800);
   c1->SetLeftMargin(0.15);
   c1->SetGrid();
   c1->Divide(2,1);
   
   c1->cd(1);
   TGraph *read_pedgr1 = new TGraph(1024,read_xtmp,read_ytmp);
   read_pedgr1->SetLineColor(2);
   read_pedgr1->Draw("AL");
   
   c1->cd(2);
   pedgr1->SetLineColor(3);
   pedgr1->Draw("AL SAME");*/
   
}
