
void TemplateFit(char *ped_number,char *run_number){

   gROOT->Reset();
   
   char filename[40];
   sprintf(filename,"../Root_File/%s_ped.root",ped_number);
   
   TFile file1(filename);
   
   double ch1_pedy[1024];
   double ch2_pedy[1024];
   double ch3_pedy[1024];
   double ch4_pedy[1024];
   double ch5_pedy[1024];
   double ch6_pedy[1024];
   double ch7_pedy[1024];
   double ch8_pedy[1024];
   double ch9_pedy[1024];
   double ch10_pedy[1024];
   double ch11_pedy[1024];
   double ch12_pedy[1024];
   double ch13_pedy[1024];
   double ch14_pedy[1024];
   double ch15_pedy[1024];
   double ch16_pedy[1024];
   
   for (int i=0; i<1024; i++) {
      ch1_pedy[i]  = ped_graph1->Eval(i,0,"");
      ch2_pedy[i]  = ped_graph2->Eval(i,0,"");
      ch3_pedy[i]  = ped_graph3->Eval(i,0,"");
      ch4_pedy[i]  = ped_graph4->Eval(i,0,"");
      ch5_pedy[i]  = ped_graph5->Eval(i,0,"");
      ch6_pedy[i]  = ped_graph6->Eval(i,0,"");
      ch7_pedy[i]  = ped_graph7->Eval(i,0,"");
      ch8_pedy[i]  = ped_graph8->Eval(i,0,"");
      ch9_pedy[i]  = ped_graph9->Eval(i,0,"");
      ch10_pedy[i] = ped_graph10->Eval(i,0,"");
      ch11_pedy[i] = ped_graph11->Eval(i,0,"");
      ch12_pedy[i] = ped_graph12->Eval(i,0,"");
      ch13_pedy[i] = ped_graph13->Eval(i,0,"");
      ch14_pedy[i] = ped_graph14->Eval(i,0,"");
      ch15_pedy[i] = ped_graph15->Eval(i,0,"");
      ch16_pedy[i] = ped_graph16->Eval(i,0,"");
      
      if (((i+1)%100)==0) {
         printf("%d times pedestal data read\n",i+1);
      }
   }
      
   file1.Close();

   char filename2[32];
   sprintf(filename2,"../raw_data/%s.dat",run_number);

   FILE *fp;
   if ((fp = fopen(filename2,"rb+"))==NULL){
      printf("File open Error\n");
      exit(1);
   }
   
   TTree t("t","t");

   double time1[1024];
   double data1[1024];
   double data7[1024];
   
   t.Branch("time1", time1, "time1[1024]/D");
   t.Branch("data1", data1, "data1[1024]/D");
   t.Branch("data7", data7, "data7[1024]/D");

   double adj_data1[1024];
   double adj_data7[1024];

   t.Branch("adj_data1", adj_data1, "adj_data1[1024]/D");
   t.Branch("adj_data7", adj_data7, "adj_data7[1024]/D");
   
   double tmp_data;

   double baseline1;
   double baseline7;

   TH1F *base_hist1 = new TH1F("base_hist1","base_hist1",2000,0,1000);
   TH1F *base_hist7 = new TH1F("base_hist7","base_hist7",2000,0,1000);

   double time2[200];
// t.Branch("time2", time2, "time2[1024]/D");

   TH1F *template_hist1[200];
   TH1F *template_hist7[200];

   for (int i=0; i<200; i++) {
      template_hist1[i] = new TH1F(Form("template_hist1_%d",i),Form("template_hist1_%d",i),1400,-400,300);
      template_hist7[i] = new TH1F(Form("template_hist7_%d",i),Form("template_hist7_%d",i),1400,-400,300);
   }
   
   double template_data1[200];
   double template_data7[200];
   
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;
   int cap_point;

   for (int i=0; i<1024; i++) {
      time1[i] = (double)((i*1920.0)/2048.0) ;
   }

   for (int i=0; i<200; i++) {
      time2[i] = (double)((i*1920.0)/2048.0) ;
   }

   int n;
 
   double min_peak;
   int peak_j;
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
      
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Data Packet Read */
      hitnum = Length/2060;
      
      for (int i=0; i<hitnum; i++) {         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,data_length,fp);
         min_peak = 0.0;
         peak_j   = 0;
         
         if (ch_num==0) {
            for (int j=0; j<readnum; j=j+2) {
               n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data1[n] = (tmp_data - ch1_pedy[cap_point]) * (1000.0 / 4096.0);
               base_hist1->Fill(data1[n]);
            }
            base_hist1->Fit("gaus","","",350,450);
            baseline1 = base_hist1->GetFunction("gaus")->GetParameter(1);
            for (int j=0; j<1024; j++) {
               adj_data1[j] = data1[j] - baseline1 ;
               if (j>150) {
                  if (min_peak > adj_data1[j]) {
                     min_peak = adj_data1[j];
                     peak_j   = j;
                  }
               }
            }
            if ((70<=peak_j)&&(peak_j<890)) {
               for (int j=0; j<60; j++) {
                  template_hist1[j]->Fill(adj_data1[peak_j-25+j]);
               }
            }
         } else if (ch_num==6) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data7[n] = (tmp_data - ch7_pedy[cap_point]) * (1000.0 / 4096.0);
               if (time1[n]<400.0) {
                  base_hist7->Fill(data7[n]);
               }
            }
            base_hist7->Fit("gaus","","",350,420);
            baseline7 = base_hist7->GetFunction("gaus")->GetParameter(1);
            for (int j=0; j<1024; j++) {
               adj_data7[j] = data7[j] - baseline7 ;
               if (j>400) {
                  if (min_peak > adj_data7[j]) {
                     min_peak = adj_data7[j];
                     peak_j   = j;
                  } 
               }
            }
            if ((70<peak_j)&&(peak_j<890)) {
               for (int j=0; j<60; j++) {
                  template_hist7[j]->Fill(adj_data7[peak_j-25+j]);
               }
            }
         }
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
      }
      
      t.Fill();
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      base_hist1->Reset();
      base_hist7->Reset();
      
   }
   
   fclose(fp);

   TCanvas *c2 = new TCanvas("c2","c2",1600,800);
   c2->SetLeftMargin(0.15);
   c2->Divide(2,1);

   for(int i=0; i<200; i++){
      template_data1[i] = template_hist1[i]->GetMean();
      template_data7[i] = template_hist7[i]->GetMean();
   }

   c2->cd(1);
   TGraph *gr1 = new TGraph(60,time2,template_data1);
   gr1->SetLineColor(2);
   gr1->SetMarkerColor(2);
   gr1->SetTitle("Template Wave1");
   gr1->GetXaxis()->SetTitle("time [ns]");
   gr1->GetYaxis()->SetTitle("volt [mV]");
   gr1->Draw("AC*");

   c2->cd(2);
   TGraph *gr2 = new TGraph(60,time2,template_data7);
   gr2->SetLineColor(4);
   gr2->SetMarkerColor(4);
   gr2->SetTitle("Template Wave7");
   gr2->GetXaxis()->SetTitle("time [ns]");
   gr2->GetYaxis()->SetTitle("volt [mV]");
   gr2->Draw("AC*");
   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s_TemplateFit.root",run_number);
   
   TFile file2(rootfile,"recreate");

   t.Write();
   gr1->Write("Template1");
   gr2->Write("Template7");

   file2.Close();
}
