
void WaveCheck(char *run_number,char *ped_number){

   gROOT->Reset();

   char filename[40];
   sprintf(filename,"../raw_data/%s.dat",run_number);
   
   char filename2[40];
   sprintf(filename2,"../Root_File/%s_ped.root",ped_number);
   
   TFile f(filename2);
   
   double ch1_pedy[1024];
   double ch2_pedy[1024];
   double ch3_pedy[1024];
   double ch4_pedy[1024];
   double ch5_pedy[1024];
   double ch6_pedy[1024];
   double ch7_pedy[1024];
   double ch8_pedy[1024];
   double ch9_pedy[1024];
   double ch10_pedy[1024];
   double ch11_pedy[1024];
   double ch12_pedy[1024];
   double ch13_pedy[1024];
   double ch14_pedy[1024];
   double ch15_pedy[1024];
   double ch16_pedy[1024];
   
   for (int i=0; i<1024; i++) {
      ch1_pedy[i]  = ped_graph1->Eval(i,0,"");
      ch2_pedy[i]  = ped_graph2->Eval(i,0,"");
      ch3_pedy[i]  = ped_graph3->Eval(i,0,"");
      ch4_pedy[i]  = ped_graph4->Eval(i,0,"");
      ch5_pedy[i]  = ped_graph5->Eval(i,0,"");
      ch6_pedy[i]  = ped_graph6->Eval(i,0,"");
      ch7_pedy[i]  = ped_graph7->Eval(i,0,"");
      ch8_pedy[i]  = ped_graph8->Eval(i,0,"");
      ch9_pedy[i]  = ped_graph9->Eval(i,0,"");
      ch10_pedy[i] = ped_graph10->Eval(i,0,"");
      ch11_pedy[i] = ped_graph11->Eval(i,0,"");
      ch12_pedy[i] = ped_graph12->Eval(i,0,"");
      ch13_pedy[i] = ped_graph13->Eval(i,0,"");
      ch14_pedy[i] = ped_graph14->Eval(i,0,"");
      ch15_pedy[i] = ped_graph15->Eval(i,0,"");
      ch16_pedy[i] = ped_graph16->Eval(i,0,"");
      
      if (((i+1)%100)==0) {
         printf("%d times pedestal data read\n",i);
      }
   }
      
   f.Close();
   
   FILE *fp;
   if ((fp = fopen(filename,"rb+"))==NULL){
      printf("File open Error\n");
      return -1;
   }
   
   TTree t("t","t");
   
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;
   
   double data7[1024];
   double alldata7;
   double basedata7;
   double min_peak;
   
   t.Branch("data7",  data7,  "data7[1024]/D" );

   Double_t tmp_data;
   Double_t time[1024];
   
   t.Branch("time", time, "time[1024]/D_t");

   Double_t d_i;
   d_i = 0.0;

   for (int i=0; i<1024; i++) {
      time[i] = (d_i * 1920.0) / 2048.0 ;
      d_i     = d_i + 1.0;
   }
   
   int k;
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
      
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      /* Data Packet Read */
      hitnum = Length/2060;
      int cap_point;

      alldata7 = 0.0 ;
      
      for (int i=0; i<hitnum; i++) {
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,data_length,fp);
         
         if (ch_num==6) {
            for (int j=0; j<readnum; j=j+2) {
               int n = j/2;
               if ((n+stop_ch)>=1024) {
                  cap_point = n + stop_ch -1024 ;
               } else {
                  cap_point = n + stop_ch       ;
               }
               tmp_data = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF) ;
               data7[n] = (tmp_data - ch7_pedy[cap_point]) * (1000.0 / 4096.0) / 0.985;
               if ((499<n)&&(n<600)) {
                  alldata7 = alldata7 + data7[n] ;
               }
            }
            basedata7 = alldata7 / 100.0 ;
            min_peak  = basedata7 ; 
            for (int j=0; j<1024; j++) {
               data7[j] = data7[j] - basedata7 ;
               if (j>0) {
                  if (min_peak > data7[j]) {
                     min_peak = data7[j];
                  }
               }
            }
         }
         
         printf("min peak is %lf\n",min_peak);
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         totalread += readnum;
         
      }
      
      t.Fill();
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      totalread += readnum;
      
      k = k + 1;
      if ((k%100)==0) {
         printf("%d times finished\n",k);
      }
   }
   
   fclose(fp);
   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s_wave.root",run_number);
   
   TFile file(rootfile,"recreate");
   t.Write();
   file.Close();
}
