
#include "TestDAQ.h"

#define SiTCP_IP "192.168.10.15"
#define SiTCP_Port 24
#define BUFLENGTH 33000 // 2060*16+4*5 = 32980

///////////////////////////////////////////////////////////////////////////////////////////
// time calc
///////////////////////////////////////////////////////////////////////////////////////////
#define TIME_SEC2NSEC   1000000000 
unsigned long long GetRealTimeInterval(const  struct timespec *pFrom, const struct timespec *pTo)
{
   unsigned long long  llStart = (unsigned long long )((unsigned long long )pFrom->tv_sec*TIME_SEC2NSEC + (unsigned long long )pFrom->tv_nsec);
   unsigned long long  llEnd = (unsigned long long )((unsigned long long )pTo->tv_sec*TIME_SEC2NSEC + (unsigned long long )pTo->tv_nsec);
   return( (llEnd - llStart)/1000 );
}

int main(int argc, char *argv[])
{
   struct sockaddr_in sitcpaddr ;
   
   int    sock        ;
   int    EventNumber ;
   int    ChainNumber ;
   
   unsigned char RecvBuffer[BUFLENGTH] ;
   
   if (argc != 4) {
      printf("Usage : %s <Num of Run> <Num of Event> <Num of Chain>\n", argv[0]);
      return -1;
   }
   
   if ((EventNumber = atoi(argv[2])) <= 0) {
      printf("Num of Event : Please input positive number\n");
      return -1;
   }

   if ((ChainNumber = atoi(argv[3])) <= 0) {
      printf("Num of Event : Please input positive number\n");
      return -1;
   }
   
   int   TCP_PORT ;
   char *TCP_IP   ;
   
   TCP_PORT = SiTCP_Port ;
   TCP_IP   = SiTCP_IP   ;
   
   /* open binary file */
   char filename[32] ;
   
   sprintf(filename, "../raw_data/%s.dat", argv[1]);
   
   FILE *file ;
   
   if ((file = fopen(filename,"wb")) == NULL) {
      printf("File Open Error\n");
      return -1;
   }
   
   /* make socket */
   if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      perror("socket");
      fclose(file);
      return -1;
   }
   
   printf("Event Number : %d\n",EventNumber);
   printf("Chain Number : %d\n",ChainNumber);
   
   /* socket configuration */
   memset(&sitcpaddr, 0, sizeof(sitcpaddr));
   
   sitcpaddr.sin_family      = AF_INET;
   sitcpaddr.sin_port        = htons(TCP_PORT);
   sitcpaddr.sin_addr.s_addr = inet_addr(TCP_IP);
   
   /* connect server */
   if (connect(sock, (struct sockaddr *)&sitcpaddr, sizeof(sitcpaddr)) < 0) {
      perror("connect");
      fclose(file);
      return -1;
   }
   
   printf("connect ok\n");
   
   struct timespec tsStart,tsEnd;
   
   unsigned long long allReadBytes = 0;
   
   int i,j,k ;

   int fBytes ;
   int fBytes2;
   int rBytes ;

   int MagicWord;
   int TYPE_all;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   for (i=0; i<EventNumber; i++) {
      for (k=0; k<ChainNumber; k++) {
         
         if (i==0) {
            if ((k+1)==ChainNumber) {
               printf("wait for edge of chain on\n");
            }
         }
         
         rBytes = 0;
         fBytes = 0;
         
         /* Magic Word Read */
         for (j=0; j<4; j++) {
            rBytes  = recv(sock, RecvBuffer+fBytes, 1, 0) ;
            fBytes += rBytes ;
         }
         
         MagicWord = ((RecvBuffer[0]<<24) + (RecvBuffer[1]<<16) + (RecvBuffer[2]<<8) + RecvBuffer[3]);
         
         if (MagicWord==0x89ABCDEF) {
//            printf("Magic Word : 0x%X \n",MagicWord);
         } else {
            printf("Magic Word Read Failed\n");
            fclose(file);
            close(sock);
            return -1;
         }
         
         /* TYPE Read */
         for (j=0; j<4; j++) {
            rBytes  = recv(sock, RecvBuffer+fBytes, 1, 0) ;
            fBytes += rBytes ;
         }
         
         TYPE_all = ((RecvBuffer[4]<<24) + (RecvBuffer[5]<<16) + (RecvBuffer[6]<<8) + RecvBuffer[7]);
         TYPE     = (((0x000000)<<8) + RecvBuffer[4]);
         
         if (TYPE==0xFF) {
//            printf("TYPE : 0x%X \n",TYPE);
//            printf("TYPE ALL : 0x%X \n",TYPE);
         } else {
            printf("TYPE Read Failed\n");
            fclose(file);
            close(sock);
            return -1;
         }
         
         /* Length Read */
         for (j=0; j<4; j++) {
            rBytes  = recv(sock, RecvBuffer+fBytes, 1, 0) ;
            fBytes += rBytes ;
         }
         
         Length = ((RecvBuffer[8]<<24) + (RecvBuffer[9]<<16) + (RecvBuffer[10]<<8) + RecvBuffer[11]);
//         printf("Length : %d \n",Length);
         
         /* Event ID Read */
         for (j=0; j<4; j++) {
            rBytes  = recv(sock, RecvBuffer+fBytes, 1, 0) ;
            fBytes += rBytes ;
         }
         
         EventID = ((RecvBuffer[12]<<24) + (RecvBuffer[13]<<16) + (RecvBuffer[14]<<8) + RecvBuffer[15]);
//         printf("Event ID : %d \n",EventID);
         
         fBytes2 = 0;
         
         /* Data Read */
         while(fBytes2<Length) {
            if ((rBytes = recv(sock, RecvBuffer+fBytes+fBytes2, Length-fBytes2, 0)) <= 0){
               printf("recv failed\n");
               fclose(file);
               close(sock);
               return -1;
            }
            fBytes2 += rBytes ;
         }
         
         //printf("Data read Byte : %d\n",fBytes2);
         
         //fwrite(&RecvBuffer,sizeof(unsigned char),fBytes+fBytes2,file);
         
         /* Trailer Read */
         for (j=0; j<4; j++) {
            rBytes  = recv(sock, RecvBuffer+fBytes+fBytes2, 1, 0) ;
            fBytes += rBytes ;
         }
         
         Trailer = ((RecvBuffer[fBytes+fBytes2-4]<<24) + (RecvBuffer[fBytes+fBytes2-3]<<16) + (RecvBuffer[fBytes+fBytes2-2]<<8) + RecvBuffer[fBytes+fBytes2-1]);
         
         if (Trailer==0xFEDCBA98) {
//            printf("Trailer : 0x%X \n",Trailer);
         } else {
            printf("Trailer Failed\n");
            fclose(file);
            close(sock);
            return -1;
         }
         
         fwrite(&RecvBuffer,sizeof(unsigned char),fBytes+fBytes2,file);
         
         allReadBytes = allReadBytes + fBytes + fBytes2 ;
      }
      
      if (i==0) {
         printf("Time Start\n");
         clock_gettime(CLOCK_REALTIME,&tsStart);
         allReadBytes = 0;
      }
      
      if (((i+1)%100)==0) {
         printf("%d times \n",i);
      }
   }
   
   clock_gettime(CLOCK_REALTIME,&tsEnd);
   printf("Time Stop\n");
   
   unsigned long long llusec = GetRealTimeInterval(&tsStart,&tsEnd);
   
   printf("read time(us) : %llu\n",llusec);
   printf("read bytes    : %u\n"  ,allReadBytes);
   
   printf("read rate = %gMbps\n", (double)(allReadBytes*8)/llusec);
   
   fclose(file);
   close(sock);
   
   printf("Finishi %s\n", argv[1]);
   
}
