
void TestRootHist(char *run_number){

   gROOT->Reset();

   char filename[32];
   sprintf(filename,"../raw_data/%s.dat",run_number);

   FILE *fp;
   if ((fp = fopen(filename,"rb+"))==NULL){
      printf("File open Error\n");
      return -1;
   }
   
   TTree t("t","t");
   
   /*    */
   unsigned int  readnum;
   unsigned long long int totalread;
   unsigned char rawdata[33000];

   /*  Header/Footer Packet  */
   int MagicWord;
   int TYPE;
   unsigned int Length;
   unsigned int EventID;
   int Trailer;

   /*  Data Packet  */
   int hitnum;
   int DataType;
   int board_num;
   int ch_num;
   int stop_ID;
   int stop_ch;
   int data_length;
   int keyword;
   int status;
   int checksum;

   int data0[1024];
   int data1[1024];
   int data2[1024];
   int data3[1024];
   int data4[1024];
   int data5[1024];
   int data6[1024];
   int data7[1024];
   int data8[1024];
   int data9[1024];
   int data10[1024];
   int data11[1024];
   int data12[1024];
   int data13[1024];
   int data14[1024];
   int data15[1024];

   int check_data0[1024];
   t.Branch("check_data0" , check_data0,  "check_data0[1024]/I"  );
   
   t.Branch("data0" , data0,  "data0[1024]/I"  );
   t.Branch("data1" , data1,  "data1[1024]/I"  );
   t.Branch("data2" , data2,  "data2[1024]/I"  );
   t.Branch("data3" , data3,  "data3[1024]/I"  );
   t.Branch("data4" , data4,  "data4[1024]/I"  );
   t.Branch("data5" , data5,  "data5[1024]/I"  );
   t.Branch("data6" , data6,  "data6[1024]/I"  );
   t.Branch("data7" , data7,  "data7[1024]/I"  );
   t.Branch("data8" , data8,  "data8[1024]/I"  );
   t.Branch("data9" , data9,  "data9[1024]/I"  );
   t.Branch("data10", data10, "data10[1024]/I" );
   t.Branch("data11", data11, "data11[1024]/I" );
   t.Branch("data12", data12, "data12[1024]/I" );
   t.Branch("data13", data13, "data13[1024]/I" );
   t.Branch("data14", data14, "data14[1024]/I" );
   t.Branch("data15", data15, "data15[1024]/I" );
   
   int stop_num1;
   int stop_num2;
   
   t.Branch("stop_num1", &stop_num1, "stop_num1/I");
   t.Branch("stop_num2", &stop_num2, "stop_num2/I");
   
   int k;
   
   while (1) {
      totalread = 0;
      
      /* Magic Word Read */
      readnum   = fread(rawdata,1,4,fp);
      MagicWord = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (readnum==0) {
         break;
      } else if (readnum!=4) {
         fclose(fp);
         printf("Magic Word Read Error.\n");
         return -1;
      }
      
      printf("Magic Word : 0x%x \n",MagicWord);
      //char strMagicWord[10];
      //sprintf(strMagicWord,"%d",MagicWord);
      
      /*if (MagicWord=="89abcdef") {
         printf("Magic Word 0x%x is OK.\n",MagicWord);
      } else if (MagicWord!="89abcdef") {
         printf("Magic Word Failed. 0x%x\n",MagicWord);
         fclose(fp);
         return -1;
      }*/
      
      totalread += readnum;
      
      /* TYPE Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      TYPE    = (((rawdata[totalread]&0xFF)<<16) + ((rawdata[totalread+1]&0xFF)<<8) + (rawdata[totalread+2]&0xFF));

      printf("TYPE : 0x%x \n",TYPE);
      
      /*if (TYPE==0xFF0000) {
         printf("TYPE 0x%x is OK.\n",TYPE);
      }*/
      
      totalread += readnum;
      
      /* Length Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Length  = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      printf("Length is %d.\n",Length);
      
      totalread += readnum;
      
      /* Event ID Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      EventID = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      printf("Event ID is %d.\n",EventID);
      
      totalread += readnum;
      
      //printf("Total Read (Header) Number is %d.\n",totalread);
      
      /* Data Packet Read */
      hitnum = Length/2060;
      printf("Hit Channel Number is %d.\n",hitnum);
      
      for (int i=0; i<hitnum; i++) {
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         DataType = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         printf("Data Type : 0x%x\n",DataType);
         totalread += readnum;
         
         readnum   = fread(rawdata+totalread,1,2,fp);
         board_num = (rawdata[totalread]&0xFF);
         ch_num    = (rawdata[totalread+1]&0xFF);
         printf("Board Number : %d\n",board_num);
         printf("Channel Number : %d\n",ch_num+1);
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         stop_ID = ((rawdata[totalread]&0xFC)>>2);
         stop_ch = (((rawdata[totalread]&0x03)<<8) + (rawdata[totalread+1]&0xFF));
         printf("Stop ID : %d\n",stop_ID);
         printf("Stop Number : %d\n",stop_ch);
         totalread += readnum;
         
         readnum     = fread(rawdata+totalread,1,2,fp);
         data_length = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         printf("Data Length : %d\n",data_length);
         totalread += readnum;
         
         printf("Total Read (Packet Header) Number is %d.\n",totalread);
         
         readnum = fread(rawdata+totalread,1,data_length,fp);


         if (ch_num==0) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data0[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
               check_data0[n] = ((rawdata[totalread+j]&0xFF)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==1) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data1[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==2) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data2[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==3) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data3[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==4) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data4[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==5) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data5[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==6) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data6[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==7) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data7[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
            stop_num1 = stop_ch;
         } else if (ch_num==8) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data8[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==9) {
            for (int j=0; j<readnum; j=j+2) {
               int n    = j/2;
               data9[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==10) {
            for (int j=0; j<readnum; j=j+2) {
               int n     = j/2;
               data10[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==11) {
            for (int j=0; j<readnum; j=j+2) {
               int n     = j/2;
               data11[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==12) {
            for (int j=0; j<readnum; j=j+2) {
               int n     = j/2;
               data12[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==13) {
            for (int j=0; j<readnum; j=j+2) {
               int n     = j/2;
               data13[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==14) {
            for (int j=0; j<readnum; j=j+2) {
               int n     = j/2;
               data14[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
         } else if (ch_num==15) {
            for (int j=0; j<readnum; j=j+2) {
               int n     = j/2;
               data15[n] = ((rawdata[totalread+j]&0x0F)<<8) + (rawdata[totalread+j+1]&0xFF);
            }
            stop_num2 = stop_ch;
         }
         
         totalread += readnum;
         
         readnum = fread(rawdata+totalread,1,2,fp);
         keyword = (((rawdata[totalread]&0xFF)<<8) + (rawdata[totalread+1]&0xFF));
         printf("Key Word : 0x%x\n",keyword);
         totalread += readnum;
         
         readnum  = fread(rawdata+totalread,1,2,fp);
         status   = (rawdata[totalread]&0xFF);
         checksum = (rawdata[totalread+1]&0xFF);
         printf("Status : 0x%x\n",status);
         printf("Check Sum : 0x%x\n",checksum);
         totalread += readnum;

         /*if (ch_num==7) {
            printf("Stop Number : %d\n",stop_ch);
            stop_num1 = stop_ch;
         } else if (ch_num==15) {
            printf("Stop Number : %d\n",stop_ch);
            stop_num2 = stop_ch;
         }  */
      }
      
      t.Fill();
      
      /* Trailer Read */
      readnum = fread(rawdata+totalread,1,4,fp);
      Trailer = (((rawdata[totalread]&0xFF)<<24) + ((rawdata[totalread+1]&0xFF)<<16) + ((rawdata[totalread+2]&0xFF)<<8) + (rawdata[totalread+3]&0xFF));
      
      if (Trailer==0xFEDCBA98) {
         printf("Trailer 0x%x is OK.\n",Trailer);
      }
      
      totalread += readnum;
      
      k = k + 1;
      if ((k%100)==0) {
         printf("%d times finished\n",k);
      }
   }

   fclose(fp);
   t.SetAlias("time","Iteration$");
   t.SetAlias("Eve","Entry$");
   
   char rootfile[32];
   sprintf(rootfile,"../Root_File/%s.root",run_number);
   
   TFile file(rootfile,"recreate");
   t.Write();
   file.Close();
   
}

